/*
 * Decompiled with CFR 0.152.
 */
package echopointng.tree.test;

import echopointng.Tree;
import echopointng.tree.DefaultMutableTreeNode;
import echopointng.tree.DefaultTreeModel;
import echopointng.tree.TreePath;
import echopointng.tree.test.LargeLazyTreeModel;
import echopointng.tree.test.LargeLazyTreeNode;
import junit.framework.TestCase;

public class TreeTest
extends TestCase {
    public void testLargeModel() {
        LargeLazyTreeModel model = new LargeLazyTreeModel();
        Tree tree = new Tree(model);
        LargeLazyTreeNode root = (LargeLazyTreeNode)model.getRoot();
        TreeTest.assertNotNull((Object)root);
        TreePath path = new TreePath(model.getPathToRoot(root));
        TreeTest.assertTrue((boolean)tree.isExpanded(path));
        int cc = model.getChildCount(root);
        TreeTest.assertTrue((cc > 0 ? 1 : 0) != 0);
        TreeTest.assertNotNull((Object)model.getChild(root, cc - 1));
        TreeTest.assertNotNull((Object)model.getChild(root, 0));
    }

    public void testRootExpanded() {
        LargeLazyTreeModel model = new LargeLazyTreeModel();
        Tree tree = new Tree();
        tree.setRootAutoExpanded(false);
        tree.setModel(model);
        LargeLazyTreeNode root = (LargeLazyTreeNode)model.getRoot();
        TreePath rootPath = new TreePath(model.getPathToRoot(root));
        TreeTest.assertFalse((boolean)tree.isRootAutoExpanded());
        TreeTest.assertFalse((boolean)tree.isExpanded(rootPath));
        TreeTest.assertTrue((model.getDepth() == 1 ? 1 : 0) != 0);
        TreeTest.assertTrue((model.getChildCreates() == 0 ? 1 : 0) != 0);
        tree.expandPath(rootPath);
        TreeTest.assertTrue((boolean)tree.isExpanded(rootPath));
        TreeTest.assertTrue((model.getDepth() == 2 ? 1 : 0) != 0);
        TreeTest.assertTrue((model.getChildCreates() == 1 ? 1 : 0) != 0);
        LargeLazyTreeNode node = (LargeLazyTreeNode)model.getChild(root, 0);
        node = (LargeLazyTreeNode)model.getChild(node, 0);
        TreeTest.assertTrue((model.getDepth() == 3 ? 1 : 0) != 0);
        TreeTest.assertTrue((model.getChildCreates() == 2 ? 1 : 0) != 0);
        model = new LargeLazyTreeModel();
        tree = new Tree();
        tree.setModel(model);
        root = (LargeLazyTreeNode)model.getRoot();
        rootPath = new TreePath(model.getPathToRoot(root));
        TreeTest.assertTrue((boolean)tree.isRootAutoExpanded());
        TreeTest.assertTrue((boolean)tree.isExpanded(rootPath));
        TreeTest.assertTrue((model.getDepth() == 1 ? 1 : 0) != 0);
        TreeTest.assertTrue((model.getChildCreates() == 0 ? 1 : 0) != 0);
    }

    public void testTreeRows() {
        int totalNodeCount = 1;
        DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode("root");
        for (int i = 0; i < 5; ++i) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode("child" + i);
            parentNode.add(childNode);
            ++totalNodeCount;
            for (int j = 0; j < 5; ++j) {
                DefaultMutableTreeNode grandChildNode = new DefaultMutableTreeNode("grandchild" + j);
                childNode.add(grandChildNode);
                ++totalNodeCount;
                for (int k = 0; k < 5; ++k) {
                    DefaultMutableTreeNode greatGrandChildNode = new DefaultMutableTreeNode("greatgrandchild" + k);
                    grandChildNode.add(greatGrandChildNode);
                    ++totalNodeCount;
                }
            }
        }
        DefaultTreeModel fivebyThreeModel = new DefaultTreeModel(parentNode);
        parentNode = new DefaultMutableTreeNode("root");
        for (int i = 0; i < 2; ++i) {
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode("child" + i);
            parentNode.add(childNode);
            for (int j = 0; j < 2; ++j) {
                DefaultMutableTreeNode grandChildNode = new DefaultMutableTreeNode("grandchild" + j);
                childNode.add(grandChildNode);
            }
        }
        DefaultTreeModel twobytwoModel = new DefaultTreeModel(parentNode);
        DefaultTreeModel onebyoneModel = new DefaultTreeModel(new DefaultMutableTreeNode("root"));
        Tree tree = new Tree(fivebyThreeModel);
        tree.expandAll();
        TreeTest.assertEquals((int)tree.getRowCount(), (int)156);
        tree = new Tree(onebyoneModel);
        TreeTest.assertEquals((int)tree.getRowCount(), (int)1);
        tree = new Tree(twobytwoModel);
        TreeTest.assertEquals((int)tree.getRowCount(), (int)3);
        tree.expandAll();
        TreeTest.assertEquals((int)tree.getRowCount(), (int)7);
        tree.collapseAll();
        TreeTest.assertEquals((int)tree.getRowCount(), (int)1);
        tree = new Tree(fivebyThreeModel);
        tree.expandAll();
        TreeTest.assertNotNull((Object)tree.getPathForRow(2));
        TreeTest.assertNotNull((Object)tree.getPathForRow(155));
        TreeTest.assertNull((Object)tree.getPathForRow(156));
        TreePath path = tree.getPathForRow(2);
        tree.collapsePath(path);
        TreePath path2 = tree.getPathForRow(3);
        TreeTest.assertFalse((boolean)path.equals(path2));
    }
}

