/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.ColorChooser;
import echopointng.EPNG;
import echopointng.model.ColorSwatchModel;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.RenderingContext;
import echopointng.util.ColorKit;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class ColorChooserPeer
implements ComponentSynchronizePeer,
ActionProcessor {
    public static final Service CC_SERVICE = JavaScriptService.forResource((String)"EPNG.ColorChooser", (String)"/echopointng/ui/resource/js/colorchooser.js");

    public String getContainerId(Component component) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String name = actionElement.getAttribute("name");
        String value = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, name, (Object)value);
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(CC_SERVICE.getId());
        this.renderInitDirective(new RenderingContext(rc, update, component), targetId, component);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(CC_SERVICE.getId());
        this.renderDisposeDirective(rc, component);
    }

    private void renderDisposeDirective(RenderContext rc, Component component) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("preremove", "EPColorChooser.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)update.getParent()));
        this.renderAdd(rc, update, targetId, update.getParent());
        return true;
    }

    private void renderInitDirective(RenderingContext rc, String containerId, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        String elementId = ContainerInstance.getElementId((Component)component);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.appendPartDirective("update", "EPColorChooser.MessageProcessor", "init");
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemizedUpdateElement.appendChild(itemElement);
        itemElement.setAttribute("eid", elementId);
        itemElement.setAttribute("container-eid", containerId);
        itemElement.setAttribute("swatchesPerRow", String.valueOf(rc.getRP("swatchesPerRow", fallbackStyle, 17)));
        itemElement.setAttribute("enabled", String.valueOf(component.isRenderEnabled()));
        itemElement.setAttribute("serverNotify", String.valueOf(true));
        ColorChooser chooser = (ColorChooser)component;
        Color currentColor = chooser.getSelectedColor();
        if (currentColor != null) {
            itemElement.setAttribute("currentColorSelection", ColorKit.makeCSSColor(currentColor));
        }
        itemElement.setAttribute("showCurrentColorSelectionSwatch", String.valueOf(true));
        itemElement.setAttribute("currentColorSelectionText", "Current Selection : ");
        ColorSwatchModel swatchModel = (ColorSwatchModel)rc.getRP("swatchModel");
        if (swatchModel != null) {
            Color[] colors = swatchModel.getColorSwatches();
            if (colors == null) {
                colors = new Color[]{};
            }
            StringBuffer sbColors = new StringBuffer();
            StringBuffer sbColorTitles = new StringBuffer();
            for (int i = 0; i < colors.length; ++i) {
                Color color = colors[i];
                String colorStr = ColorKit.makeCSSColor(color);
                sbColors.append(colorStr);
                String desc = swatchModel.getColorDescription(color);
                sbColorTitles.append(desc != null ? desc : colorStr);
                if (i >= colors.length - 1) continue;
                sbColors.append('|');
                sbColorTitles.append('|');
            }
            itemElement.setAttribute("colors", sbColors.toString());
            itemElement.setAttribute("colorTitles", sbColorTitles.toString());
        } else {
            itemElement.setAttribute("colors", "");
            itemElement.setAttribute("colorTitles", "");
        }
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        itemElement.setAttribute("styleDefault", style.renderInline());
        style = new CssStyleEx();
        ExtentRender.renderToStyle((CssStyle)style, (String)"width", (Extent)((Extent)rc.getRP("swatchWidth", fallbackStyle)));
        ExtentRender.renderToStyle((CssStyle)style, (String)"height", (Extent)((Extent)rc.getRP("swatchHeight", fallbackStyle)));
        style.setAttribute("border", "1px solid #000000;");
        itemElement.setAttribute("styleSwatch", style.renderInline());
    }

    static {
        WebRenderServlet.getServiceRegistry().add(CC_SERVICE);
    }
}

