/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.DateChooser;
import echopointng.EPNG;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointPeer;
import echopointng.ui.util.CssRolloverStyleEx;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.LayoutStrut;
import echopointng.ui.util.RenderingContext;
import echopointng.util.FontKit;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DateChooserPeer
extends AbstractEchoPointPeer
implements ActionProcessor,
PropertyUpdateProcessor {
    public static final Service DATECHOOSER_SERVICE = JavaScriptService.forResource((String)"EPNG.DateChooser", (String)"/echopointng/ui/resource/js/datechooser.js");

    public DateChooserPeer() {
        this.partialUpdateManager.add("displayedDate", new PartialUpdateParticipant(){

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPDateChooser.MessageProcessor", "datesChanged", new String[0], new String[0]);
                Element itemElement = rc.getServerMessage().getDocument().createElement("item");
                itemizedUpdateElement.appendChild(itemElement);
                DateChooser dc = (DateChooser)update.getParent();
                Calendar cal = dc.getDisplayedDate();
                itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)dc));
                if (cal != null) {
                    itemElement.setAttribute("displayedDate", DateChooserPeer.this.toYearMonthDayStr(cal));
                }
            }

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
        this.partialUpdateManager.add("selectedDate", new PartialUpdateParticipant(){

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPDateChooser.MessageProcessor", "datesChanged", new String[0], new String[0]);
                Element itemElement = rc.getServerMessage().getDocument().createElement("item");
                itemizedUpdateElement.appendChild(itemElement);
                DateChooser dc = (DateChooser)update.getParent();
                Calendar cal = dc.getSelectedDate();
                itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)dc));
                if (cal != null) {
                    itemElement.setAttribute("selectedDate", DateChooserPeer.this.toYearMonthDayStr(cal));
                }
            }

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String name = actionElement.getAttribute("name");
        String value = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, name, (Object)value);
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String name = propertyElement.getAttribute("name");
        if ("displayedDate".equals(name)) {
            String value = DomUtil.getElementText((Element)propertyElement);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, name, (Object)value);
        }
    }

    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        Element directiveXML = this.createInitDirectiveItem(rc, component, fallbackStyle);
        this.createInitDirective(rc, component, directiveXML);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(DATECHOOSER_SERVICE);
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        Element calTABLE = rc.createE("table");
        calTABLE.setAttribute("id", rc.getElementId());
        rc.addStandardWebSupport(calTABLE);
        calTABLE.setAttribute("border", "0");
        calTABLE.setAttribute("cellpadding", "0");
        calTABLE.setAttribute("cellspacing", "0");
        calTABLE.setAttribute("style", style.renderInline());
        Element tbody = rc.createE("tbody");
        calTABLE.appendChild(tbody);
        Element calTR = rc.createE("tr");
        tbody.appendChild(calTR);
        Element calTD = this.renderNavBar(rc, component, fallbackStyle, directiveXML);
        calTR.appendChild(calTD);
        calTR = rc.createE("tr");
        tbody.appendChild(calTR);
        calTD = this.renderCalendarBar(component, rc, fallbackStyle, directiveXML);
        calTR.appendChild(calTD);
        if (rc.getRP("selectionDisplayBarVisible", fallbackStyle, true)) {
            calTR = rc.createE("tr");
            tbody.appendChild(calTR);
            calTD = this.renderSelectionBar(component, rc, fallbackStyle, directiveXML);
            calTR.appendChild(calTD);
        }
        parent.appendChild(calTABLE);
    }

    protected void createInitDirective(RenderingContext rc, Component component, Element itemXML) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EPDateChooser.MessageProcessor", "init", new String[0], new String[0]);
        itemizedUpdateElement.appendChild(itemXML);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        return super.renderUpdate(rc, update, targetId);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(DATECHOOSER_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPDateChooser.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected Element createInitDirectiveItem(RenderingContext rc, Component component, Style fallbackStyle) {
        String elementId = rc.getElementId();
        Element itemElement = rc.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        itemElement.setAttribute("enabled", String.valueOf(component.isRenderEnabled()));
        itemElement.setAttribute("fastMode", String.valueOf(rc.getRP("fastMode", fallbackStyle, true)));
        itemElement.setAttribute("yearRange", String.valueOf(rc.getRP("yearRange", fallbackStyle, 30)));
        itemElement.setAttribute("navigationInhibited", String.valueOf(rc.getRP("navigationInhibited", fallbackStyle, false)));
        DateChooser chooser = (DateChooser)component;
        Calendar cal = chooser.getSelectedDate();
        if (cal != null) {
            itemElement.setAttribute("selectedDate", this.toYearMonthDayStr(cal));
        }
        if ((cal = this.getDisplayedDate(chooser)) != null) {
            itemElement.setAttribute("displayedDate", this.toYearMonthDayStr(cal));
        }
        cal = cal != null ? cal : Calendar.getInstance(component.getLocale());
        int firstDayOfWeek = cal.getFirstDayOfWeek();
        itemElement.setAttribute("firstDayOfWeek", String.valueOf(rc.getRP("firstDayOfWeek", fallbackStyle, firstDayOfWeek)));
        cal = chooser.getMaximumDate();
        if (cal != null) {
            itemElement.setAttribute("maximumDate", this.toYearMonthDayStr(cal));
        }
        if ((cal = chooser.getMinimumDate()) != null) {
            itemElement.setAttribute("minimumDate", this.toYearMonthDayStr(cal));
        }
        StringBuffer monthNames = new StringBuffer();
        String[] monthNamesArr = this.createMonthNames(rc, component);
        for (int i = 0; i < monthNamesArr.length; ++i) {
            monthNames.append(monthNamesArr[i]);
            if (i == monthNamesArr.length - 1) continue;
            monthNames.append("|");
        }
        itemElement.setAttribute("monthNames", String.valueOf(monthNames));
        CssRolloverStyleEx styleInMonth = new CssRolloverStyleEx();
        styleInMonth.setAttribute("text-align", "center");
        styleInMonth.setBackground((Color)rc.getRP("calendarBackground", fallbackStyle));
        styleInMonth.setForeground((Color)rc.getRP("calendarForeground", fallbackStyle));
        styleInMonth.setFont((Font)rc.getRP("calendarFont", fallbackStyle));
        styleInMonth.setBorder((Border)rc.getRP("calendarBorder", fallbackStyle));
        styleInMonth.setRolloverBackground((Color)rc.getRP("calendarRolloverBackground", fallbackStyle));
        styleInMonth.setRolloverForeground((Color)rc.getRP("calendarRolloverForeground", fallbackStyle));
        styleInMonth.setRolloverBorder((Border)rc.getRP("calendarRolloverBorder", fallbackStyle));
        itemElement.setAttribute("styleInMonth", styleInMonth.renderInline());
        itemElement.setAttribute("styleInMonthRollover", styleInMonth.renderRolloverSupportInline());
        CssRolloverStyleEx styleOutOfMonth = new CssRolloverStyleEx();
        styleOutOfMonth.setAttribute("text-align", "center");
        styleOutOfMonth.setBackground((Color)rc.getRP("calendarBackground", fallbackStyle));
        styleOutOfMonth.setForeground((Color)rc.getRP("calendarNonMonthForeground", fallbackStyle));
        styleOutOfMonth.setFont((Font)rc.getRP("calendarFont", fallbackStyle));
        styleOutOfMonth.setBorder((Border)rc.getRP("calendarBorder", fallbackStyle));
        styleOutOfMonth.setRolloverBackground((Color)rc.getRP("calendarRolloverBackground", fallbackStyle));
        styleOutOfMonth.setRolloverForeground((Color)rc.getRP("calendarRolloverForeground", fallbackStyle));
        styleOutOfMonth.setRolloverBorder((Border)rc.getRP("calendarRolloverBorder", fallbackStyle));
        itemElement.setAttribute("styleOutOfMonth", styleOutOfMonth.renderInline());
        itemElement.setAttribute("styleOutOfMonthRollover", styleOutOfMonth.renderRolloverSupportInline());
        CssRolloverStyleEx styleNotSelectable = new CssRolloverStyleEx();
        styleNotSelectable.setAttribute("text-align", "center");
        styleNotSelectable.setAttribute("cursor", "not-allowed");
        styleNotSelectable.setBackground((Color)rc.getRP("calendarBackground", fallbackStyle));
        styleNotSelectable.setForeground((Color)rc.getRP("calendarNonMonthForeground", fallbackStyle));
        styleNotSelectable.setFont((Font)rc.getRP("calendarFont", fallbackStyle));
        styleNotSelectable.setBorder((Border)rc.getRP("calendarBorder", fallbackStyle));
        itemElement.setAttribute("styleNotSelectable", styleNotSelectable.renderInline());
        itemElement.setAttribute("styleNotSelectableRollover", styleNotSelectable.renderRolloverSupportInline());
        CssRolloverStyleEx styleSelectedDate = new CssRolloverStyleEx();
        styleSelectedDate.setAttribute("text-align", "center");
        styleSelectedDate.setBackground((Color)rc.getRP("calendarSelectedBackground", fallbackStyle));
        styleSelectedDate.setForeground((Color)rc.getRP("calendarSelectedForeground", fallbackStyle));
        styleSelectedDate.setFont((Font)rc.getRP("calendarSelectedFont", fallbackStyle));
        styleSelectedDate.setBorder((Border)rc.getRP("calendarSelectedBorder", fallbackStyle));
        styleSelectedDate.setRolloverBackground((Color)rc.getRP("calendarRolloverBackground", fallbackStyle));
        styleSelectedDate.setRolloverForeground((Color)rc.getRP("calendarRolloverForeground", fallbackStyle));
        styleSelectedDate.setBorder((Border)rc.getRP("calendarRolloverBorder", fallbackStyle));
        itemElement.setAttribute("styleSelectedDate", styleSelectedDate.renderInline());
        itemElement.setAttribute("styleSelectedDateRollover", styleSelectedDate.renderRolloverSupportInline());
        CssRolloverStyleEx styleSelection = new CssRolloverStyleEx();
        styleSelection.setAttribute("text-align", "center");
        styleSelection.setBackground((Color)rc.getRP("selectedBackground", fallbackStyle));
        styleSelection.setForeground((Color)rc.getRP("selectedForeground", fallbackStyle));
        styleSelection.setFont((Font)rc.getRP("selectedFont", fallbackStyle));
        styleSelection.setRolloverBackground((Color)rc.getRP("selectedRolloverBackground", fallbackStyle));
        styleSelection.setRolloverForeground((Color)rc.getRP("selectedRolloverForeground", fallbackStyle));
        itemElement.setAttribute("styleSelection", styleSelection.renderInline());
        itemElement.setAttribute("styleSelectionRollover", styleSelection.renderRolloverSupportInline());
        return itemElement;
    }

    private String toYearMonthDayStr(Calendar cal) {
        if (cal != null) {
            String s = new SimpleDateFormat("yyyyMMdd").format(cal.getTime());
            return s;
        }
        return null;
    }

    private Element renderCalendarBar(Component component, RenderingContext rc, Style fallbackStyle, Element directiveXML) {
        boolean hasWeekNumber;
        String alignment = "center";
        Element calOutsideTD = rc.createE("td");
        CssStyleEx style = new CssStyleEx();
        style.setBackground((Color)rc.getRP("calendarBackground", fallbackStyle));
        style.setForeground((Color)rc.getRP("calendarForeground", fallbackStyle));
        style.setFont((Font)rc.getRP("calendarFont", fallbackStyle));
        style.setAttribute("text-align", alignment);
        style.setAttribute("width", "100%");
        calOutsideTD.setAttribute("style", style.renderInline());
        style = new CssStyleEx();
        style.setBackground((Color)rc.getRP("calendarBackground", fallbackStyle));
        style.setForeground((Color)rc.getRP("calendarForeground", fallbackStyle));
        style.setFont(FontKit.addBold((Font)rc.getRP("calendarFont", fallbackStyle)));
        style.setAttribute("text-align", alignment);
        style.setAttribute("cursor", "auto");
        String calStyleDayHeadersName = style.renderInline();
        style = new CssStyleEx();
        style.setBackground((Color)rc.getRP("calendarBackground", fallbackStyle));
        style.setForeground((Color)rc.getRP("calendarForeground", fallbackStyle));
        style.setFont(FontKit.addBold((Font)rc.getRP("calendarFont", fallbackStyle)));
        style.setAttribute("text-align", alignment);
        style.setAttribute("cursor", "auto");
        String calStyleWeekNumberHeadersName = style.renderInline();
        style = new CssStyleEx();
        style.setBackground((Color)rc.getRP("calendarBackground", fallbackStyle));
        style.setForeground((Color)rc.getRP("weekNumberForeground", fallbackStyle));
        style.setFont(FontKit.addBold((Font)rc.getRP("calendarFont", fallbackStyle)));
        style.setAttribute("text-align", alignment);
        style.setAttribute("cursor", "auto");
        String calStyleWeekNumberName = style.renderInline();
        DateChooser dateChooser = (DateChooser)component;
        Calendar maxCal = (Calendar)rc.getRP("maximumDate");
        Calendar minCal = (Calendar)rc.getRP("minimumDate");
        Calendar selectedDate = dateChooser.getSelectedDate();
        Calendar displayedDate = this.getDisplayedDate(dateChooser);
        Calendar rollingDisplayedDate = DateChooser.calendarCopy(displayedDate);
        rollingDisplayedDate.setTime(displayedDate.getTime());
        rollingDisplayedDate.setTimeZone(displayedDate.getTimeZone());
        int firstDayOfWeek = displayedDate.getFirstDayOfWeek();
        firstDayOfWeek = rc.getRP("firstDayOfWeek", fallbackStyle, firstDayOfWeek);
        int prevMonthDays = 0;
        Element calTABLE = rc.createE("table");
        calOutsideTD.appendChild(calTABLE);
        calTABLE.setAttribute("border", "0");
        calTABLE.setAttribute("width", "100%");
        calTABLE.setAttribute("cellpadding", "1");
        calTABLE.setAttribute("cellspacing", "1");
        Element tbody = rc.createE("tbody");
        calTABLE.appendChild(tbody);
        Element calTR = rc.createE("tr");
        tbody.appendChild(calTR);
        rollingDisplayedDate.set(5, 1);
        int changingDOW = rollingDisplayedDate.get(7);
        while (changingDOW != firstDayOfWeek) {
            rollingDisplayedDate.add(5, -1);
            changingDOW = rollingDisplayedDate.get(7);
            ++prevMonthDays;
        }
        Locale locale = component.getLocale() == null ? Locale.getDefault() : component.getLocale();
        SimpleDateFormat df = new SimpleDateFormat("EEE", locale);
        String dowName = null;
        String weekNumberAbbreviation = (String)rc.getRP("weekNumberAbbreviation", fallbackStyle);
        boolean bl = hasWeekNumber = weekNumberAbbreviation != null;
        if (hasWeekNumber) {
            this.createTextTD(weekNumberAbbreviation, calTR, calStyleWeekNumberHeadersName);
        }
        int dowThatStartsCal = rollingDisplayedDate.get(7);
        Calendar dayNamesCal = Calendar.getInstance(locale);
        dayNamesCal.set(7, dowThatStartsCal);
        dowName = this.createDowName(rc, component, df.format(dayNamesCal.getTime()));
        this.createTextTD(dowName, calTR, calStyleDayHeadersName);
        dayNamesCal.add(7, 1);
        dowName = this.createDowName(rc, component, df.format(dayNamesCal.getTime()));
        this.createTextTD(dowName, calTR, calStyleDayHeadersName);
        dayNamesCal.add(7, 1);
        dowName = this.createDowName(rc, component, df.format(dayNamesCal.getTime()));
        this.createTextTD(dowName, calTR, calStyleDayHeadersName);
        dayNamesCal.add(7, 1);
        dowName = this.createDowName(rc, component, df.format(dayNamesCal.getTime()));
        this.createTextTD(dowName, calTR, calStyleDayHeadersName);
        dayNamesCal.add(7, 1);
        dowName = this.createDowName(rc, component, df.format(dayNamesCal.getTime()));
        this.createTextTD(dowName, calTR, calStyleDayHeadersName);
        dayNamesCal.add(7, 1);
        dowName = this.createDowName(rc, component, df.format(dayNamesCal.getTime()));
        this.createTextTD(dowName, calTR, calStyleDayHeadersName);
        dayNamesCal.add(7, 1);
        dowName = this.createDowName(rc, component, df.format(dayNamesCal.getTime()));
        this.createTextTD(dowName, calTR, calStyleDayHeadersName);
        dayNamesCal.add(7, 1);
        for (int row = 0; row < 6; ++row) {
            Element td;
            calTR = rc.createE("tr");
            tbody.appendChild(calTR);
            if (hasWeekNumber) {
                Calendar woyDate = DateChooser.calendarCopy(rollingDisplayedDate, locale);
                if (row == 0) {
                    // empty if block
                }
                td = this.createTextTD(String.valueOf(woyDate.get(3)), calTR, calStyleWeekNumberName);
                td.setAttribute("id", rc.getElementId() + "|" + row + "|woy");
            }
            for (int col = 0; col < 7; ++col) {
                boolean isSelectable = true;
                if (!this.isDateInRange(rollingDisplayedDate, minCal, maxCal)) {
                    isSelectable = false;
                }
                boolean inSameMonth = rollingDisplayedDate.get(2) == displayedDate.get(2);
                String styleToUse = directiveXML.getAttribute("styleInMonth");
                if (!inSameMonth) {
                    styleToUse = directiveXML.getAttribute("styleOutOfMonth");
                }
                if (selectedDate != null && rollingDisplayedDate.getTime().equals(selectedDate.getTime())) {
                    styleToUse = directiveXML.getAttribute("styleSelectedDate");
                }
                if (!isSelectable) {
                    styleToUse = directiveXML.getAttribute("styleNotSelectable");
                }
                String dofm = String.valueOf(rollingDisplayedDate.get(5));
                td = this.createTextTD(dofm, calTR, styleToUse);
                td.setAttribute("id", rc.getElementId() + "|" + row + "|" + col);
                rollingDisplayedDate.add(5, 1);
            }
        }
        return calOutsideTD;
    }

    private boolean isDateInRange(Calendar cal, Calendar minCal, Calendar maxCal) {
        boolean ok = true;
        if (maxCal != null && cal.after(maxCal)) {
            return false;
        }
        if (minCal != null && cal.before(minCal)) {
            return false;
        }
        return ok;
    }

    private void renderMonth(RenderingContext rc, Component component, Element parent, Style fallbackStyle, Calendar displayedDate) {
        Locale locale = component.getLocale() == null ? Locale.getDefault() : component.getLocale();
        boolean isMonthSelectable = rc.getRP("monthSelectable", fallbackStyle, true);
        CssStyleEx style = new CssStyleEx();
        style.setBackground((Color)rc.getRP("navigationBackground", fallbackStyle));
        style.setForeground((Color)rc.getRP("navigationForeground", fallbackStyle));
        style.setFont((Font)rc.getRP("navigationFont", fallbackStyle));
        String styleName = style.renderInline();
        Element select = rc.createE("select");
        if (!isMonthSelectable) {
            select = rc.createE("span");
            String monthName = new SimpleDateFormat("MMMM", locale).format(displayedDate.getTime());
            select.appendChild(rc.createText(this.createMonthName(rc, monthName)));
        }
        parent.appendChild(select);
        select.setAttribute("style", styleName);
        String id = rc.getElementId() + "|month";
        select.setAttribute("id", id);
        if (!component.isRenderEnabled()) {
            select.setAttribute("disabled", "disabled");
        }
    }

    private void renderYear(RenderingContext rc, Component component, Element parent, Style fallbackStyle, Calendar displayedDate) {
        Locale locale = component.getLocale() == null ? Locale.getDefault() : component.getLocale();
        boolean isYearSelectable = rc.getRP("yearSelectable", fallbackStyle, false);
        CssStyleEx style = new CssStyleEx();
        style.setBackground((Color)rc.getRP("navigationBackground", fallbackStyle));
        style.setForeground((Color)rc.getRP("navigationForeground", fallbackStyle));
        style.setFont((Font)rc.getRP("navigationFont", fallbackStyle));
        String styleName = style.renderInline();
        Element select = rc.createE("select");
        if (!isYearSelectable) {
            select = rc.createE("span");
            String yearName = new SimpleDateFormat("yyyy", locale).format(displayedDate.getTime());
            select.appendChild(rc.createText(yearName));
        }
        parent.appendChild(select);
        select.setAttribute("style", styleName);
        String id = rc.getElementId() + "|year";
        select.setAttribute("id", id);
        if (!component.isRenderEnabled()) {
            select.setAttribute("disabled", "disabled");
        }
    }

    private Element renderNavBar(RenderingContext rc, Component component, Style fallbackStyle, Element directiveXML) {
        DateChooser dateChooser = (DateChooser)component;
        Calendar displayedDate = this.getDisplayedDate(dateChooser);
        CssRolloverStyleEx styleNavArrows = new CssRolloverStyleEx();
        ImageReference icon = (ImageReference)rc.getRP("navigationBackwardImage", fallbackStyle);
        Element bwdImgE = ImageManager.createImgE(rc, styleNavArrows, icon);
        bwdImgE.setAttribute("id", rc.getElementId() + "|bwd");
        icon = (ImageReference)rc.getRP("navigationForwardImage", fallbackStyle);
        Element fwdImgE = ImageManager.createImgE(rc, styleNavArrows, icon);
        fwdImgE.setAttribute("id", rc.getElementId() + "|fwd");
        CssStyleEx style = new CssStyleEx();
        style.setBackground((Color)rc.getRP("navigationBackground", fallbackStyle));
        style.setForeground((Color)rc.getRP("navigationForeground", fallbackStyle));
        style.setFont((Font)rc.getRP("navigationFont", fallbackStyle));
        style.setNoWrap();
        String styleName = style.renderInline();
        Element navOutsideTD = rc.createE("td");
        navOutsideTD.setAttribute("style", styleName);
        Element navTABLE = rc.createE("table");
        navOutsideTD.appendChild(navTABLE);
        navTABLE.setAttribute("border", "0");
        navTABLE.setAttribute("cellpadding", "3");
        navTABLE.setAttribute("cellspacing", "1");
        Element tbody = rc.createE("tbody");
        navTABLE.appendChild(tbody);
        Element navTR = rc.createE("tr");
        tbody.appendChild(navTR);
        Element navTD = rc.createE("td");
        navTR.appendChild(navTD);
        navTD.setAttribute("align", "left");
        navTD.setAttribute("style", styleName);
        if (rc.getRP("navigationArrowsVisible", fallbackStyle, true)) {
            navTD.appendChild(bwdImgE);
        }
        navTD = rc.createE("td");
        navTR.appendChild(navTD);
        navTD.setAttribute("align", "center");
        navTD.setAttribute("width", "100%");
        navTD.setAttribute("style", styleName);
        this.renderMonth(rc, component, navTD, fallbackStyle, displayedDate);
        navTD.appendChild(LayoutStrut.createStrut((RenderContext)rc, 10, 1));
        this.renderYear(rc, component, navTD, fallbackStyle, displayedDate);
        navTD = rc.createE("td");
        navTR.appendChild(navTD);
        navTD.setAttribute("align", "right");
        navTD.setAttribute("style", styleName);
        if (rc.getRP("navigationArrowsVisible", fallbackStyle, true)) {
            navTD.appendChild(fwdImgE);
        }
        return navOutsideTD;
    }

    private Element renderSelectionBar(Component component, RenderingContext rc, Style fallbackStyle, Element directiveXML) {
        String styleName = directiveXML.getAttribute("styleSelection");
        Element selOutsideTD = rc.createE("td");
        selOutsideTD.setAttribute("align", "center");
        selOutsideTD.setAttribute("style", styleName);
        Element selTABLE = rc.createE("table");
        selOutsideTD.appendChild(selTABLE);
        selTABLE.setAttribute("border", "0");
        selTABLE.setAttribute("cellpadding", "3");
        selTABLE.setAttribute("cellspacing", "1");
        selTABLE.setAttribute("style", "width:100%");
        Element tbody = rc.createE("tbody");
        selTABLE.appendChild(tbody);
        Element selTR = rc.createE("tr");
        tbody.appendChild(selTR);
        Element selTD = rc.createE("td");
        selTR.appendChild(selTD);
        selTD.setAttribute("align", "center");
        selTD.setAttribute("style", styleName);
        selTD.setAttribute("id", rc.getElementId() + "|sel");
        DateChooser dateChooser = (DateChooser)component;
        Calendar selectedDate = dateChooser.getSelectedDate();
        if (selectedDate != null) {
            Locale locale = component.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            DateFormat df = DateFormat.getDateInstance(2, locale);
            String dtStr = df.format(selectedDate.getTime());
            selTD.appendChild(rc.createText(dtStr));
        }
        return selOutsideTD;
    }

    private String createDowName(RenderingContext rc, Component component, String string) {
        int maxLen = rc.getRP("dowNameLength", 3);
        if (string == null || string.length() <= maxLen) {
            return string;
        }
        string = string.substring(0, maxLen);
        return string;
    }

    private Element createTextTD(String text, Element tr, String styleName) {
        Element calTD = tr.getOwnerDocument().createElement("td");
        tr.appendChild(calTD);
        calTD.appendChild(tr.getOwnerDocument().createTextNode(text));
        calTD.setAttribute("style", styleName);
        return calTD;
    }

    private String createMonthName(RenderingContext rc, String string) {
        int maxLen = rc.getRP("monthNameLength", 3);
        if (string == null || string.length() <= maxLen) {
            return string;
        }
        string = string.substring(0, maxLen);
        return string;
    }

    private String[] createMonthNames(RenderingContext rc, Component component) {
        String[] monthNames = new String[12];
        Locale locale = component.getLocale() == null ? Locale.getDefault() : component.getLocale();
        Calendar cal = Calendar.getInstance(locale);
        cal.set(5, 1);
        for (int month = 0; month <= 11; ++month) {
            cal.set(2, month);
            String monthName = new SimpleDateFormat("MMMM", locale).format(cal.getTime());
            monthNames[month] = this.createMonthName(rc, monthName);
        }
        return monthNames;
    }

    protected Calendar getDisplayedDate(DateChooser dateChooser) {
        Calendar displayedDate;
        Locale locale = dateChooser.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((displayedDate = dateChooser.getDisplayedDate()) == null) {
            displayedDate = Calendar.getInstance(locale);
        }
        return DateChooser.calendarCopy(displayedDate, locale);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(DATECHOOSER_SERVICE);
    }
}

