/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.partialupdate.BorderUpdate;
import nextapp.echo2.webcontainer.partialupdate.ColorUpdate;
import nextapp.echo2.webcontainer.partialupdate.InsetsUpdate;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GroupBoxPeer
extends AbstractEchoPointContainerPeer {
    public GroupBoxPeer() {
        this.partialUpdateManager.add("border", (PartialUpdateParticipant)new BorderUpdate("border", null, "border"));
        this.partialUpdateManager.add("foreground", (PartialUpdateParticipant)new ColorUpdate("foreground", null, "color"));
        this.partialUpdateManager.add("background", (PartialUpdateParticipant)new ColorUpdate("background", null, "backgroundColor"));
        this.partialUpdateManager.add("insets", (PartialUpdateParticipant)new InsetsUpdate("insets", null, "padding"));
    }

    public void renderHtml(RenderingContext rc, Node parentNode, Component component) {
        int i;
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        boolean hasIEbackgroundPaddingQuirk = false;
        if (Render.isClientIE6(rc)) {
            if (style.getAttribute("background-color") != null) {
                hasIEbackgroundPaddingQuirk = true;
            }
            if (style.getAttribute("margin-top") != null || style.getAttribute("margin") != null) {
                hasIEbackgroundPaddingQuirk = true;
            }
        }
        if (hasIEbackgroundPaddingQuirk) {
            style.setAttribute("position", "relative");
        }
        Element fs = rc.createE("fieldset");
        parentNode.appendChild(fs);
        fs.setAttribute("id", rc.getElementId());
        fs.setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(fs);
        Label title = (Label)rc.getRP("titleLabel", fallbackStyle);
        if (title != null && title.getText() != null && title.getText().length() > 0) {
            Element eLegend = rc.createE("legend");
            if (hasIEbackgroundPaddingQuirk) {
                eLegend.setAttribute("style", "position:absolute; top:-0.5em; left:0.5em");
            }
            fs.appendChild(eLegend);
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), eLegend, (Component)title);
        }
        Component[] children = component.getVisibleComponents();
        int n = i = title == null ? 0 : 1;
        while (i < children.length) {
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), fs, children[i]);
            ++i;
        }
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.renderUpdateRemoveChildren(rc, update);
            if (update.hasUpdatedProperties()) {
                this.partialUpdateManager.process(rc, update);
            }
            this.renderUpdateAddChildren(rc, update);
        }
        return fullReplace;
    }
}

