/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.HistoryMonitor;
import echopointng.history.HistoryState;
import echopointng.ui.resource.Resources;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HistoryMonitorPeer
implements ComponentSynchronizePeer,
ActionProcessor {
    public static final Service HISTORY_MONITOR_SERVICE = JavaScriptService.forResource((String)"EPNG.HistoryMonitor", (String)"/echopointng/ui/resource/js/historymonitor.js");
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public HistoryMonitorPeer() {
        this.partialUpdateManager.add("historyChanged", new PartialUpdateParticipant(){

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                Document doc = rc.getServerMessage().getDocument();
                HistoryMonitor historyMonitor = (HistoryMonitor)update.getParent();
                List pendingHistory = historyMonitor.getPendingHistory();
                if (pendingHistory.isEmpty()) {
                    return;
                }
                Element itemElement = doc.createElement("item");
                itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)historyMonitor));
                Iterator iter = pendingHistory.iterator();
                while (iter.hasNext()) {
                    HistoryState undoRedo = (HistoryState)iter.next();
                    Element historyElement = doc.createElement("history");
                    historyElement.setAttribute("historyHash", undoRedo.historyHash());
                    itemElement.appendChild(historyElement);
                }
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPHistoryMonitor.MessageProcessor", "addHistory", new String[0], new String[0]);
                itemizedUpdateElement.appendChild(itemElement);
            }
        });
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String actionName = actionElement.getAttribute("name");
        String actionValue = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, actionName, (Object)actionValue);
    }

    public String getContainerId(Component child) {
        throw new IllegalStateException("HistoryMonitorPeer does not support children directly.  Use AbstractEchoPointContainerPeer instead");
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        this.createInitDirective(rc, component);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        if (update.hasUpdatedProperties() && this.partialUpdateManager.canProcess(rc, update)) {
            this.partialUpdateManager.process(rc, update);
        }
        return true;
    }

    protected void createInitDirective(RenderContext rc, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(HISTORY_MONITOR_SERVICE.getId());
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EPHistoryMonitor.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(HISTORY_MONITOR_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPHistoryMonitor.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(HISTORY_MONITOR_SERVICE);
    }
}

