/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.ImageMap;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.RenderingContext;
import java.util.Iterator;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImageMapPeer
extends AbstractEchoPointPeer
implements ActionProcessor {
    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String actionName = actionElement.getAttribute("name");
        String actionValue = actionElement.getAttribute("value");
        ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, actionName, (Object)actionValue);
    }

    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        ImageReference mapImageRef = (ImageReference)rc.getRP("image", fallbackStyle);
        if (mapImageRef == null) {
            return;
        }
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        Element containerE = rc.createE("bdo");
        containerE.setAttribute("id", rc.getElementId());
        parent.appendChild(containerE);
        Element imgE = ImageManager.createImgE(rc, mapImageRef);
        rc.addStandardWebSupport(imgE);
        containerE.appendChild(imgE);
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        imgE.setAttribute("style", style.renderInline());
        imgE.setAttribute("usemap", "#" + rc.getElementId() + "Map");
        Element mapE = rc.createE("map");
        containerE.appendChild(mapE);
        mapE.setAttribute("name", rc.getElementId() + "Map");
        ImageMap imageMap = (ImageMap)component;
        Iterator it = imageMap.getCoords().iterator();
        while (it.hasNext()) {
            Element areaE = rc.createE("area");
            mapE.appendChild(areaE);
            String coordStr = "";
            Map.Entry me = (Map.Entry)it.next();
            ImageMap.Coords coords = (ImageMap.Coords)me.getValue();
            int coordType = coords.getType();
            if (coordType == 1) {
                areaE.setAttribute("shape", "circle");
                coordStr = "" + coords.getX() + "," + coords.getY() + "," + coords.getRadius();
            } else if (coordType == 2) {
                areaE.setAttribute("shape", "poly");
                int[] arr = coords.getPolygonCoords();
                for (int i = 0; i < arr.length; ++i) {
                    coordStr = coordStr + arr[i];
                    if (i >= arr.length - 1) continue;
                    coordStr = coordStr + ",";
                }
            } else {
                areaE.setAttribute("shape", "rect");
                coordStr = "" + coords.getLeft() + "," + coords.getTop() + "," + coords.getRight() + "," + coords.getBottom();
            }
            areaE.setAttribute("coords", coordStr);
            String altText = coords.getAltText();
            if (altText != null) {
                areaE.setAttribute("title", altText);
            }
            String actionCommand = coords.getActionCommand();
            String jsCommand = "javascript:EP.Event.hrefActionHandler('" + rc.getElementId() + "','" + actionCommand + "',null)";
            if (component.isRenderEnabled()) {
                areaE.setAttribute("href", jsCommand);
                continue;
            }
            areaE.setAttribute("nohref", "nohref");
        }
    }
}

