/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.LabelEx;
import echopointng.ListSection;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.xhtml.XhtmlFragment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.text.TextComponent;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ListSectionPeer
extends AbstractEchoPointContainerPeer
implements Comparator {
    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        CssStyleEx styleList = new CssStyleEx(component, fallbackStyle);
        this.createListStyle(rc, styleList, fallbackStyle);
        String listOrdering = null;
        ListModel model = (ListModel)rc.getRP("model");
        if (model == null) {
            return;
        }
        int listSize = model.size();
        ArrayList<Object> theList = new ArrayList<Object>(listSize);
        for (int i = 0; i < listSize; ++i) {
            theList.add(model.get(i));
        }
        if (rc.getRP("ordering", fallbackStyle, 1) == 1) {
            listOrdering = "ul";
        } else {
            listOrdering = "ol";
            Collections.sort(theList, this);
        }
        Element listE = rc.createE(listOrdering);
        parent.appendChild(listE);
        listE.setAttribute("id", rc.getElementId());
        listE.setAttribute("style", styleList.renderInline());
        rc.addStandardWebSupport(listE);
        for (int i = 0; i < theList.size(); ++i) {
            Object listObject = theList.get(i);
            if (listObject instanceof Component) {
                Component child = (Component)listObject;
                if (!child.isRenderVisible()) continue;
                this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), listE, child);
                continue;
            }
            Element listItemE = rc.createE("li");
            listE.appendChild(listItemE);
            if (listObject instanceof XhtmlFragment) {
                XhtmlFragment fragment = (XhtmlFragment)listObject;
                CssStyle style = Render.itsDisplayLayoutData((RenderContext)rc, fragment);
                if (Render.isClientIE6(rc)) {
                    style.setAttribute("zoom", "1");
                }
                try {
                    Node[] nodes = fragment.toDOM(rc.getDocument());
                    for (int j = 0; j < nodes.length; ++j) {
                        listItemE.appendChild(nodes[j]);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("The XhtmlFragment is not valid XHTML : " + fragment.getFragment(), e);
                }
            }
            listItemE.appendChild(rc.createText(String.valueOf(listObject)));
        }
    }

    public int compare(Object o1, Object o2) {
        String s1 = this.getObjectText(o1);
        String s2 = this.getObjectText(o2);
        return s1.compareTo(s2);
    }

    private void createListStyle(RenderingContext rc, CssStyleEx style, Style fallbackStyle) {
        ImageReference image = (ImageReference)rc.getRP("bulletsImage", fallbackStyle);
        if (image != null) {
            String imgUri = ImageManager.getURI(rc, image);
            style.setAttribute("list-style-image", "url(\"" + imgUri + "\")");
            style.setAttribute("list-style-type", "none");
        } else {
            String bullets = "";
            int bulletsValue = rc.getRP("bullets", fallbackStyle, 0);
            switch (bulletsValue) {
                case 1: {
                    bullets = "disc";
                    break;
                }
                case 2: {
                    bullets = "circle";
                    break;
                }
                case 3: {
                    bullets = "square";
                    break;
                }
                case 4: {
                    bullets = "decimal";
                    break;
                }
                case 5: {
                    bullets = "decimal-leading-zero";
                    break;
                }
                case 6: {
                    bullets = "lower-roman";
                    break;
                }
                case 7: {
                    bullets = "upper-roman";
                    break;
                }
                case 12: {
                    bullets = "upper-latin";
                    break;
                }
                case 11: {
                    bullets = "lower-latin";
                    break;
                }
                case 10: {
                    bullets = "lower-greek";
                    break;
                }
                case 9: {
                    bullets = "upper-alpha";
                    break;
                }
                case 8: {
                    bullets = "lower-alpha";
                    break;
                }
                default: {
                    bullets = "none";
                }
            }
            style.setAttribute("list-style-type", bullets);
        }
    }

    private String getObjectText(Object o) {
        if (o instanceof AbstractButton) {
            return ((AbstractButton)o).getText();
        }
        if (o instanceof TextComponent) {
            return ((TextComponent)o).getText();
        }
        if (o instanceof LabelEx) {
            return ((LabelEx)o).getText();
        }
        if (o instanceof SelectField) {
            return ((SelectField)o).getSelectedItem().toString();
        }
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    protected Element renderReplaceableChild(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component child) {
        Element containerTagElement = parentNode.getOwnerDocument().createElement("li");
        String containerId = this.getContainerId(child);
        containerTagElement.setAttribute("id", containerId);
        parentNode.appendChild(containerTagElement);
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)syncPeer).renderHtml(rc, update, (Node)containerTagElement, child);
        } else {
            syncPeer.renderAdd(rc, update, containerId, child);
        }
        CssStyle style = Render.itsDisplayLayoutData(rc, child);
        Render.itsDisplayLayoutData(rc, child, containerTagElement);
        if (child instanceof ListSection && Render.isClientIE6(rc)) {
            style.setAttribute("zoom", "1");
        }
        if (style.hasAttributes()) {
            containerTagElement.setAttribute("style", style.renderInline());
        }
        return containerTagElement;
    }
}

