/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.Menu;
import echopointng.MenuItem;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.ui.util.TriCellTable;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MenuItemPeer
extends AbstractEchoPointContainerPeer
implements ActionProcessor {
    public static final Service MENU_ITEM_SERVICE = JavaScriptService.forResource((String)"EPNG.MenuItem", (String)"/echopointng/ui/resource/js/menu.js");

    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("MenuItem does not support children.");
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "input_click", null);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(MENU_ITEM_SERVICE.getId());
        this.renderDisposeDirective(rc.getServerMessage(), ContainerInstance.getElementId((Component)component));
    }

    public void renderHtml(RenderingContext rc, Node parentNode, Component component) {
        Element menuItemContent = this.renderAsMenuItem(rc, component);
        parentNode.appendChild(menuItemContent);
    }

    public Element renderAsMenuItem(RenderingContext rc, Component component) {
        TriCellTable tct;
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(MENU_ITEM_SERVICE);
        String elementId = rc.getElementId();
        Element contentNode = null;
        String text = (String)rc.getRP("text", fallbackStyle);
        Text textNode = text == null ? null : rc.getServerMessage().getDocument().createTextNode(text);
        Element iconElement = null;
        String iconProperyName = component.isRenderEnabled() ? "icon" : "disabledIcon";
        ImageReference icon = (ImageReference)rc.getRP(iconProperyName, fallbackStyle);
        if (icon != null) {
            iconElement = ImageManager.createImgE(rc, new CssStyle(), icon);
            iconElement.setAttribute("id", elementId + "_Icon");
        }
        int visibleComponentCount = component.getVisibleComponentCount();
        Element subMenuImageElement = null;
        int subMenuImageAlignment = 5;
        if (component instanceof Menu && visibleComponentCount > 0 && (icon = (ImageReference)rc.getRP("submenuImage", fallbackStyle)) != null) {
            subMenuImageAlignment = rc.getRP("submenuImageAlignment", subMenuImageAlignment);
            CssStyleEx submenuStyle = null;
            Border subMenuImageBorder = null;
            if (rc.getRP("submenuImageBordered", fallbackStyle, true)) {
                subMenuImageBorder = (Border)rc.getRP("menuBorder", fallbackStyle);
            }
            if (subMenuImageBorder != null) {
                submenuStyle = new CssStyleEx();
                BorderRender.renderToStyle((CssStyle)submenuStyle, (Border)subMenuImageBorder);
            }
            subMenuImageElement = ImageManager.createImgE(rc, null, icon);
        }
        Extent iconTextMargin = (Extent)rc.getRP("iconTextMargin", fallbackStyle);
        Alignment textPosition = (Alignment)rc.getRP("textPosition", fallbackStyle);
        int triTableOrientation = this.convertIconTextPositionToOrientation(textPosition, component);
        if (subMenuImageElement == null) {
            tct = new TriCellTable(rc.getDocument(), elementId, triTableOrientation, iconTextMargin);
        } else {
            int subMenuOrientation = 0;
            if (subMenuImageAlignment == 3) {
                subMenuOrientation = 1;
            }
            tct = new TriCellTable(rc.getDocument(), elementId, triTableOrientation, iconTextMargin, subMenuOrientation, iconTextMargin);
        }
        if (textNode != null) {
            this.renderCellText(rc, tct, textNode, component, 0, fallbackStyle);
        }
        if (iconElement != null) {
            iconElement.setAttribute("id", elementId + "Icon");
            this.renderCellIcon(tct, iconElement, 1);
        }
        if (subMenuImageElement != null) {
            subMenuImageElement.setAttribute("id", elementId + "SubMenuIMG");
            this.renderCellIcon(tct, subMenuImageElement, 2);
        }
        contentNode = tct.getTableElement();
        CssStyleEx baseCssStyle = new CssStyleEx(component, fallbackStyle);
        Render.asFillImage(baseCssStyle, component, "backgroundImage", fallbackStyle, rc);
        if (!component.isRenderEnabled()) {
            Render.asColors(baseCssStyle, component, "disabledBackground", "disabledForeground", fallbackStyle);
            Render.asFont(baseCssStyle, component, "disabledFont", fallbackStyle);
            Render.asBorder(baseCssStyle, component, "disabledBorder", fallbackStyle);
            Render.asFillImage(baseCssStyle, component, "disabledBackgroundImage", fallbackStyle, rc);
        }
        if (!rc.getRP("lineWrap", fallbackStyle, false)) {
            baseCssStyle.setAttribute("white-space", "nowrap");
        }
        Element menuItemOuterE = rc.createE("div");
        menuItemOuterE.setAttribute("style", baseCssStyle.renderInline());
        AlignmentRender.renderToElement((Element)menuItemOuterE, (Alignment)((Alignment)rc.getRP("alignment")));
        rc.addStandardWebSupport(menuItemOuterE);
        if (contentNode != null) {
            menuItemOuterE.appendChild(contentNode);
        }
        this.createMenuItemInitDirective(rc, component, fallbackStyle);
        if (component instanceof Menu) {
            menuItemOuterE.setAttribute("id", elementId + "MenuItem");
            Element relativeDiv = rc.createE("div");
            relativeDiv.setAttribute("id", elementId);
            relativeDiv.setAttribute("style", "position:relative;padding:0px;margin:0px;");
            relativeDiv.appendChild(menuItemOuterE);
            return relativeDiv;
        }
        menuItemOuterE.setAttribute("id", elementId);
        return menuItemOuterE;
    }

    protected void renderCellIcon(TriCellTable tct, Element iconElement, int cellIndex) {
        Element iconTdElement = tct.getTdElement(cellIndex);
        CssStyle style = new CssStyle();
        style.setAttribute("padding", "0px");
        iconTdElement.setAttribute("style", style.renderInline());
        iconTdElement.appendChild(iconElement);
    }

    protected void renderCellText(RenderingContext rc, TriCellTable tct, Text textNode, Component component, int cellIndex, Style fallbackStyle) {
        Element textTdElement = tct.getTdElement(cellIndex);
        CssStyle textTdCssStyle = new CssStyle();
        textTdCssStyle.setAttribute("padding", "0px");
        AlignmentRender.renderToStyle((CssStyle)textTdCssStyle, (Alignment)((Alignment)rc.getRP("textAlignment")));
        if (!rc.getRP("lineWrap", fallbackStyle, false)) {
            textTdCssStyle.setAttribute("white-space", "nowrap");
        }
        textTdElement.setAttribute("style", textTdCssStyle.renderInline());
        textTdElement.appendChild(textNode);
    }

    protected int convertIconTextPositionToOrientation(Alignment alignment, Component component) {
        if (alignment == null) {
            return 1;
        }
        if (alignment.getVertical() == 0) {
            if (alignment.getHorizontal() == 3) {
                return 0;
            }
            return 1;
        }
        if (alignment.getVertical() == 6) {
            return 2;
        }
        return 3;
    }

    protected void createMenuItemInitDirective(RenderingContext rc, Component component, Style fallbackStyle) {
        MenuItem menuItem;
        ImageReference icon;
        boolean enabled = component.isRenderEnabled();
        CssStyleEx baseCssStyle = new CssStyleEx(component, fallbackStyle);
        Render.asFillImage(baseCssStyle, component, "backgroundImage", fallbackStyle, rc);
        if (!enabled) {
            Render.asColors(baseCssStyle, component, "disabledBackground", "disabledForeground", fallbackStyle);
            Render.asFont(baseCssStyle, component, "disabledFont", fallbackStyle);
            Render.asBorder(baseCssStyle, component, "disabledBorder", fallbackStyle);
            Render.asFillImage(baseCssStyle, component, "disabledBackgroundImage", fallbackStyle, rc);
        }
        if (!rc.getRP("lineWrap", fallbackStyle, false)) {
            baseCssStyle.setAttribute("white-space", "nowrap");
        }
        FillImage backgroundImage = (FillImage)rc.getRP("backgroundImage", fallbackStyle);
        boolean rolloverEnabled = rc.getRP("rolloverEnabled", fallbackStyle, false);
        boolean pressedEnabled = rc.getRP("pressedEnabled", fallbackStyle, false);
        String defaultStyle = null;
        String defaultIconUri = null;
        String rolloverStyle = null;
        String rolloverIconUri = null;
        String pressedStyle = null;
        String pressedIconUri = null;
        if (enabled && (rolloverEnabled || pressedEnabled)) {
            String iconProperyName = component.isRenderEnabled() ? "icon" : "disabledIcon";
            icon = (ImageReference)rc.getRP(iconProperyName, fallbackStyle);
            boolean hasIcon = icon != null;
            defaultStyle = baseCssStyle.renderInline();
            if (hasIcon) {
                defaultIconUri = ImageManager.getURI(rc, icon);
            }
            if (rolloverEnabled) {
                CssStyle rolloverCssStyle = new CssStyle();
                Render.asComponent(rolloverCssStyle, component, fallbackStyle);
                Render.asBorder(rolloverCssStyle, component, "rolloverBorder", fallbackStyle);
                Render.asColors(rolloverCssStyle, component, "rolloverBackground", "rolloverForeground", fallbackStyle);
                Render.asFont(rolloverCssStyle, component, "rolloverFont", fallbackStyle);
                if (!rc.getRP("lineWrap", fallbackStyle, false)) {
                    rolloverCssStyle.setAttribute("white-space", "nowrap");
                }
                if (backgroundImage != null) {
                    Render.asFillImage(rolloverCssStyle, component, "rolloverBackgroundImage", fallbackStyle, rc);
                }
                if (rolloverCssStyle.hasAttributes()) {
                    rolloverStyle = rolloverCssStyle.renderInline();
                }
                if (hasIcon && (icon = (ImageReference)rc.getRP("rolloverIcon", fallbackStyle)) != null) {
                    rolloverIconUri = ImageManager.getURI(rc, icon);
                }
            }
            if (pressedEnabled) {
                CssStyle pressedCssStyle = new CssStyle();
                Render.asBorder(pressedCssStyle, component, "pressedBorder", fallbackStyle);
                Render.asColors(pressedCssStyle, component, "pressedBackground", "pressedForeground", fallbackStyle);
                Render.asFont(pressedCssStyle, component, "pressedFont", fallbackStyle);
                if (!rc.getRP("lineWrap", fallbackStyle, false)) {
                    pressedCssStyle.setAttribute("white-space", "nowrap");
                }
                if (backgroundImage != null) {
                    Render.asFillImage(pressedCssStyle, component, "pressedBackgroundImage", fallbackStyle, rc);
                }
                if (pressedCssStyle.hasAttributes()) {
                    pressedStyle = pressedCssStyle.renderInline();
                }
                if (hasIcon && (icon = (ImageReference)rc.getRP("pressedIcon", fallbackStyle)) != null) {
                    pressedIconUri = ImageManager.getURI(rc, icon);
                }
            }
        }
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPMI.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", rc.getElementId());
        itemElement.setAttribute("etype", component.getClass().getName());
        itemElement.setAttribute("parentMenuId", ContainerInstance.getElementId((Component)component.getParent()));
        itemElement.setAttribute("enabled", String.valueOf(enabled));
        itemElement.setAttribute("visibleComponentCount", String.valueOf(component.getVisibleComponentCount()));
        if (defaultStyle != null) {
            itemElement.setAttribute("defaultStyle", defaultStyle);
        }
        if (defaultIconUri != null) {
            itemElement.setAttribute("defaultIcon", defaultIconUri);
        }
        if (rolloverStyle != null) {
            itemElement.setAttribute("rolloverStyle", rolloverStyle);
        }
        if (rolloverIconUri != null) {
            itemElement.setAttribute("rolloverIcon", rolloverIconUri);
        }
        if (pressedStyle != null) {
            itemElement.setAttribute("pressedStyle", pressedStyle);
        }
        if (pressedIconUri != null) {
            itemElement.setAttribute("pressedicon", pressedIconUri);
        }
        if ((menuItem = (MenuItem)component).hasActionListeners()) {
            itemElement.setAttribute("serverNotify", "true");
        }
        if (menuItem.getRootMenu() == component) {
            itemElement.setAttribute("isRootMenu", "true");
        }
        if (component instanceof Menu) {
            int openOption = rc.getRP("openOption", 0);
            boolean clickToOpen = openOption == 1 || openOption == 2;
            boolean submenuClickToOpen = openOption == 2;
            itemElement.setAttribute("menuAlwaysOnTop", String.valueOf(rc.getRP("menuAlwaysOnTop", fallbackStyle)));
            itemElement.setAttribute("leftOffset", String.valueOf(rc.getRP("leftOffset", fallbackStyle)));
            itemElement.setAttribute("topOffset", String.valueOf(rc.getRP("topOffset", fallbackStyle)));
            itemElement.setAttribute("horizontal", String.valueOf(rc.getRP("horizontal", fallbackStyle)));
            itemElement.setAttribute("keepAlive", String.valueOf(rc.getRP("keepAlive", fallbackStyle)));
            itemElement.setAttribute("submenuImageBordered", String.valueOf(rc.getRP("submenuImageBordered", fallbackStyle)));
            itemElement.setAttribute("clickToOpen", String.valueOf(clickToOpen));
            itemElement.setAttribute("submenuClickToOpen", String.valueOf(submenuClickToOpen));
            icon = (ImageReference)rc.getRP("submenuImage", fallbackStyle);
            if (icon != null) {
                itemElement.setAttribute("defaultSubmenuImage", ImageManager.getURI(rc, icon));
            }
            if ((icon = (ImageReference)rc.getRP("submenuRolloverImage", fallbackStyle)) != null) {
                itemElement.setAttribute("rolloverSubmenuImage", ImageManager.getURI(rc, icon));
            }
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void renderDisposeDirective(ServerMessage serverMessage, String elementId) {
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(MENU_ITEM_SERVICE.getId());
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPMI.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        itemizedUpdateElement.appendChild(itemElement);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(MENU_ITEM_SERVICE);
    }
}

