/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.Menu;
import echopointng.MenuItem;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.MenuItemPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.HtmlTable;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MenuPeer
extends MenuItemPeer {
    public String getContainerId(Component child) {
        String parentId = ContainerInstance.getElementId((Component)child.getParent());
        return parentId + "_contains_" + ContainerInstance.getElementId((Component)child);
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties()) {
            if (this.partialUpdateManager.canProcess(rc, update)) {
                this.partialUpdateManager.process(rc, update);
            } else {
                fullReplace = true;
            }
        } else if (update.hasAddedChildren()) {
            fullReplace = true;
        }
        if (fullReplace) {
            String elementId = ContainerInstance.getElementId((Component)update.getParent());
            String menuBoxId = elementId + "Box";
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)elementId);
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)menuBoxId);
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.renderUpdateRemoveChildren(rc, update);
            this.renderUpdateAddChildren(rc, update);
        }
        return fullReplace;
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        this.renderDisposeDirective(rc.getServerMessage(), ContainerInstance.getElementId((Component)component));
    }

    public void renderHtml(RenderingContext rc, Node parentNode, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(MENU_ITEM_SERVICE);
        Menu menu = (Menu)component;
        if (menu.getRootMenu() == menu) {
            this.renderRootMenu(rc, parentNode, (Component)menu, fallbackStyle);
        } else {
            this.renderMenu(rc, parentNode, (Component)menu, fallbackStyle);
        }
    }

    public void renderRootMenu(RenderingContext rc, Node parentNode, Component component, Style fallbackStyle) {
        this.createMenuItemInitDirective(rc, component, fallbackStyle);
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        Render.asFillImage(style, component, "backgroundImage", fallbackStyle, rc);
        if (!component.isRenderEnabled()) {
            Render.asColors(style, component, "disabledBackground", "disabledForeground", fallbackStyle);
            Render.asFont(style, component, "disabledFont", fallbackStyle);
            Render.asBorder(style, component, "disabledBorder", fallbackStyle);
            Render.asFillImage(style, component, "disabledBackgroundImage", fallbackStyle, rc);
        }
        if (!rc.getRP("lineWrap", fallbackStyle, false)) {
            style.setAttribute("white-space", "nowrap");
        }
        HtmlTable table = new HtmlTable(rc.getDocument(), false);
        table.setAttribute("id", rc.getElementId());
        table.setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(table.getTABLE());
        int componentBoxCount = 0;
        Component[] children = component.getVisibleComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            Element tdContainerE = rc.getRP("horizontal", fallbackStyle, false) ? table.newTD() : table.newTR();
            if (child instanceof MenuItem) {
                this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), tdContainerE, child);
                continue;
            }
            this.renderInComponentBox(rc, tdContainerE, child, componentBoxCount++);
        }
        parentNode.appendChild(table.getTABLE());
        Element menuBox = this.renderMenuBox(rc, component, fallbackStyle);
        parentNode.appendChild(menuBox);
    }

    public void renderMenu(RenderingContext rc, Node parentNode, Component component, Style fallbackStyle) {
        Element menuItemContent = this.renderAsMenuItem(rc, component);
        HtmlTable table = new HtmlTable(rc.getDocument(), false);
        int componentBoxCount = 0;
        Component[] children = component.getVisibleComponents();
        int visibleComponentCount = children.length;
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            Element tdContainerE = rc.getRP("horizontal", fallbackStyle, false) ? table.newTD() : table.newTR();
            if (child instanceof MenuItem) {
                this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), tdContainerE, child);
                continue;
            }
            this.renderInComponentBox(rc, tdContainerE, child, componentBoxCount++);
        }
        if (visibleComponentCount > 0) {
            Element menuBox = this.renderMenuBox(rc, component, fallbackStyle);
            menuBox.appendChild(table.getTABLE());
            menuItemContent.appendChild(menuBox);
        }
        if (rc.getContainerInstance().getClientProperties().getBoolean("quirkIESelectZIndex")) {
            this.addIEIframeTrick(rc, menuItemContent);
        }
        parentNode.appendChild(menuItemContent);
    }

    protected Element renderMenuBox(RenderingContext rc, Component component, Style fallbackStyle) {
        CssStyleEx style = new CssStyleEx();
        Color color = (Color)rc.getRP("menuBackground", fallbackStyle);
        if (color == null) {
            color = (Color)rc.getRP("background", fallbackStyle);
        }
        style.setBackground(color);
        color = (Color)rc.getRP("menuForeground", fallbackStyle);
        if (color == null) {
            color = (Color)rc.getRP("foreground", fallbackStyle);
        }
        style.setForeground(color);
        Render.asBorder(style, component, "menuBorder", fallbackStyle);
        Render.asInsets(style, component, "menuInsets", "padding", fallbackStyle);
        Render.asInsets(style, component, "menuOutsets", "margin", fallbackStyle);
        if (rc.getRP("menuBackgroundImage", fallbackStyle) != null) {
            Render.asFillImage(style, component, "menuBackgroundImage", fallbackStyle, rc);
        }
        style.setAttribute("position", "absolute");
        style.setAttribute("visibility", "hidden");
        style.setAttribute("display", "none");
        Render.layoutFix(rc, style);
        Element menuBox = rc.createE("div");
        menuBox.setAttribute("id", rc.getElementId() + "Box");
        menuBox.setAttribute("style", style.renderInline());
        return menuBox;
    }

    protected void renderInComponentBox(RenderingContext rc, Element parentE, Component child, int componentBoxCount) {
        String componentBoxId = rc.getElementId() + "ComponentBox" + componentBoxCount;
        Element componentBox = rc.createE("div");
        componentBox.setAttribute("id", componentBoxId);
        parentE.appendChild(componentBox);
        this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), componentBox, child);
        this.createComponentBoxInitDirective(rc, componentBoxId);
    }

    protected void createComponentBoxInitDirective(RenderingContext rc, String componentBoxId) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPMI.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", componentBoxId);
        itemElement.setAttribute("etype", "componentBox");
        itemizedUpdateElement.appendChild(itemElement);
    }

    private void addIEIframeTrick(RenderingContext rc, Element containerE) {
        String elementId = rc.getElementId();
        Element iframeQuirkIframeElement = rc.createE("iframe");
        iframeQuirkIframeElement.setAttribute("src", "javascript:false;");
        iframeQuirkIframeElement.setAttribute("frameborder", "0");
        iframeQuirkIframeElement.setAttribute("scrolling", "no");
        iframeQuirkIframeElement.setAttribute("width", "100%");
        iframeQuirkIframeElement.setAttribute("height", "100%");
        iframeQuirkIframeElement.setAttribute("style", "filter:progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)");
        CssStyleEx style = new CssStyleEx();
        style.setAttribute("position", "absolute");
        style.setAttribute("visibility", "hidden");
        style.setAttribute("z-index", "1");
        style.setAttribute("top", "0px");
        style.setAttribute("left", "0px");
        Render.layoutFix(rc, style);
        Element iframeQuirkDiv = rc.createE("div");
        iframeQuirkDiv.appendChild(iframeQuirkIframeElement);
        iframeQuirkDiv.setAttribute("id", elementId + "|IframeQuirk");
        iframeQuirkDiv.setAttribute("style", style.renderInline());
        containerE.appendChild(iframeQuirkDiv);
    }
}

