/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.PopUp;
import echopointng.able.Sizeable;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.HtmlTable;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import echopointng.ui.util.StaticImageService;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PopUpPeer
extends AbstractEchoPointContainerPeer
implements PropertyUpdateProcessor {
    public static final Service POPUP_DEFAULT_TOGGLE_IMAGE = StaticImageService.forResource("EPNG.PopUpDefaultToggleImage", "/echopointng/resource/images/dropdown_arrow.gif", new Extent(7), new Extent(7));
    public static final Service POPUP_SERVICE = JavaScriptService.forResource((String)"EPNG.PopUp", (String)"/echopointng/ui/resource/js/popup.js");

    public PopUpPeer() {
        this.partialUpdateManager.add("expanded", new PartialUpdateParticipant(){

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                PopUp popUp = (PopUp)update.getParent();
                boolean isExpanded = popUp.isExpanded();
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPPU.MessageProcessor", "expansion", new String[0], new String[0]);
                Element itemElement = rc.getServerMessage().getDocument().createElement("item");
                itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)popUp));
                itemElement.setAttribute("expanded", String.valueOf(isExpanded));
                itemizedUpdateElement.appendChild(itemElement);
            }
        });
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPPU.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemElement.setAttribute("targetId", this.findKeyTargetId(component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    protected void createInitDirective(RenderingContext rc, Component component, Style fallbackStyle) {
        CssStyleEx defaultCssStyle = new CssStyleEx(component, fallbackStyle);
        CssStyleEx defaultToggleCssStyle = new CssStyleEx();
        Render.asColors(defaultToggleCssStyle, component, "toggleBackground", null, fallbackStyle);
        Render.asBorder(defaultToggleCssStyle, component, "toggleBorder", fallbackStyle);
        Render.asInsets(defaultToggleCssStyle, component, "toggleInsets", "padding", fallbackStyle);
        CssStyleEx defaultTargetCssStyle = new CssStyleEx();
        Render.asColors(defaultTargetCssStyle, component, "targetBackground", null, fallbackStyle);
        Render.asBorder(defaultTargetCssStyle, component, "targetBorder", fallbackStyle);
        Render.asInsets(defaultTargetCssStyle, component, "targetInsets", "padding", fallbackStyle);
        boolean rolloverEnabled = rc.getRP("rolloverEnabled", fallbackStyle, false);
        boolean pressedEnabled = rc.getRP("togglePressedEnabled", fallbackStyle, false);
        ImageReference icon = (ImageReference)rc.getRP("toggleIcon", fallbackStyle);
        boolean hasIcon = icon != null;
        String defaultStyle = null;
        String rolloverStyle = null;
        String toggleDefaultStyle = null;
        String toggleDefaultIconUri = null;
        String toggleRolloverStyle = null;
        String toggleRolloverIconUri = null;
        String togglePressedStyle = null;
        String toggledPressedIconUri = null;
        String targetDefaultStyle = null;
        String targetRolloverStyle = null;
        defaultStyle = defaultCssStyle.renderInline();
        toggleDefaultStyle = defaultToggleCssStyle.renderInline();
        if (hasIcon) {
            toggleDefaultIconUri = ImageManager.getURI(rc, icon);
        }
        if (rolloverEnabled || pressedEnabled) {
            ImageReference imageRef;
            if (rolloverEnabled) {
                CssStyle rolloverCssStyle = new CssStyle();
                Render.asComponent(rolloverCssStyle, component, fallbackStyle);
                Render.asBorder(rolloverCssStyle, component, "rolloverRolloverBorder", fallbackStyle);
                Render.asColors(rolloverCssStyle, component, "rolloverBackground", null, fallbackStyle);
                if (rolloverCssStyle.hasAttributes()) {
                    rolloverStyle = rolloverCssStyle.renderInline();
                }
                CssStyle toggleRolloverCssStyle = new CssStyle();
                Render.asBorder(toggleRolloverCssStyle, component, "toggleRolloverBorder", fallbackStyle);
                Render.asColors(toggleRolloverCssStyle, component, "toggleRolloverBackground", null, fallbackStyle);
                Render.asInsets(toggleRolloverCssStyle, component, "toggleInsets", "padding", fallbackStyle);
                if (toggleRolloverCssStyle.hasAttributes()) {
                    toggleRolloverStyle = toggleRolloverCssStyle.renderInline();
                }
                if (hasIcon && (imageRef = (ImageReference)rc.getRP("toggleRolloverIcon", fallbackStyle)) != null) {
                    toggleRolloverIconUri = ImageManager.getURI(rc, imageRef);
                }
                CssStyle targetRolloverCssStyle = new CssStyle();
                Render.asBorder(targetRolloverCssStyle, component, "targetRolloverBorder", fallbackStyle);
                Render.asColors(targetRolloverCssStyle, component, "targetRolloverBackground", null, fallbackStyle);
                Render.asInsets(targetRolloverCssStyle, component, "targetInsets", "padding", fallbackStyle);
                if (targetRolloverCssStyle.hasAttributes()) {
                    targetRolloverStyle = targetRolloverCssStyle.renderInline();
                }
            }
            if (pressedEnabled) {
                CssStyle togglePressedCssStyle = new CssStyle();
                Render.asBorder(togglePressedCssStyle, component, "togglePressedBorder");
                Render.asColors(togglePressedCssStyle, component, "togglePressedBackground", null);
                Render.asInsets(togglePressedCssStyle, component, "toggleInsets", "padding", fallbackStyle);
                if (togglePressedCssStyle.hasAttributes()) {
                    togglePressedStyle = togglePressedCssStyle.renderInline();
                }
                if (hasIcon && (imageRef = (ImageReference)rc.getRP("togglePressedIcon", fallbackStyle)) != null) {
                    toggledPressedIconUri = ImageManager.getURI(rc, imageRef);
                }
            }
        }
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPPU.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", rc.getElementId());
        boolean isExpanded = ((PopUp)component).isExpanded();
        itemElement.setAttribute("expanded", String.valueOf(isExpanded));
        itemElement.setAttribute("enabled", String.valueOf(component.isRenderEnabled()));
        itemElement.setAttribute("parentId", this.findParentId(component));
        itemElement.setAttribute("keyTargetId", this.findKeyTargetId(component));
        Alignment align = (Alignment)rc.getRP("popUpAlignment", fallbackStyle);
        if (align != null) {
            itemElement.setAttribute("vAlign", String.valueOf(align.getVertical()));
            itemElement.setAttribute("hAlign", String.valueOf(align.getHorizontal()));
        }
        itemElement.setAttribute("popUpAlwaysOnTop", String.valueOf(rc.getRP("popUpAlwaysOnTop", fallbackStyle, false)));
        itemElement.setAttribute("nextToToggle", String.valueOf(rc.getRP("popUpNextToToggle", fallbackStyle, true)));
        itemElement.setAttribute("onRolloverShowBox", String.valueOf(rc.getRP("popUpOnRollover", fallbackStyle, true)));
        itemElement.setAttribute("leftOffset", String.valueOf(rc.getRP("popUpLeftOffset", fallbackStyle)));
        itemElement.setAttribute("topOffset", String.valueOf(rc.getRP("popUpTopOffset", fallbackStyle)));
        itemElement.setAttribute("focusOnExpand", String.valueOf(rc.getRP("focusOnExpand", fallbackStyle, false)));
        Component focusedComponent = (Component)rc.getRP("focusComponent");
        if (focusedComponent != null) {
            itemElement.setAttribute("focusComponent", ContainerInstance.getElementId((Component)focusedComponent));
        }
        if (defaultStyle != null) {
            itemElement.setAttribute("defaultStyle", defaultStyle);
        }
        if (rolloverStyle != null) {
            itemElement.setAttribute("rolloverStyle", rolloverStyle);
        }
        if (toggleDefaultStyle != null) {
            itemElement.setAttribute("toggleDefaultStyle", toggleDefaultStyle);
        }
        if (toggleDefaultIconUri != null) {
            itemElement.setAttribute("toggleDefaultIcon", toggleDefaultIconUri);
        }
        if (toggleRolloverStyle != null) {
            itemElement.setAttribute("toggleRolloverStyle", toggleRolloverStyle);
        }
        if (toggleRolloverIconUri != null) {
            itemElement.setAttribute("toggleRolloverIcon", toggleRolloverIconUri);
        }
        if (togglePressedStyle != null) {
            itemElement.setAttribute("togglePressedStyle", togglePressedStyle);
        }
        if (toggledPressedIconUri != null) {
            itemElement.setAttribute("togglePressedIcon", toggledPressedIconUri);
        }
        if (targetDefaultStyle != null) {
            itemElement.setAttribute("targetDefaultStyle", targetDefaultStyle);
        }
        if (targetRolloverStyle != null) {
            itemElement.setAttribute("targetRolloverStyle", targetRolloverStyle);
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    private String findKeyTargetId(Component component) {
        Component target = (Component)component.getRenderProperty("target");
        if (target != null) {
            return ContainerInstance.getElementId((Component)target);
        }
        return null;
    }

    private String findParentId(Component component) {
        for (Component parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PopUp)) continue;
            return ContainerInstance.getElementId((Component)parent);
        }
        return "";
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("expanded".equals(propertyName)) {
            String propertyValue = DomUtil.getElementText((Element)propertyElement);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "expanded", (Object)Boolean.valueOf(propertyValue));
        }
    }

    protected Element renderBox(RenderingContext rc, Component component, Style fallbackStyle) {
        CssStyleEx style = new CssStyleEx();
        style.setAttribute("position", "absolute");
        style.setAttribute("visibility", "hidden");
        style.setAttribute("display", "none");
        style.setAttribute("z-index", "2");
        Render.layoutFix(rc, style);
        Render.asColors(style, component, "popUpBackground", null, fallbackStyle);
        Render.asBorder(style, component, "popUpBorder", fallbackStyle);
        Render.asInsets(style, component, "popUpInsets", "padding", fallbackStyle);
        Render.asInsets(style, component, "popUpOutSets", "margin", fallbackStyle);
        Element divBox = rc.createE("div");
        divBox.setAttribute("id", rc.getElementId() + "|Box");
        divBox.setAttribute("style", style.renderInline());
        Component popUpComponent = (Component)rc.getRP("popUp");
        if (popUpComponent != null) {
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), divBox, popUpComponent);
        }
        return divBox;
    }

    private void addIEIframeTrick(RenderingContext rc, Element containerE) {
        Element iframeQuirkIframeElement = rc.createE("iframe");
        iframeQuirkIframeElement.setAttribute("src", "javascript:false;");
        iframeQuirkIframeElement.setAttribute("frameborder", "0");
        iframeQuirkIframeElement.setAttribute("scrolling", "no");
        iframeQuirkIframeElement.setAttribute("width", "100%");
        iframeQuirkIframeElement.setAttribute("height", "100%");
        iframeQuirkIframeElement.setAttribute("style", "filter:progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=0)");
        CssStyleEx style = new CssStyleEx();
        style.setAttribute("position", "absolute");
        style.setAttribute("visibility", "hidden");
        style.setAttribute("z-index", "1");
        style.setAttribute("top", "0px");
        style.setAttribute("left", "0px");
        Render.layoutFix(rc, style);
        Element iframeQuirkDiv = rc.createE("div");
        iframeQuirkDiv.appendChild(iframeQuirkIframeElement);
        iframeQuirkDiv.setAttribute("id", rc.getElementId() + "|IframeQuirk");
        iframeQuirkDiv.setAttribute("style", style.renderInline());
        containerE.appendChild(iframeQuirkDiv);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(POPUP_SERVICE.getId());
        PopUp popUp = (PopUp)component;
        this.createDisposeDirective(rc.getServerMessage(), popUp);
        String menuBoxId = ContainerInstance.getElementId((Component)popUp) + "|Box";
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)menuBoxId);
    }

    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        this.createInitDirective(rc, component, fallbackStyle);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(POPUP_SERVICE);
        String elementId = rc.getElementId();
        CssStyleEx style = new CssStyleEx();
        style.setAttribute("border-collapse", "collapse");
        style.setAttribute("border", "0px");
        HtmlTable innerTable = new HtmlTable(rc.getDocument(), 0, 0, 0);
        innerTable.setAttribute("id", elementId + "Inner");
        innerTable.setAttribute("style", style.renderInline());
        style = new CssStyleEx();
        style.setAttribute("width", "100%");
        Render.asColors(style, component, "targetBackground", null, fallbackStyle);
        Render.asBorder(style, component, "targetBorder", fallbackStyle);
        Render.asInsets(style, component, "targetInsets", "padding", fallbackStyle);
        Element td = innerTable.getTD();
        td.setAttribute("id", elementId + "|Target");
        td.setAttribute("style", style.renderInline());
        Component targetComponent = (Component)rc.getRP("target");
        if (targetComponent != null) {
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), td, targetComponent);
        }
        ImageReference toggleImageRef = (ImageReference)rc.getRP("toggleIcon", fallbackStyle);
        style = new CssStyleEx();
        Render.asColors(style, component, "toggleBackground", null, fallbackStyle);
        Render.asBorder(style, component, "toggleBorder", fallbackStyle);
        Render.asInsets(style, component, "toggleInsets", "padding", fallbackStyle);
        td = innerTable.newTD();
        td.setAttribute("id", elementId + "|Toggle");
        td.setAttribute("style", style.renderInline());
        style = new CssStyleEx();
        style.setAttribute("vertical-align", "text-top");
        Element toggleImg = ImageManager.createImgE(rc, style, toggleImageRef);
        toggleImg.setAttribute("id", elementId + "|Icon");
        td.appendChild(toggleImg);
        Element divBox = this.renderBox(rc, component, fallbackStyle);
        if (!rc.getRP("popUpAlwaysOnTop", fallbackStyle, false)) {
            td = innerTable.newTR();
            td.setAttribute("id", elementId + "|BoxContainer");
            td.setAttribute("colspan", "2");
            td.setAttribute("style", "display:block;position:relative;padding:0px;margin:0px;");
        }
        td.appendChild(divBox);
        if (rc.getContainerInstance().getClientProperties().getBoolean("quirkIESelectZIndex")) {
            this.addIEIframeTrick(rc, td);
        }
        style = new CssStyleEx(component, fallbackStyle);
        Element outerDiv = rc.createE("div");
        outerDiv.appendChild(innerTable.getTABLE());
        outerDiv.setAttribute("id", elementId + "|Outer");
        outerDiv.setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(outerDiv);
        style = new CssStyleEx();
        style.setAttribute("border-collapse", "collapse");
        style.setAttribute("border", "0px");
        Render.asSizeable(style, (Sizeable)component, fallbackStyle);
        HtmlTable outerTable = new HtmlTable(rc.getDocument(), 0, 0, 0);
        outerTable.getTD().appendChild(outerDiv);
        outerTable.setAttribute("id", elementId);
        outerTable.setAttribute("style", style.renderInline());
        parent.appendChild(outerTable.getTABLE());
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedLayoutDataChildren()) {
            fullReplace = true;
        } else if (update.hasUpdatedProperties()) {
            if (!this.partialUpdateManager.canProcess(rc, update)) {
                fullReplace = true;
            } else {
                this.partialUpdateManager.process(rc, update);
                return false;
            }
        }
        if (fullReplace) {
            String elementId = ContainerInstance.getElementId((Component)update.getParent());
            String menuBoxId = elementId + "|Box";
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)elementId);
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)menuBoxId);
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.renderUpdateRemoveChildren(rc, update);
            this.renderUpdateAddChildren(rc, update);
        }
        return fullReplace;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(POPUP_SERVICE);
        WebRenderServlet.getServiceRegistry().add(POPUP_DEFAULT_TOGGLE_IMAGE);
    }
}

