/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.AbleProperties;
import echopointng.EPNG;
import echopointng.PasswordFieldEx;
import echopointng.text.AutoLookupModel;
import echopointng.text.AutoLookupService;
import echopointng.ui.resource.Resources;
import echopointng.ui.util.AblePartialUpdater;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.RenderingContext;
import java.util.Locale;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.LayoutDirection;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.TextArea;
import nextapp.echo2.app.TextField;
import nextapp.echo2.app.text.TextComponent;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.FocusSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.partialupdate.ColorUpdate;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.LayoutDirectionRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.servermessage.WindowUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextFieldExPeer
implements ActionProcessor,
ComponentSynchronizePeer,
DomUpdateSupport,
FocusSupport,
ImageRenderSupport,
PropertyUpdateProcessor {
    private static final String IMAGE_ID_BACKGROUND = "background";
    static final Service TEXT_COMPONENT_SERVICE = JavaScriptService.forResource((String)"EPNG.TextFieldEx", (String)"/echopointng/ui/resource/js/textfieldex.js");
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public TextFieldExPeer() {
        this.partialUpdateManager.add("foreground", (PartialUpdateParticipant)new ColorUpdate("foreground", null, "color"));
        this.partialUpdateManager.add(IMAGE_ID_BACKGROUND, (PartialUpdateParticipant)new ColorUpdate(IMAGE_ID_BACKGROUND, null, "backgroundColor"));
        this.partialUpdateManager.add("text", (PartialUpdateParticipant)new TextUpdate());
        AblePartialUpdater.addToUpdateManager(this.partialUpdateManager);
    }

    protected CssStyle createBaseCssStyle(RenderingContext rc, TextComponent textComponent) {
        Alignment alignment;
        FillImage backgroundImage;
        Style fallbackStyle = EPNG.getFallBackStyle((Component)textComponent);
        CssStyleEx cssStyle = new CssStyleEx((Component)textComponent, fallbackStyle);
        boolean renderEnabled = textComponent.isRenderEnabled();
        if (!renderEnabled) {
            Color background = (Color)rc.getRP("disabledBackground", fallbackStyle);
            backgroundImage = (FillImage)rc.getRP("disabledBackgroundImage", fallbackStyle);
            Border border = (Border)rc.getRP("disabledBorder", fallbackStyle);
            Font font = (Font)rc.getRP("disabledFont", fallbackStyle);
            Color foreground = (Color)rc.getRP("disabledForeground", fallbackStyle);
            if (background == null) {
                background = (Color)rc.getRP(IMAGE_ID_BACKGROUND, fallbackStyle);
                if (backgroundImage == null) {
                    backgroundImage = (FillImage)rc.getRP("backgroundImage", fallbackStyle);
                }
            }
            if (border == null) {
                border = (Border)rc.getRP("border", fallbackStyle);
            }
            if (font == null) {
                font = (Font)rc.getRP("font", fallbackStyle);
            }
            if (foreground == null) {
                foreground = (Color)rc.getRP("foreground", fallbackStyle);
            }
        } else {
            Border border = (Border)rc.getRP("border", fallbackStyle);
            Color foreground = (Color)rc.getRP("foreground", fallbackStyle);
            Color background = (Color)rc.getRP(IMAGE_ID_BACKGROUND, fallbackStyle);
            Font font = (Font)rc.getRP("font", fallbackStyle);
            backgroundImage = (FillImage)rc.getRP("backgroundImage", fallbackStyle);
        }
        if ((alignment = (Alignment)rc.getRP("alignment", fallbackStyle)) != null) {
            int horizontalAlignment = AlignmentRender.getRenderedHorizontal((Alignment)alignment, (Component)textComponent);
            switch (horizontalAlignment) {
                case 3: {
                    cssStyle.setAttribute("text-align", "left");
                    break;
                }
                case 4: {
                    cssStyle.setAttribute("text-align", "center");
                    break;
                }
                case 5: {
                    cssStyle.setAttribute("text-align", "right");
                }
            }
        }
        LayoutDirectionRender.renderToStyle((CssStyle)cssStyle, (LayoutDirection)textComponent.getLayoutDirection(), (Locale)textComponent.getLocale());
        FillImageRender.renderToStyle((CssStyle)cssStyle, (RenderContext)rc, (ImageRenderSupport)this, (Component)textComponent, (String)IMAGE_ID_BACKGROUND, (FillImage)backgroundImage, (int)1);
        return cssStyle;
    }

    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage;
            if (component.isRenderEnabled()) {
                backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
            } else {
                backgroundImage = (FillImage)component.getRenderProperty("disabledBackgroundImage");
                if (backgroundImage == null) {
                    backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
                }
            }
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        return null;
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "action", null);
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("text".equals(propertyName)) {
            String propertyValue = DomUtil.getElementText((Element)propertyElement);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "text", (Object)propertyValue);
        } else if ("horizontalScroll".equals(propertyName)) {
            Extent propertyValue = new Extent(Integer.parseInt(propertyElement.getAttribute("value")));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "horizontalScroll", (Object)propertyValue);
        } else if ("verticalScroll".equals(propertyName)) {
            Extent propertyValue = new Extent(Integer.parseInt(propertyElement.getAttribute("value")));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "verticalScroll", (Object)propertyValue);
        }
    }

    public void renderHtml(RenderContext rcIn, ServerComponentUpdate addUpdate, Node parentNode, Component component) {
        CssStyle cssStyle;
        Integer maximumLength;
        String toolTipText;
        RenderingContext rc = new RenderingContext(rcIn, addUpdate, component);
        TextField textField = (TextField)component;
        String elementId = ContainerInstance.getElementId((Component)textField);
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        serverMessage.addLibrary(Resources.EP_LOOKUP_SERVICE.getId());
        serverMessage.addLibrary(TEXT_COMPONENT_SERVICE.getId());
        Element inputElement = parentNode.getOwnerDocument().createElement("input");
        inputElement.setAttribute("id", elementId);
        rc.addStandardWebSupport(inputElement);
        if (rc.getRP("hiddenField", false)) {
            inputElement.setAttribute("type", "hidden");
        } else if (textField instanceof PasswordFieldEx) {
            inputElement.setAttribute("type", "password");
        } else {
            inputElement.setAttribute("type", "text");
        }
        String value = textField.getText();
        if (value != null) {
            inputElement.setAttribute("value", value);
        }
        if ((toolTipText = (String)textField.getRenderProperty("toolTipText")) != null) {
            inputElement.setAttribute("title", toolTipText);
        }
        if ((maximumLength = (Integer)textField.getRenderProperty("maximumLength")) != null) {
            inputElement.setAttribute("maxlength", maximumLength.toString());
        }
        if ((cssStyle = this.createBaseCssStyle(rc, (TextComponent)textField)).hasAttributes()) {
            inputElement.setAttribute("style", cssStyle.renderInline());
        }
        parentNode.appendChild(inputElement);
        this.renderInitDirective(rc, (TextComponent)textField);
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)targetId, (DocumentFragment)htmlFragment);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(Resources.EP_LOOKUP_SERVICE.getId());
        rc.getServerMessage().addLibrary(TEXT_COMPONENT_SERVICE.getId());
        this.renderDisposeDirective(rc, (TextComponent)component);
    }

    public void renderDisposeDirective(RenderContext rc, TextComponent textComponent) {
        String elementId = ContainerInstance.getElementId((Component)textComponent);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPTextFieldEx.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderInitDirective(RenderingContext rc, TextComponent textComponent) {
        String value;
        Integer maximumLength;
        Style fallbackStyle = EPNG.getFallBackStyle((Component)textComponent);
        Extent horizontalScroll = (Extent)rc.getRP("horizontalScroll", fallbackStyle);
        Extent verticalScroll = (Extent)rc.getRP("verticalScroll", fallbackStyle);
        String elementId = ContainerInstance.getElementId((Component)textComponent);
        ServerMessage serverMessage = rc.getServerMessage();
        Document doc = serverMessage.getDocument();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EPTextFieldEx.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = doc.createElement("item");
        itemElement.setAttribute("eid", elementId);
        if (horizontalScroll != null && horizontalScroll.getValue() != 0) {
            itemElement.setAttribute("horizontal-scroll", ExtentRender.renderCssAttributePixelValue((Extent)horizontalScroll, (String)"0"));
        }
        if (verticalScroll != null && verticalScroll.getValue() != 0) {
            itemElement.setAttribute("vertical-scroll", ExtentRender.renderCssAttributePixelValue((Extent)verticalScroll, (String)"0"));
        }
        if (textComponent instanceof TextArea && (maximumLength = (Integer)textComponent.getProperty("maximumLength")) != null) {
            itemElement.setAttribute("maximum-length", maximumLength.toString());
        }
        value = (value = textComponent.getText()) == null ? "" : value;
        itemElement.setAttribute("text", value);
        if (!textComponent.isRenderEnabled()) {
            itemElement.setAttribute("enabled", "false");
        }
        if (textComponent.hasActionListeners()) {
            itemElement.setAttribute("server-notify", "true");
        }
        itemElement.setAttribute("actionCausedOnChange", String.valueOf(rc.getRP("actionCausedOnChange", fallbackStyle, false)));
        AutoLookupModel autoLookupModel = (AutoLookupModel)rc.getRP("autoLookupModel", fallbackStyle);
        if (autoLookupModel != null) {
            Element autoLookupModelE = doc.createElement("autoLookupModel");
            autoLookupModelE.setAttribute("maximumCacheAge", String.valueOf(autoLookupModel.getMaximumCacheAge()));
            autoLookupModelE.setAttribute("maximumCacheSize", String.valueOf(autoLookupModel.getMaximumCacheSize()));
            autoLookupModelE.setAttribute("matchOptions", String.valueOf(autoLookupModel.getMatchOptions()));
            AutoLookupModel.Entry[] entries = autoLookupModel.prePopulate();
            for (int i = 0; i < entries.length; ++i) {
                Element entryE = AutoLookupService.createEntryXml(doc, entries[i]);
                autoLookupModelE.appendChild(entryE);
            }
            itemElement.appendChild(autoLookupModelE);
            this.renderAbleProperties(rc, fallbackStyle, autoLookupModelE, "popupProperties", "popupProperties");
            this.renderAbleProperties(rc, fallbackStyle, autoLookupModelE, "entryProperties", "entryProperties");
            this.renderAbleProperties(rc, fallbackStyle, autoLookupModelE, "entryRolloverProperties", "entryRolloverProperties");
            this.renderAbleProperties(rc, fallbackStyle, autoLookupModelE, "searchBarProperties", "searchBarProperties");
            this.renderAbleProperties(rc, fallbackStyle, autoLookupModelE, "searchBarRolloverProperties", "searchBarRolloverProperties");
            autoLookupModelE.setAttribute("searchBarIcon", this.valueOf(rc.getRP("searchBarIcon", fallbackStyle)));
            autoLookupModelE.setAttribute("searchBarSearchingIcon", this.valueOf(rc.getRP("searchBarSearchingIcon", fallbackStyle)));
            autoLookupModelE.setAttribute("searchBarShown", this.valueOf(rc.getRP("searchBarShown", fallbackStyle)));
            autoLookupModelE.setAttribute("searchBarText", this.valueOf(rc.getRP("searchBarText", fallbackStyle)));
            autoLookupModelE.setAttribute("searchBarSearchingText", this.valueOf(rc.getRP("searchBarSearchingText", fallbackStyle)));
            autoLookupModelE.setAttribute("noMatchingOptionText", this.valueOf(rc.getRP("noMatchingOptionText", fallbackStyle)));
        }
        itemElement.setAttribute("regex", this.valueOf(rc.getRP("regex", fallbackStyle)));
        this.renderAbleProperties(rc, fallbackStyle, itemElement, "regexFailureProperties", "regexFailureProperties");
        itemizedUpdateElement.appendChild(itemElement);
    }

    private String valueOf(Object value) {
        if (value instanceof ImageReference) {
            value = ImageManager.getURI((ImageReference)value);
        }
        return value == null ? null : String.valueOf(value);
    }

    private void renderAbleProperties(RenderingContext rc, Style fallbackStyle, Element parentE, String propertyName, String attributeName) {
        AbleProperties ableProps = (AbleProperties)rc.getRP(propertyName, fallbackStyle);
        if (ableProps != null) {
            CssStyleEx style = new CssStyleEx(ableProps);
            parentE.setAttribute(attributeName, style.renderInline());
        }
    }

    public void renderSetFocus(RenderContext rc, Component component) {
        WindowUpdate.renderSetFocus((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)component));
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.partialUpdateManager.process(rc, update);
        }
        return false;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(TEXT_COMPONENT_SERVICE);
    }

    private class TextUpdate
    implements PartialUpdateParticipant {
        private TextUpdate() {
        }

        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }

        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            TextComponent textComponent = (TextComponent)update.getParent();
            String elementId = ContainerInstance.getElementId((Component)textComponent);
            ServerMessage serverMessage = rc.getServerMessage();
            Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EPTextFieldEx.MessageProcessor", "set-text", new String[0], new String[0]);
            Element itemElement = serverMessage.getDocument().createElement("item");
            itemElement.setAttribute("eid", elementId);
            itemElement.setAttribute("text", textComponent.getText());
            itemizedUpdateElement.appendChild(itemElement);
        }
    }
}

