/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.TitleBar;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssRolloverStyleEx;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.HtmlTable;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TitleBarPeer
extends AbstractEchoPointContainerPeer
implements PropertyUpdateProcessor {
    public static final Service TITLEBAR_SERVICE = JavaScriptService.forResource((String)"EPNG.TitleBar", (String)"/echopointng/ui/resource/js/titlebar.js");

    public TitleBarPeer() {
        this.partialUpdateManager.add("expanded", new PartialUpdateParticipant(){

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                TitleBar tb = (TitleBar)update.getParent();
                boolean isExpanded = tb.isExpanded();
                Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPTitleBar.MessageProcessor", "expansion", new String[0], new String[0]);
                Element itemElement = rc.getServerMessage().getDocument().createElement("item");
                itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)tb));
                itemElement.setAttribute("expanded", String.valueOf(isExpanded));
                itemizedUpdateElement.appendChild(itemElement);
            }
        });
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("expanded".equals(propertyName)) {
            String propertyValue = DomUtil.getElementText((Element)propertyElement);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "expanded", (Object)Boolean.valueOf(propertyValue));
        }
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        return this.renderUpdateBaseImpl(rc, update, targetId, true);
    }

    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        this.renderHtml(rc, rc.getServerComponentUpdate(), parent, component, null);
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parent, Component component, String partnerComponentId) {
        this.renderHtmlImpl(new RenderingContext(rc, update, component), parent, component, partnerComponentId);
    }

    private CssRolloverStyleEx createBaseStyle(RenderingContext rc, Component component, Style fallbackStyle) {
        CssRolloverStyleEx baseStyle = new CssRolloverStyleEx(component, fallbackStyle);
        baseStyle.setRolloverBackground((Color)rc.getRP("rolloverBackground", fallbackStyle));
        baseStyle.setRolloverForeground((Color)rc.getRP("rolloverForeground", fallbackStyle));
        baseStyle.setRolloverFont((Font)rc.getRP("rolloverFont", fallbackStyle));
        baseStyle.setRolloverBorder((Border)rc.getRP("rolloverBorder", fallbackStyle));
        Render.asFillImage(baseStyle, component, "backgroundImage", fallbackStyle, rc);
        if (Render.isClientIE(rc)) {
            baseStyle.setAttribute("zoom", "1");
        }
        return baseStyle;
    }

    private void renderHtmlImpl(RenderingContext rc, Node parent, Component component, String partnerComponentId) {
        ImageReference icon;
        CssStyleEx style;
        Style fallbackStyle = EPNG.getFallBackStyle(component);
        this.createInitDirective(rc, component, partnerComponentId, fallbackStyle);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(TITLEBAR_SERVICE);
        String elementId = rc.getElementId();
        CssRolloverStyleEx baseStyle = this.createBaseStyle(rc, component, fallbackStyle);
        Element divOuter = rc.createE("div");
        divOuter.setAttribute("id", elementId);
        divOuter.setAttribute("style", baseStyle.renderInline());
        rc.addStandardWebSupport(divOuter);
        parent.appendChild(divOuter);
        HtmlTable tableInner = new HtmlTable(rc.getDocument(), 0, 0, 0);
        tableInner.getTABLE().setAttribute("width", "100%");
        divOuter.appendChild(tableInner.getTABLE());
        Element td = tableInner.getTD();
        Component applicationComponent = (Component)rc.getRP("applicationComponent", fallbackStyle);
        Component helpComponent = (Component)rc.getRP("helpComponent", fallbackStyle);
        Component closeComponent = (Component)rc.getRP("closeComponent", fallbackStyle);
        ImageReference leftIcon = (ImageReference)rc.getRP("leftIcon", fallbackStyle);
        ImageReference rightIcon = (ImageReference)rc.getRP("rightIcon", fallbackStyle);
        boolean isExpanded = ((TitleBar)component).isExpanded();
        String title = this.getTitle(rc, fallbackStyle);
        if (isExpanded) {
            title = this.getExpandedTitle(rc, fallbackStyle);
        }
        if (applicationComponent != null && applicationComponent.isRenderVisible()) {
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), td, applicationComponent);
            td = tableInner.newTD();
        }
        if (leftIcon != null) {
            style = new CssStyleEx();
            style.setAttribute("cursor", "pointer");
            icon = (ImageReference)rc.getRP(isExpanded ? "leftExpandedIcon" : "leftIcon", fallbackStyle);
            Element img = ImageManager.createImgE(rc, style, icon);
            img.setAttribute("id", elementId + "|LeftIcon");
            td.appendChild(img);
            td = tableInner.newTD();
        }
        style = new CssStyleEx();
        style.setAttribute("cursor", "pointer");
        style.setAttribute("white-space", "pre");
        AlignmentRender.renderToStyle((CssStyle)style, (Alignment)((Alignment)rc.getRP("titleAlignment", fallbackStyle)));
        String titleBackground = isExpanded ? "titleBackgroundImage" : "titleBackgroundImage";
        Render.asFillImage(style, component, titleBackground, fallbackStyle, rc);
        td.setAttribute("id", elementId + "|Title");
        td.setAttribute("width", "100%");
        td.setAttribute("style", style.renderInline());
        if (title != null) {
            DomUtil.setElementText((Element)td, (String)title);
        }
        if (rightIcon != null) {
            td = tableInner.newTD();
            style = new CssStyleEx();
            style.setAttribute("cursor", "pointer");
            icon = (ImageReference)rc.getRP(isExpanded ? "rightExpandedIcon" : "rightIcon", fallbackStyle);
            Element img = ImageManager.createImgE(rc, style, icon);
            img.setAttribute("id", elementId + "|RightIcon");
            td.appendChild(img);
        }
        if (helpComponent != null && helpComponent.isRenderVisible()) {
            td = tableInner.newTD();
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), td, helpComponent);
        }
        if (closeComponent != null && closeComponent.isRenderVisible()) {
            td = tableInner.newTD();
            this.renderReplaceableChild(rc, rc.getServerComponentUpdate(), td, closeComponent);
        }
    }

    private String getTitle(RenderingContext rc, Style fallbackStyle) {
        String title = (String)rc.getRP("title", fallbackStyle);
        if (title != null) {
            return title;
        }
        title = (String)rc.getRP("expandedTitle", fallbackStyle);
        return title == null ? "" : title;
    }

    private String getExpandedTitle(RenderingContext rc, Style fallbackStyle) {
        String title = (String)rc.getRP("expandedTitle", fallbackStyle);
        if (title != null) {
            return title;
        }
        title = (String)rc.getRP("title", fallbackStyle);
        return title == null ? "" : title;
    }

    protected void createInitDirective(RenderingContext rc, Component component, String partnerComponentId, Style fallbackStyle) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EPTitleBar.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", rc.getElementId());
        boolean isExpanded = ((TitleBar)component).isExpanded();
        itemElement.setAttribute("expanded", String.valueOf(isExpanded));
        if (partnerComponentId != null) {
            itemElement.setAttribute("partnerComponentId", partnerComponentId);
        }
        itemElement.setAttribute("title", this.getTitle(rc, fallbackStyle));
        itemElement.setAttribute("expandedTitle", this.getExpandedTitle(rc, fallbackStyle));
        CssRolloverStyleEx baseStyle = this.createBaseStyle(rc, component, fallbackStyle);
        itemElement.setAttribute("styleDefault", baseStyle.renderInline());
        if (component.isRenderEnabled() && rc.getRP("rolloverEnabled", fallbackStyle, true)) {
            itemElement.setAttribute("rolloverEnabled", "true");
            itemElement.setAttribute("styleRollover", baseStyle.renderRolloverSupportInline());
        }
        ImageReference leftIconImg = (ImageReference)rc.getRP("leftIcon", fallbackStyle);
        ImageReference leftExpandedIconImg = (ImageReference)rc.getRP("leftExpandedIcon", fallbackStyle);
        ImageReference rightIconImg = (ImageReference)rc.getRP("rightIcon", fallbackStyle);
        ImageReference rightExpandedIconImg = (ImageReference)rc.getRP("rightExpandedIcon", fallbackStyle);
        if (leftIconImg != null) {
            String leftIcon = ImageManager.getURI(rc, leftIconImg);
            String leftExpandedIcon = ImageManager.getURI(rc, leftExpandedIconImg);
            leftExpandedIcon = leftExpandedIcon != null ? leftExpandedIcon : leftIcon;
            itemElement.setAttribute("leftIcon", leftIcon);
            itemElement.setAttribute("leftExpandedIcon", leftExpandedIcon);
        }
        if (rightIconImg != null) {
            String rightIcon = ImageManager.getURI(rc, rightIconImg);
            String rightExpandedIcon = ImageManager.getURI(rc, rightExpandedIconImg);
            rightExpandedIcon = rightExpandedIcon != null ? rightExpandedIcon : rightIcon;
            itemElement.setAttribute("rightIcon", rightIcon);
            itemElement.setAttribute("rightExpandedIcon", rightExpandedIcon);
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(TITLEBAR_SERVICE.getId());
        this.createDisposeDirective(rc.getServerMessage(), component);
    }

    protected void createDisposeDirective(ServerMessage serverMessage, Component component) {
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EPTitleBar.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    static {
        WebRenderServlet.getServiceRegistry().add(TITLEBAR_SERVICE);
    }
}

