/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.syncpeer;

import echopointng.EPNG;
import echopointng.Tree;
import echopointng.tree.TreeModel;
import echopointng.tree.TreePath;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.syncpeer.TreeRenderer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.ImageManager;
import echopointng.ui.util.RenderingContext;
import echopointng.util.TokenizerKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreePeer
extends AbstractEchoPointContainerPeer
implements ActionProcessor {
    public static final Service TREE_SCRIPT_SERVICE = JavaScriptService.forResource((String)"Echopoint.Tree", (String)"/echopointng/ui/resource/js/tree.js");

    public TreePeer() {
        this.partialUpdateManager.add("nodeChanged", new PartialUpdateParticipant(){

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                RenderingContext renderingContext = new RenderingContext(rc, update, update.getParent());
                TreePeer.this.renderNodeDiffs(renderingContext, (Tree)update.getParent());
            }
        });
    }

    private TreeRenderState setupTreeImageRenderState(RenderContext rc, Component component) {
        TreeRenderState treeImageRenderState;
        RenderState renderState = this.retreiveRenderState(rc, component);
        if (renderState == null || !(renderState instanceof TreeRenderState)) {
            treeImageRenderState = new TreeRenderState();
            this.storeRenderState(rc, component, treeImageRenderState);
        } else {
            treeImageRenderState = (TreeRenderState)renderState;
        }
        return treeImageRenderState;
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        this.renderDisposeDirective(new RenderingContext(rc, update, component), (Tree)component);
    }

    private void renderDisposeDirective(RenderingContext rc, Tree tree) {
        ServerMessage serverMessage = rc.getServerMessage();
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(TREE_SCRIPT_SERVICE);
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EchoPointTree.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)tree));
        itemizedUpdateElement.appendChild(itemElement);
    }

    private void renderInitDirective(RenderContext rc, Tree tree) {
        Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EchoPointTree.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = rc.getServerMessage().getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)tree));
        itemizedUpdateElement.appendChild(itemElement);
    }

    private void renderScrollIntoViewDirective(RenderingContext rc, Tree tree) {
        TreeModel model = tree.getModel();
        Collection lastExpandedPaths = tree.getLastExpandedPaths();
        if (model == null || lastExpandedPaths == null) {
            return;
        }
        TreePath expandedTargetPath = null;
        Iterator iter = lastExpandedPaths.iterator();
        while (iter.hasNext()) {
            expandedTargetPath = (TreePath)iter.next();
        }
        lastExpandedPaths.clear();
        Style fallbackStyle = EPNG.getFallBackStyle(tree);
        boolean scrollIntoView = rc.getRP("scrollIntoViewUsed", fallbackStyle, true);
        if (!scrollIntoView || expandedTargetPath == null) {
            return;
        }
        if (model.getRoot() == expandedTargetPath.getLastPathComponent()) {
            return;
        }
        TreePath scrollIntoViewTreePath = null;
        Object parentNode = expandedTargetPath.getParentPath().getLastPathComponent();
        Object expandedTargetNode = expandedTargetPath.getLastPathComponent();
        int cc = model.getChildCount(parentNode);
        int index = model.getIndexOfChild(parentNode, expandedTargetNode);
        if (index + 1 < cc) {
            Object peerNode = model.getChild(parentNode, index + 1);
            scrollIntoViewTreePath = new TreePath(expandedTargetPath.getParentPath(), peerNode);
        } else {
            cc = model.getChildCount(expandedTargetNode);
            if (cc - 1 > 0) {
                Object childNode = model.getChild(expandedTargetNode, cc - 1);
                scrollIntoViewTreePath = new TreePath(expandedTargetPath, childNode);
            }
        }
        if (scrollIntoViewTreePath != null) {
            Element itemizedUpdateElement = rc.getServerMessage().getItemizedDirective("postupdate", "EchoPointTree.MessageProcessor", "scrollIntoView", new String[0], new String[0]);
            Element itemElement = rc.getServerMessage().getDocument().createElement("item");
            itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)tree));
            itemElement.setAttribute("scrollIntoViewPath", TreeRenderer.createPathId(scrollIntoViewTreePath, model));
            itemElement.setAttribute("expandedTargetPath", TreeRenderer.createPathId(expandedTargetPath, model));
            itemizedUpdateElement.appendChild(itemElement);
        }
    }

    public void renderHtml(RenderingContext rc, Node parent, Component component) {
        Tree tree = (Tree)component;
        Style fallbackStyle = EPNG.getFallBackStyle(tree);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(TREE_SCRIPT_SERVICE);
        this.renderInitDirective(rc, tree);
        this.renderScrollIntoViewDirective(rc, tree);
        TreeRenderState treeRenderState = this.setupTreeImageRenderState(rc, tree);
        CssStyleEx style = new CssStyleEx(tree, fallbackStyle);
        final Element outerTreeDiv = rc.createE("div");
        parent.appendChild(outerTreeDiv);
        rc.addStandardWebSupport(outerTreeDiv);
        outerTreeDiv.setAttribute("id", rc.getElementId());
        outerTreeDiv.setAttribute("style", style.renderInline());
        TreeRenderer.EventSupportCallBack callback = new TreeRenderer.EventSupportCallBack(){

            public String onExpandoCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreePeer.this.addToggleEventId(rc, cssStyle, tree, treeNode, treeNodePath);
            }

            public String onNodeComponentCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return null;
            }

            public String onNodeIconCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreePeer.this.addSelectEventId(rc, cssStyle, tree, treeNode, treeNodePath, "icon");
            }

            public String onNodeTextCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreePeer.this.addSelectEventId(rc, cssStyle, tree, treeNode, treeNodePath, "text");
            }

            public void onTreeRow(RenderingContext rc, CssStyle cssStyle, Element treeElement, Tree tree, TreePath treeNodePath) {
                outerTreeDiv.appendChild(treeElement);
                String eventElementId = TreePeer.this.createEventId(tree, "treerow", "", null, treeNodePath);
                treeElement.setAttribute("id", eventElementId);
            }
        };
        TreeRenderer treeRenderer = new TreeRenderer(rc, callback, tree, fallbackStyle, treeRenderState.imageManager);
        treeRenderer.renderTree();
        tree.getDirtyPaths().clear();
        if (rc.getRP("partialUpdateSupport", fallbackStyle, true)) {
            treeRenderState.setLastRenderedPaths(treeRenderer.compileVisiblePaths());
        }
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace;
        Tree tree = (Tree)update.getParent();
        boolean bl = fullReplace = !Tree.getRenderProperty((Component)tree, "partialUpdateSupport", true);
        if (!fullReplace) {
            if (update.hasUpdatedLayoutDataChildren()) {
                fullReplace = true;
            } else if (update.hasUpdatedProperties()) {
                if (this.partialUpdateManager.canProcess(rc, update)) {
                    this.partialUpdateManager.process(rc, update);
                } else {
                    fullReplace = true;
                }
            }
        }
        if (fullReplace) {
            this.renderUpdateBaseImpl(rc, update, targetId, fullReplace);
        }
        return fullReplace;
    }

    private void renderNodeDiffs(RenderingContext rc, Tree tree) {
        TreePath path;
        TreeRenderer.EventSupportCallBack callback = new TreeRenderer.EventSupportCallBack(){

            public String onExpandoCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreePeer.this.addToggleEventId(rc, cssStyle, tree, treeNode, treeNodePath);
            }

            public String onNodeComponentCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return null;
            }

            public String onNodeIconCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreePeer.this.addSelectEventId(rc, cssStyle, tree, treeNode, treeNodePath, "icon");
            }

            public String onNodeTextCell(RenderingContext rc, CssStyle cssStyle, Element cellElement, Tree tree, Object treeNode, TreePath treeNodePath) {
                return TreePeer.this.addSelectEventId(rc, cssStyle, tree, treeNode, treeNodePath, "text");
            }

            public void onTreeRow(RenderingContext rc, CssStyle cssStyle, Element treeElement, Tree tree, TreePath treeNodePath) {
                String eventElementId = TreePeer.this.createEventId(tree, "treerow", "", null, treeNodePath);
                treeElement.setAttribute("id", eventElementId);
            }
        };
        TreeRenderState treeRenderState = this.setupTreeImageRenderState(rc, tree);
        Style fallbackStyle = EPNG.getFallBackStyle(tree);
        TreeRenderer treeRenderer = new TreeRenderer(rc, callback, tree, fallbackStyle, treeRenderState.imageManager);
        Collection oldPaths = treeRenderState.getLastRenderedPaths();
        ArrayList newPaths = treeRenderer.compileVisiblePaths();
        ArrayList<TreePath> addedPaths = new ArrayList<TreePath>();
        Iterator iter = newPaths.iterator();
        while (iter.hasNext()) {
            TreePath path2 = (TreePath)iter.next();
            if (oldPaths.contains(path2)) continue;
            addedPaths.add(path2);
        }
        oldPaths.removeAll(newPaths);
        Collection dirtyPaths = tree.getDirtyPaths();
        dirtyPaths.retainAll(newPaths);
        dirtyPaths.removeAll(addedPaths);
        Iterator iter2 = dirtyPaths.iterator();
        while (iter2.hasNext()) {
            path = (TreePath)iter2.next();
            oldPaths.add(path);
            addedPaths.add(path);
        }
        iter2 = oldPaths.iterator();
        while (iter2.hasNext()) {
            path = (TreePath)iter2.next();
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)this.createEventId(tree, "treerow", "", null, path));
        }
        if (addedPaths.size() > 0) {
            Document doc = rc.getServerMessage().getDocument();
            Element domAddElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
            Iterator iter3 = addedPaths.iterator();
            while (iter3.hasNext()) {
                TreePath path3 = (TreePath)iter3.next();
                DocumentFragment docFrag = doc.createDocumentFragment();
                docFrag.appendChild(treeRenderer.renderTreeRow(path3.getLastPathComponent(), path3));
                TreePath siblingPath = null;
                for (int k = newPaths.indexOf(path3) + 1; k < newPaths.size() && siblingPath == null; ++k) {
                    siblingPath = (TreePath)newPaths.get(k);
                    if (!addedPaths.contains(siblingPath)) {
                        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)rc.getElementId(), (String)this.createEventId(tree, "treerow", "", null, siblingPath), (DocumentFragment)docFrag);
                        continue;
                    }
                    siblingPath = null;
                }
                if (siblingPath == null) {
                    DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)rc.getElementId(), (DocumentFragment)docFrag);
                }
                iter3.remove();
            }
        }
        treeRenderState.setLastRenderedPaths(newPaths);
        tree.getDirtyPaths().clear();
        this.renderScrollIntoViewDirective(rc, tree);
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        Tree tree = (Tree)component;
        TreeModel model = (TreeModel)tree.getRenderProperty("model");
        if (model == null) {
            return;
        }
        String actionName = actionElement.getAttribute("name");
        String actionValue = actionElement.getAttribute("value");
        String[] paths = TokenizerKit.tokenize(actionValue, "[]");
        Object[] nodes = new Object[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = i == 0 ? model.getRoot() : model.getNodeById(paths[i]);
        }
        TreePath nodePath = new TreePath(nodes);
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, actionName, (Object)nodePath);
    }

    private String addToggleEventId(RenderingContext rc, CssStyle cssStyle, Tree tree, Object treeNode, TreePath treeNodePath) {
        String eventElementId = this.createEventId(tree, "expando", "toggle", treeNode, treeNodePath);
        if (tree.isRenderEnabled()) {
            cssStyle.setAttribute("cursor", "pointer");
        }
        return eventElementId;
    }

    private String addSelectEventId(RenderingContext rc, CssStyle cssStyle, Tree tree, Object treeNode, TreePath treeNodePath, String cellType) {
        String eventElementId = this.createEventId(tree, cellType, "select", treeNode, treeNodePath);
        if (tree.isRenderEnabled()) {
            cssStyle.setAttribute("cursor", "pointer");
        }
        return eventElementId;
    }

    private String createEventId(Tree tree, String cellType, String baseAction, Object treeNode, TreePath treeNodePath) {
        TreeModel model = (TreeModel)tree.getRenderProperty("model");
        String pathId = TreeRenderer.createPathId(treeNodePath, model);
        String treeId = "tree|" + ContainerInstance.getElementId((Component)tree) + '|' + cellType;
        String eventElementId = treeId + '|' + baseAction + '|' + pathId;
        return eventElementId;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(TREE_SCRIPT_SERVICE);
    }

    private static class TreeRenderState
    implements RenderState {
        private Collection lastRenderedPaths;
        private ImageManager imageManager = new ImageManager();

        private TreeRenderState() {
        }

        private Collection getLastRenderedPaths() {
            return this.lastRenderedPaths;
        }

        private void setLastRenderedPaths(Collection paths) {
            this.lastRenderedPaths = paths;
        }
    }
}

