/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.util;

import echopointng.ui.util.Render;
import echopointng.util.ColorKit;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Style;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.output.CssStyle;

public class CssStyleEx
extends CssStyle {
    public CssStyleEx() {
    }

    public CssStyleEx(Component component) {
        Render.asComponent(this, component);
    }

    public CssStyleEx(Component component, Style defaultStyle) {
        Render.asComponent(this, component, defaultStyle);
    }

    private void renderFont(Font font) {
        if (font == null) {
            this.setAttribute("text-decoration", "none");
        } else {
            Font.Typeface typeFace = font.getTypeface();
            if (typeFace != null) {
                StringBuffer out = new StringBuffer(typeFace.getName());
                for (typeFace = typeFace.getAlternate(); typeFace != null; typeFace = typeFace.getAlternate()) {
                    out.append(",");
                    out.append(typeFace.getName());
                }
                this.setAttribute("font-family", out.toString());
            }
            if (font.getSize() != null) {
                this.setAttribute("font-size", ExtentRender.renderCssAttributeValue((Extent)font.getSize()));
            }
            boolean setTextDecoration = false;
            if (!font.isPlain()) {
                if (font.isBold()) {
                    this.setAttribute("font-weight", "bold");
                }
                if (font.isItalic()) {
                    this.setAttribute("font-style", "italic");
                }
                if (font.isUnderline() || font.isLineThrough() || font.isItalic()) {
                    StringBuffer out = new StringBuffer();
                    if (font.isUnderline()) {
                        out.append("underline");
                        setTextDecoration = true;
                    }
                    if (font.isOverline()) {
                        if (out.length() > 0) {
                            out.append(" ");
                        }
                        out.append("overline");
                        setTextDecoration = true;
                    }
                    if (font.isLineThrough()) {
                        if (out.length() > 0) {
                            out.append(" ");
                        }
                        out.append("line-through");
                        setTextDecoration = true;
                    }
                    if (!setTextDecoration) {
                        out.append("none");
                    }
                    this.setAttribute("text-decoration", out.toString());
                }
            } else {
                this.setAttribute("text-decoration", "none");
            }
        }
    }

    public void setBackground(Color background) {
        if (background != null) {
            this.setAttribute("background-color", ColorKit.makeCSSColor(background));
        }
    }

    public void setFont(Font font) {
        this.renderFont(font);
    }

    public void setForeground(Color foreground) {
        if (foreground != null) {
            this.setAttribute("color", ColorKit.makeCSSColor(foreground));
        }
    }

    public void setNoWrap() {
        this.setAttribute("white-space", "nowrap");
    }

    public void setBorder(Border border) {
        if (border != null) {
            Render.asBorder(this, border);
        }
    }

    public String toString() {
        return "{" + this.renderInline() + "}";
    }
}

