/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.AwtImageReference;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.HttpImageReference;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.RenderIdSupport;
import nextapp.echo2.app.StreamImageReference;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webcontainer.image.AwtImageService;
import nextapp.echo2.webcontainer.image.StreamImageService;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Element;

public class ImageManager
implements RenderState {
    private static Set handlerSet = new HashSet();
    private static ImageReferenceURIHandler DEFAULT_HANDLER = new ImageReferenceURIHandler(){

        public String getImageURI(ContainerInstance containerInstance, ImageReference imageReference) {
            if (imageReference instanceof StreamImageReference) {
                containerInstance.getIdTable().register((RenderIdSupport)imageReference);
                return StreamImageService.INSTANCE.createUri(containerInstance, imageReference.getRenderId());
            }
            if (imageReference instanceof HttpImageReference) {
                return ((HttpImageReference)imageReference).getUri();
            }
            if (imageReference instanceof AwtImageReference) {
                containerInstance.getIdTable().register((RenderIdSupport)imageReference);
                return AwtImageService.INSTANCE.createUri(containerInstance, imageReference.getRenderId());
            }
            return null;
        }
    };
    private Map imageMap = new HashMap();

    public static void registerURIHandler(ImageReferenceURIHandler handler) {
        handlerSet.add(handler);
    }

    public static void deregisterURIHandler(ImageReferenceURIHandler handler) {
        handlerSet.remove(handler);
    }

    public static String getURI(RenderContext rc, ImageReference imageReference) {
        return ImageManager.getURIImpl(rc.getContainerInstance(), imageReference);
    }

    public static String getURI(ImageReference imageReference) {
        ContainerInstance containerInstance = (ContainerInstance)WebRenderServlet.getActiveConnection().getUserInstance();
        return ImageManager.getURIImpl(containerInstance, imageReference);
    }

    private static String getURIImpl(ContainerInstance containerInstance, ImageReference imageReference) {
        ImageReferenceURIHandler handler;
        String imageURI = null;
        Iterator iter = handlerSet.iterator();
        while (iter.hasNext() && (imageURI = (handler = (ImageReferenceURIHandler)iter.next()).getImageURI(containerInstance, imageReference)) == null) {
        }
        if (imageURI == null) {
            imageURI = DEFAULT_HANDLER.getImageURI(containerInstance, imageReference);
        }
        return imageURI;
    }

    public static String getURI(RenderContext rc, Component component, String propertyName) {
        ImageReference imageRef = ImageManager.getImageRefFromProperty(component, propertyName);
        return ImageManager.getURI(rc, imageRef);
    }

    public static String getURI(Component component, String propertyName) {
        ImageReference imageRef = ImageManager.getImageRefFromProperty(component, propertyName);
        ContainerInstance containerInstance = (ContainerInstance)WebRenderServlet.getActiveConnection().getUserInstance();
        return ImageManager.getURIImpl(containerInstance, imageRef);
    }

    public static Element createImgE(RenderContext rc, ImageReference imageRef) {
        return ImageManager.createImgE(rc, null, imageRef);
    }

    public static Element createImgE(RenderContext rc, CssStyle cssStyle, ImageReference imageRef) {
        String imageURI = ImageManager.getURI(rc, imageRef);
        return ImageManager.createImgImpl(rc, cssStyle, imageURI, imageRef);
    }

    public static Element createImgEFromProperty(RenderContext rc, CssStyle cssStyle, Component component, String propertyName) {
        ImageReference imageRef = ImageManager.getImageRefFromProperty(component, propertyName);
        String imageURI = ImageManager.getURI(rc, imageRef);
        return ImageManager.createImgImpl(rc, cssStyle, imageURI, imageRef);
    }

    public static Element createImgEFromProperty(RenderContext rc, Component component, String propertyName) {
        return ImageManager.createImgEFromProperty(rc, null, component, propertyName);
    }

    private static ImageReference getImageRefFromProperty(Component component, String propertyName) {
        ImageReference imageRef = null;
        Object propertyValue = component.getRenderProperty(propertyName);
        if (propertyValue instanceof ImageReference) {
            imageRef = (ImageReference)propertyValue;
        } else if (propertyValue instanceof FillImage) {
            imageRef = ((FillImage)propertyValue).getImage();
        }
        return imageRef;
    }

    private static Element createImgImpl(RenderContext rc, CssStyle cssStyle, String imageURI, ImageReference imageRef) {
        Element imgElement = rc.getServerMessage().getDocument().createElement("img");
        imgElement.setAttribute("src", imageURI);
        if (cssStyle == null) {
            cssStyle = new CssStyle();
        }
        if (cssStyle.getAttribute("border") == null) {
            cssStyle.setAttribute("border", "none");
        }
        if (imageRef != null) {
            if (imageRef.getHeight() != null && cssStyle.getAttribute("height") == null) {
                ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"height", (Extent)imageRef.getHeight());
            }
            if (imageRef.getWidth() != null && cssStyle.getAttribute("width") == null) {
                ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"width", (Extent)imageRef.getWidth());
            }
        }
        imgElement.setAttribute("style", cssStyle.renderInline());
        return imgElement;
    }

    public void setImage(String imageId, ImageReference imageReference) {
        this.imageMap.put(imageId, imageReference);
    }

    public ImageReference getImage(String imageId) {
        return (ImageReference)this.imageMap.get(imageId);
    }

    public void addImage(ImageReference imageReference) {
        if (imageReference != null) {
            this.imageMap.put(imageReference.getRenderId(), imageReference);
        }
    }

    public void removeImage(ImageReference imageReference) {
        if (imageReference != null) {
            this.imageMap.remove(imageReference.getRenderId());
        }
    }

    public void removeAllImages() {
        this.imageMap.clear();
    }

    public static interface ImageReferenceURIHandler {
        public String getImageURI(ContainerInstance var1, ImageReference var2);
    }
}

