/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.util;

import echopointng.BorderEx;
import echopointng.able.Alignable;
import echopointng.able.BackgroundImageable;
import echopointng.able.Borderable;
import echopointng.able.Delegateable;
import echopointng.able.Floatable;
import echopointng.able.Heightable;
import echopointng.able.Insetable;
import echopointng.able.MouseCursorable;
import echopointng.able.Positionable;
import echopointng.able.ScrollBarProperties;
import echopointng.able.Scrollable;
import echopointng.able.Sizeable;
import echopointng.able.Widthable;
import echopointng.layout.DisplayLayoutData;
import echopointng.ui.util.CssStyleEx;
import echopointng.util.ColorKit;
import echopointng.util.HtmlKit;
import echopointng.xhtml.XhtmlFragment;
import java.util.Locale;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.LayoutDirection;
import nextapp.echo2.app.Style;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webcontainer.propertyrender.LayoutDirectionRender;
import nextapp.echo2.webrender.ClientProperties;
import nextapp.echo2.webrender.output.CssStyle;
import org.w3c.dom.Element;

public class Render {
    public static void asAble(CssStyle cssStyle, Object ableObject) {
        Render.asAble(cssStyle, ableObject, null);
    }

    public static void asAble(CssStyle cssStyle, Object ableObject, Style fallbackStyle) {
        if (ableObject == null) {
            return;
        }
        if (ableObject instanceof Alignable) {
            Render.asAlignable(cssStyle, (Alignable)ableObject, fallbackStyle);
        }
        if (ableObject instanceof Insetable) {
            Render.asInsetable(cssStyle, (Insetable)ableObject, fallbackStyle);
        }
        if (ableObject instanceof MouseCursorable) {
            Render.asMouseCursorable(cssStyle, (MouseCursorable)ableObject, fallbackStyle);
        }
        if (ableObject instanceof Borderable) {
            Render.asBorderable(cssStyle, (Borderable)ableObject, fallbackStyle);
        }
        if (ableObject instanceof Widthable) {
            Render.asWidthable(cssStyle, (Widthable)ableObject, fallbackStyle);
        }
        if (ableObject instanceof Heightable) {
            Render.asHeightable(cssStyle, (Heightable)ableObject, fallbackStyle);
        }
        if (ableObject instanceof Positionable) {
            Render.asPositionable(cssStyle, (Positionable)ableObject, fallbackStyle);
        }
        if (ableObject instanceof Scrollable) {
            Render.asScrollable(cssStyle, (Scrollable)ableObject, fallbackStyle);
        }
        if (ableObject instanceof Floatable) {
            Render.asFloatable(cssStyle, (Floatable)ableObject, fallbackStyle);
        }
    }

    public static void asBorder(CssStyle cssStyle, Border border) {
        Render.borderRenderImpl(cssStyle, border);
    }

    public static void asBorder(CssStyle cssStyle, Component component, String propertyName) {
        Render.borderRenderImpl(cssStyle, (Border)component.getRenderProperty(propertyName));
    }

    public static void asBorder(CssStyle cssStyle, Component component, String propertyName, Style fallbackStyle) {
        Render.borderRenderImpl(cssStyle, (Border)Render.getRP(component, propertyName, fallbackStyle));
    }

    public static void asBorderable(CssStyle cssStyle, Borderable able) {
        Render.asBorderable(cssStyle, able, null);
    }

    public static void asBorderable(CssStyle cssStyle, Borderable able, Style fallbackStyle) {
        Render.borderRenderImpl(cssStyle, (Border)Render.getRP(able, "border", fallbackStyle));
    }

    public static void asColor(CssStyle cssStyle, Color color, String cssAttributeName) {
        if (color != null) {
            cssStyle.setAttribute(cssAttributeName, ColorKit.makeCSSColor(color));
        }
    }

    public static void asColors(CssStyle cssStyle, Component component) {
        Render.asColors(cssStyle, component, "background", "foreground");
    }

    public static void asColors(CssStyle cssStyle, Component component, String backgroundPropertyName, String foregroundPropertyName) {
        Render.asColors(cssStyle, component, backgroundPropertyName, foregroundPropertyName, null);
    }

    public static void asColors(CssStyle cssStyle, Component component, String backgroundPropertyName, String foregroundPropertyName, Style fallbackStyle) {
        Color background = backgroundPropertyName == null ? null : (Color)Render.getRP(component, backgroundPropertyName, fallbackStyle);
        Color foreground = foregroundPropertyName == null ? null : (Color)Render.getRP(component, foregroundPropertyName, fallbackStyle);
        ColorRender.renderToStyle((CssStyle)cssStyle, (Color)foreground, (Color)background);
    }

    public static void asColors(CssStyle cssStyle, Component component, Style fallbackStyle) {
        Render.asColors(cssStyle, component, "background", "foreground", fallbackStyle);
    }

    public static void asComponent(CssStyle cssStyle, Component component) {
        Render.asComponent(cssStyle, component, null);
    }

    public static void asComponent(CssStyle cssStyle, Component component, Style fallbackStyle) {
        if (component == null) {
            return;
        }
        Render.asAble(cssStyle, component, fallbackStyle);
        Render.asColors(cssStyle, component, fallbackStyle);
        Render.asFont(cssStyle, component, fallbackStyle);
        LayoutDirectionRender.renderToStyle((CssStyle)cssStyle, (LayoutDirection)component.getLayoutDirection(), (Locale)component.getLocale());
        Object hidden = component.getRenderProperty("hidden", (Object)false);
        if (hidden instanceof Boolean && ((Boolean)hidden).booleanValue()) {
            cssStyle.setAttribute("display", "none");
        }
    }

    public static void asFillImage(CssStyle cssStyle, Component component, String propertyName, RenderContext rc) {
        Render.asFillImage(cssStyle, component, propertyName, null, rc);
    }

    public static void asFillImage(CssStyle cssStyle, Component component, String propertyName, Style fallbackStyle, RenderContext rc) {
        FillImage fillImage = (FillImage)Render.getRP(component, propertyName, fallbackStyle);
        ImageReference imageRef = fillImage != null ? fillImage.getImage() : null;
        DirectImageRenderSupport irs = new DirectImageRenderSupport(imageRef);
        FillImageRender.renderToStyle((CssStyle)cssStyle, (RenderContext)rc, (ImageRenderSupport)irs, (Component)component, (String)propertyName, (FillImage)fillImage, (int)0);
    }

    public static void asFont(CssStyle cssStyle, Component component) {
        Render.asFont(cssStyle, component, "font");
    }

    public static void asFont(CssStyle cssStyle, Component component, String propertyName) {
        Render.asFont(cssStyle, (Font)component.getRenderProperty(propertyName));
    }

    public static void asFont(CssStyle cssStyle, Component component, String propertyName, Style fallbackStyle) {
        Render.asFont(cssStyle, (Font)Render.getRP(component, propertyName, fallbackStyle));
    }

    public static void asFont(CssStyle cssStyle, Component component, Style fallbackStyle) {
        Render.asFont(cssStyle, component, "font", fallbackStyle);
    }

    public static void asFont(CssStyle cssStyle, Font font) {
        FontRender.renderToStyle((CssStyle)cssStyle, (Font)font);
    }

    public static void asHeightable(CssStyle cssStyle, Heightable able) {
        Render.asHeightable(cssStyle, able, null);
    }

    public static void asHeightable(CssStyle cssStyle, Heightable able, Style fallbackStyle) {
        Extent extent = (Extent)Render.getRP(able, "height", fallbackStyle);
        if (extent != null) {
            ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"height", (Extent)extent);
        }
    }

    public static void asInsetable(CssStyle cssStyle, Insetable able) {
        Render.asInsetable(cssStyle, able, null);
    }

    public static void asInsetable(CssStyle cssStyle, Insetable able, Style fallbackStyle) {
        Insets insets = (Insets)Render.getRP(able, "insets", fallbackStyle);
        if (insets != null) {
            InsetsRender.renderToStyle((CssStyle)cssStyle, (String)"padding", (Insets)insets);
        }
        if ((insets = (Insets)Render.getRP(able, "outsets", fallbackStyle)) != null) {
            InsetsRender.renderToStyle((CssStyle)cssStyle, (String)"margin", (Insets)insets);
        }
    }

    public static void asAlignable(CssStyle cssStyle, Alignable able) {
        Render.asAlignable(cssStyle, able, null);
    }

    public static void asAlignable(CssStyle cssStyle, Alignable able, Style fallbackStyle) {
        Alignment value = (Alignment)Render.getRP(able, "alignment", fallbackStyle);
        if (value != null) {
            AlignmentRender.renderToStyle((CssStyle)cssStyle, (Alignment)value);
        }
    }

    public static void asBackgroundImageable(RenderContext rc, CssStyle cssStyle, BackgroundImageable able) {
        Render.asBackgroundImageable(rc, cssStyle, able, null);
    }

    public static void asBackgroundImageable(RenderContext rc, CssStyle cssStyle, BackgroundImageable able, Style fallbackStyle) {
        Component component = able instanceof Component ? (Component)able : null;
        FillImage fillImage = (FillImage)Render.getRP(able, "backgroundImage", fallbackStyle);
        Render.asBackgroundImageImpl(rc, cssStyle, fillImage, component);
    }

    public static void asBackgroundImage(RenderContext rc, CssStyle cssStyle, FillImage backgroundImage) {
        Render.asBackgroundImageImpl(rc, cssStyle, backgroundImage, null);
    }

    private static void asBackgroundImageImpl(RenderContext rc, CssStyle cssStyle, FillImage backgroundImage, Component component) {
        ImageReference imageRef = backgroundImage != null ? backgroundImage.getImage() : null;
        DirectImageRenderSupport irs = new DirectImageRenderSupport(imageRef);
        FillImageRender.renderToStyle((CssStyle)cssStyle, (RenderContext)rc, (ImageRenderSupport)irs, (Component)component, (String)"backgroundImage", (FillImage)backgroundImage, (int)0);
    }

    public static void asInsets(CssStyle cssStyle, Component component, String propertyName, String cssAttributeName) {
        Render.asInsets(cssStyle, component, propertyName, cssAttributeName, null);
    }

    public static void asInsets(CssStyle cssStyle, Component component, String propertyName, String cssAttributeName, Style fallbackStyle) {
        InsetsRender.renderToStyle((CssStyle)cssStyle, (String)cssAttributeName, (Insets)((Insets)Render.getRP(component, propertyName, fallbackStyle)));
    }

    public static void asMouseCursorable(CssStyle cssStyle, MouseCursorable able) {
        Render.asMouseCursorable(cssStyle, able, null);
    }

    public static void asMouseCursorable(CssStyle cssStyle, MouseCursorable able, Style fallbackStyle) {
        StringBuffer sb = new StringBuffer();
        Integer cursorProperty = (Integer)Render.getRP(able, "mouseCursor", fallbackStyle);
        if (cursorProperty == null) {
            return;
        }
        int mouseCursor = cursorProperty;
        if (mouseCursor == 16) {
            String mouseCursorURI = (String)Render.getRP(able, "mouseCursorUri", fallbackStyle);
            if (mouseCursorURI != null) {
                sb.append("uri('" + HtmlKit.encode(mouseCursorURI) + "');");
            }
        } else {
            switch (mouseCursor) {
                case 0: {
                    sb.append("auto");
                    break;
                }
                case 1: {
                    sb.append("default");
                    break;
                }
                case 2: {
                    sb.append("crosshair");
                    break;
                }
                case 5: {
                    sb.append("e-resize");
                    break;
                }
                case 15: {
                    sb.append("help");
                    break;
                }
                case 4: {
                    sb.append("move");
                    break;
                }
                case 8: {
                    sb.append("n-resize");
                    break;
                }
                case 6: {
                    sb.append("ne-resize");
                    break;
                }
                case 7: {
                    sb.append("nw-resize");
                    break;
                }
                case 3: {
                    sb.append("pointer");
                    break;
                }
                case 11: {
                    sb.append("s-resize");
                    break;
                }
                case 9: {
                    sb.append("se-resize");
                    break;
                }
                case 10: {
                    sb.append("sw-resize");
                    break;
                }
                case 13: {
                    sb.append("text");
                    break;
                }
                case 12: {
                    sb.append("w-resize");
                    break;
                }
                case 14: {
                    sb.append("wait");
                    break;
                }
                default: {
                    return;
                }
            }
        }
        cssStyle.setAttribute("cursor", sb.toString());
    }

    public static void asFloatable(CssStyle cssStyle, Floatable able) {
        Render.asFloatable(cssStyle, able, null);
    }

    public static void asFloatable(CssStyle cssStyle, Floatable able, Style fallbackStyle) {
        int floatDir = Render.getRP(able, "float", fallbackStyle, 0);
        switch (floatDir) {
            case 1: {
                cssStyle.setAttribute("float", "left");
                break;
            }
            case 2: {
                cssStyle.setAttribute("float", "right");
                break;
            }
        }
        int clear = Render.getRP(able, "clearfloat", fallbackStyle, 10);
        switch (clear) {
            case 11: {
                cssStyle.setAttribute("clear", "left");
                break;
            }
            case 12: {
                cssStyle.setAttribute("clear", "right");
                break;
            }
            case 13: {
                cssStyle.setAttribute("clear", "both");
                break;
            }
        }
    }

    public static void asPositionable(CssStyle cssStyle, Positionable able) {
        Render.asPositionable(cssStyle, able, null);
    }

    public static void asPositionable(CssStyle cssStyle, Positionable able, Style fallbackStyle) {
        int zIndex;
        int position = Render.getRP(able, "position", fallbackStyle, 1);
        switch (position) {
            case 2: {
                cssStyle.setAttribute("position", "absolute");
                break;
            }
            case 8: {
                cssStyle.setAttribute("position", "fixed");
                break;
            }
            case 4: {
                cssStyle.setAttribute("position", "relative");
                break;
            }
        }
        if (position != 1) {
            Extent extent = (Extent)Render.getRP(able, "left", fallbackStyle);
            ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"left", (Extent)extent);
            extent = (Extent)Render.getRP(able, "right", fallbackStyle);
            ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"right", (Extent)extent);
            extent = (Extent)Render.getRP(able, "top", fallbackStyle);
            ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"top", (Extent)extent);
            extent = (Extent)Render.getRP(able, "bottom", fallbackStyle);
            ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"bottom", (Extent)extent);
        }
        if ((zIndex = Render.getRP(able, "zIndex", fallbackStyle, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            cssStyle.setAttribute("z-index", String.valueOf(zIndex));
        }
    }

    public static void asScrollable(CssStyle cssStyle, Scrollable able) {
        Render.asScrollable(cssStyle, able, null);
    }

    public static void asScrollable(CssStyle cssStyle, Scrollable able, Style fallbackStyle) {
        int scrollBarPolicy = Render.getRP(able, "scrollBarPolicy", fallbackStyle, 0);
        switch (scrollBarPolicy) {
            case 1: {
                cssStyle.setAttribute("overflow", "visible");
                break;
            }
            case 2: {
                cssStyle.setAttribute("overflow", "scroll");
                break;
            }
            case 4: {
                cssStyle.setAttribute("overflow", "auto");
                break;
            }
            case 8: {
                cssStyle.setAttribute("overflow", "hidden");
                break;
            }
        }
        Render.asSizeable(cssStyle, able, fallbackStyle);
        Render.asColor(cssStyle, (Color)Render.getRP(able, "scrollBarBaseColor", fallbackStyle), "scrollbar-base-color");
        ScrollBarProperties scrollBarProperties = (ScrollBarProperties)Render.getRP(able, "scrollBarProperties", fallbackStyle);
        if (scrollBarProperties != null) {
            Render.asColor(cssStyle, scrollBarProperties.getThreeDLightColor(), "scrollbar-3dlight-color");
            Render.asColor(cssStyle, scrollBarProperties.getArrowColor(), "scrollbar-arrow-color");
            Render.asColor(cssStyle, scrollBarProperties.getBaseColor(), "scretRollbar-base-color");
            Render.asColor(cssStyle, scrollBarProperties.getDarkShadowColor(), "scrollbar-darkshadow-color");
            Render.asColor(cssStyle, scrollBarProperties.getFaceColor(), "scrollbar-face-color");
            Render.asColor(cssStyle, scrollBarProperties.getHilightColor(), "scrollbar-highlight-color");
            Render.asColor(cssStyle, scrollBarProperties.getShadowColor(), "scrollbar-shadow-color");
        }
    }

    public static void asSizeable(CssStyle cssStyle, Sizeable able) {
        Render.asSizeable(cssStyle, able, null);
    }

    public static void asSizeable(CssStyle cssStyle, Sizeable able, Style fallbackStyle) {
        Render.asWidthable(cssStyle, able, fallbackStyle);
        Render.asHeightable(cssStyle, able, fallbackStyle);
    }

    public static void asWidthable(CssStyle cssStyle, Widthable able) {
        Render.asWidthable(cssStyle, able, null);
    }

    public static void asWidthable(CssStyle cssStyle, Widthable able, Style fallbackStyle) {
        Extent extent = (Extent)Render.getRP(able, "width", fallbackStyle);
        if (extent != null) {
            ExtentRender.renderToStyle((CssStyle)cssStyle, (String)"width", (Extent)extent);
        }
    }

    private static void borderRenderImpl(CssStyle cssStyle, Border border) {
        if (border instanceof BorderEx) {
            BorderEx borderEx = (BorderEx)border;
            Color leftColor = borderEx.getLeftColor();
            Extent leftSize = borderEx.getLeftSize();
            int leftStyle = borderEx.getLeftStyle();
            Color rightColor = borderEx.getRightColor();
            Extent rightSize = borderEx.getRightSize();
            int rightStyle = borderEx.getRightStyle();
            Color topColor = borderEx.getTopColor();
            Extent topSize = borderEx.getTopSize();
            int topStyle = borderEx.getTopStyle();
            Color bottomColor = borderEx.getBottomColor();
            Extent bottomSize = borderEx.getBottomSize();
            int bottomStyle = borderEx.getBottomStyle();
            if (Render.eqC(leftColor, rightColor) && Render.eqC(leftColor, topColor) && Render.eqC(leftColor, bottomColor) && Render.eqE(leftSize, rightSize) && Render.eqE(leftSize, topSize) && Render.eqE(leftSize, bottomSize) && leftStyle == rightStyle && leftStyle == topStyle && leftStyle == bottomStyle) {
                BorderRender.renderToStyle((CssStyle)cssStyle, (Border)new Border(leftSize, leftColor, leftStyle));
            } else {
                Render.borderSetAttr(cssStyle, "left-", leftSize, leftColor, leftStyle);
                Render.borderSetAttr(cssStyle, "right-", rightSize, rightColor, rightStyle);
                Render.borderSetAttr(cssStyle, "top-", topSize, topColor, topStyle);
                Render.borderSetAttr(cssStyle, "bottom-", bottomSize, bottomColor, bottomStyle);
            }
        } else {
            BorderRender.renderToStyle((CssStyle)cssStyle, (Border)border);
        }
    }

    private static void borderSetAttr(CssStyle cssStyle, String attrName, Extent size, Color color, int style) {
        if (size != null && size.getValue() > 0) {
            cssStyle.setAttribute("border-" + attrName + "width", ExtentRender.renderCssAttributeValue((Extent)size));
        }
        if (color != null) {
            cssStyle.setAttribute("border-" + attrName + "color", ColorKit.makeCSSColor(color));
        }
        if (size != null && size.getValue() > 0 || color != null) {
            cssStyle.setAttribute("border-" + attrName + "style", Render.borderStyleValue(style));
        } else if (style == 0) {
            cssStyle.setAttribute("border-" + attrName + "style", Render.borderStyleValue(style));
        }
    }

    private static final String borderStyleValue(int style) {
        switch (style) {
            case 0: {
                return "none";
            }
            case 2: {
                return "inset";
            }
            case 3: {
                return "outset";
            }
            case 1: {
                return "solid";
            }
            case 7: {
                return "dotted";
            }
            case 8: {
                return "dashed";
            }
            case 4: {
                return "groove";
            }
            case 5: {
                return "ridge";
            }
            case 6: {
                return "double";
            }
        }
        return "none";
    }

    private static boolean eqC(Color clr1, Color clr2) {
        if (clr1 == clr2) {
            return true;
        }
        if (clr1 != null) {
            return clr1.equals((Object)clr2);
        }
        return clr2.equals((Object)clr1);
    }

    private static boolean eqE(Extent extent1, Extent extent2) {
        if (extent1 == extent2) {
            return true;
        }
        if (extent1 != null) {
            return extent1.equals((Object)extent2);
        }
        return extent2.equals((Object)extent1);
    }

    private static Object getRP(Component component, String propertyName, Style fallbackStyle) {
        Object value = component.getRenderProperty(propertyName);
        if (value == null && fallbackStyle != null) {
            value = fallbackStyle.getProperty(propertyName);
        }
        return value;
    }

    private static Object getRP(Delegateable delegateable, String propertyName, Style fallbackStyle) {
        Object value = delegateable.getRenderProperty(propertyName);
        if (value == null && fallbackStyle != null) {
            value = fallbackStyle.getProperty(propertyName);
        }
        return value;
    }

    private static int getRP(Delegateable delegateable, String propertyName, Style fallbackStyle, int fallbackValue) {
        Object value = delegateable.getRenderProperty(propertyName);
        if (value == null && fallbackStyle != null) {
            value = fallbackStyle.getProperty(propertyName);
        }
        if (value == null) {
            value = new Integer(fallbackValue);
        }
        return (Integer)value;
    }

    public static void layoutFix(RenderContext rc, CssStyle style) {
        if (Render.isClientIE6(rc) && ("absolute".equalsIgnoreCase(style.getAttribute("position")) || "relative".equalsIgnoreCase(style.getAttribute("position")))) {
            style.setAttribute("zoom", "1");
        }
    }

    public static boolean isClientIE6(RenderContext rc) {
        ClientProperties props = rc.getContainerInstance().getClientProperties();
        return props.getBoolean("browserInternetExplorer") && "6".equals(props.getString("browserVersionMajor"));
    }

    public static boolean isClientIE(RenderContext rc) {
        ClientProperties props = rc.getContainerInstance().getClientProperties();
        return props.getBoolean("browserInternetExplorer");
    }

    public static CssStyle itsDisplayLayoutData(RenderContext rc, Component child) {
        CssStyleEx style = new CssStyleEx();
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData instanceof DisplayLayoutData) {
            Render.renderDisplayLayoutDataToStyle(rc, (DisplayLayoutData)layoutData, style);
        }
        return style;
    }

    public static CssStyle itsDisplayLayoutData(RenderContext rc, XhtmlFragment child) {
        CssStyleEx style = new CssStyleEx();
        LayoutData layoutData = child.getLayoutData();
        if (layoutData instanceof DisplayLayoutData) {
            Render.renderDisplayLayoutDataToStyle(rc, (DisplayLayoutData)layoutData, style);
        }
        return style;
    }

    private static void renderDisplayLayoutDataToStyle(RenderContext rc, DisplayLayoutData dld, CssStyle style) {
        Render.asAble(style, dld);
        Render.asColor(style, dld.getForeground(), "color");
        Render.asColor(style, dld.getBackground(), "background-color");
        Render.asFont(style, dld.getFont());
        Render.asBackgroundImageable(rc, style, dld);
        if (dld.isInlineLayout()) {
            style.setAttribute("display", "inline");
        }
    }

    public static void itsDisplayLayoutData(RenderContext rc, Component child, Element element) {
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData instanceof DisplayLayoutData) {
            Render.renderDisplayLayoutDataToElement(rc, (DisplayLayoutData)layoutData, element);
        }
    }

    public static void itsDisplayLayoutData(RenderContext rc, XhtmlFragment child, Element element) {
        LayoutData layoutData = child.getLayoutData();
        if (layoutData instanceof DisplayLayoutData) {
            Render.renderDisplayLayoutDataToElement(rc, (DisplayLayoutData)layoutData, element);
        }
    }

    private static void renderDisplayLayoutDataToElement(RenderContext rc, DisplayLayoutData dld, Element element) {
        if (dld.getToolTipText() != null) {
            element.setAttribute("title", dld.getToolTipText());
        }
    }

    private static class DirectImageRenderSupport
    implements ImageRenderSupport {
        private ImageReference image;

        private DirectImageRenderSupport(ImageReference image) {
            this.image = image;
        }

        public ImageReference getImage(Component component, String imageId) {
            return this.image;
        }
    }
}

