/*
 * Decompiled with CFR 0.152.
 */
package echopointng.ui.util;

import echopointng.ComponentEx;
import echopointng.able.AccessKeyable;
import echopointng.able.Attributeable;
import echopointng.able.ToolTipable;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.RenderState;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.servermessage.DomPropertyStore;
import nextapp.echo2.webrender.servermessage.EventProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class RenderingContext
implements RenderContext {
    Component component;
    RenderContext rc;
    RenderState renderState;
    ServerComponentUpdate serverComponentUpdate;

    public RenderingContext(RenderContext rc, ServerComponentUpdate serverComponentUpdate, Component component) {
        this.rc = rc;
        this.serverComponentUpdate = serverComponentUpdate;
        this.component = component;
    }

    public void addAccessKeySupport(Component component, Element element) {
        if (component instanceof AccessKeyable) {
            if (!component.isRenderEnabled()) {
                return;
            }
            AccessKeyable ak = (AccessKeyable)component;
            if (ak.getRenderProperty("accessKey") instanceof String) {
                element.setAttribute("accesskey", (String)ak.getRenderProperty("accessKey"));
            }
        }
    }

    public void addToolTipSupport(Component component, Element element) {
        if (component instanceof ToolTipable) {
            if (!component.isRenderEnabled()) {
                return;
            }
            ToolTipable tt = (ToolTipable)component;
            if (tt.getRenderProperty("toolTipText") instanceof String) {
                element.setAttribute("title", (String)tt.getRenderProperty("toolTipText"));
            }
        }
    }

    public void addAccessKeySupport(Element element) {
        this.addDisabledSupport(this.component, element);
    }

    public void addDisabledSupport(Component component, Element element) {
        if (!component.isRenderEnabled()) {
            element.setAttribute("disabled", "disabled");
        }
    }

    public void addDisabledSupport(Element element) {
        this.addDisabledSupport(this.component, element);
    }

    public void addAttributeableSupport(Component component, Element element) {
        if (component instanceof Attributeable) {
            Attributeable attributeable = (Attributeable)component;
            String[] attributeNames = attributeable.getAttributeNames();
            for (int i = 0; i < attributeNames.length; ++i) {
                String attributeName = attributeNames[i];
                Object attributeValue = attributeable.getAttribute(attributeName);
                element.setAttribute(attributeName, String.valueOf(attributeValue));
            }
        }
    }

    public void addLibrary(Service service) {
        this.rc.getServerMessage().addLibrary(service.getId());
    }

    public void addStandardWebSupport(Component component, Element element) {
        this.addAccessKeySupport(component, element);
        this.addDisabledSupport(component, element);
        this.addTabIndexSupport(component, element);
        this.addToolTipSupport(component, element);
        this.addAttributeableSupport(component, element);
    }

    public void addStandardWebSupport(Element element) {
        this.addStandardWebSupport(this.component, element);
    }

    public void addTabIndexSupport(Component component, Element element) {
        if (component.isRenderEnabled() && component.isFocusTraversalParticipant()) {
            element.setAttribute("tabindex", Integer.toString(component.getFocusTraversalIndex()));
        }
    }

    public void addTabIndexSupport(Element element) {
        this.addTabIndexSupport(this.component, element);
    }

    public Element createE(String elementName) {
        return this.rc.getServerMessage().getDocument().createElement(elementName);
    }

    public Text createText(String text) {
        return this.rc.getServerMessage().getDocument().createTextNode(text);
    }

    public Component getComponent() {
        return this.component;
    }

    public Connection getConnection() {
        return this.rc.getConnection();
    }

    public ContainerInstance getContainerInstance() {
        return this.rc.getContainerInstance();
    }

    public Document getDocument() {
        return this.rc.getServerMessage().getDocument();
    }

    public String getElementId() {
        return ContainerInstance.getElementId((Component)this.component);
    }

    public RenderState getRenderState() {
        return this.rc.getContainerInstance().getRenderState(this.component);
    }

    public Object getRP(String propertyName) {
        return ComponentEx.getRenderProperty(this.component, propertyName);
    }

    public boolean getRP(String propertyName, boolean defaultValue) {
        return ComponentEx.getRenderProperty(this.component, propertyName, defaultValue);
    }

    public boolean getRP(String propertyName, Style defaultStyle, boolean defaultValue) {
        Boolean value = (Boolean)this.component.getRenderProperty(propertyName);
        if (value == null && defaultStyle != null) {
            value = (Boolean)defaultStyle.getProperty(propertyName);
        }
        return value == null ? defaultValue : value;
    }

    public byte getRP(String propertyName, byte defaultValue) {
        return ComponentEx.getRenderProperty(this.component, propertyName, defaultValue);
    }

    public char getRP(String propertyName, char defaultValue) {
        return ComponentEx.getRenderProperty(this.component, propertyName, defaultValue);
    }

    public double getRP(String propertyName, double defaultValue) {
        return ComponentEx.getRenderProperty(this.component, propertyName, defaultValue);
    }

    public double getRP(String propertyName, Style defaultStyle, double defaultValue) {
        Double value = (Double)this.component.getRenderProperty(propertyName);
        if (value == null && defaultStyle != null) {
            value = (Double)defaultStyle.getProperty(propertyName);
        }
        return value == null ? defaultValue : value;
    }

    public float getRP(String propertyName, float defaultValue) {
        return ComponentEx.getRenderProperty(this.component, propertyName, defaultValue);
    }

    public int getRP(String propertyName, int defaultValue) {
        return ComponentEx.getRenderProperty(this.component, propertyName, defaultValue);
    }

    public int getRP(String propertyName, Style defaultStyle, int defaultValue) {
        Integer value = (Integer)this.component.getRenderProperty(propertyName);
        if (value == null && defaultStyle != null) {
            value = (Integer)defaultStyle.getProperty(propertyName);
        }
        return value == null ? defaultValue : value;
    }

    public long getRP(String propertyName, long defaultValue) {
        return ComponentEx.getRenderProperty(this.component, propertyName, defaultValue);
    }

    public Object getRP(String propertyName, Object defaultValue) {
        Object value = ComponentEx.getRenderProperty(this.component, propertyName);
        return value != null ? value : defaultValue;
    }

    public Object getRP(String propertyName, Style defaultStyle, Object defaultValue) {
        Object value = ComponentEx.getRenderProperty(this.component, propertyName);
        if (value == null && defaultStyle != null) {
            value = defaultStyle.getProperty(propertyName);
        }
        return value != null ? value : defaultValue;
    }

    public short getRP(String propertyName, short defaultValue) {
        return ComponentEx.getRenderProperty(this.component, propertyName, defaultValue);
    }

    public Object getRP(String propertyName, Style defaultStyle) {
        Object value = ComponentEx.getRenderProperty(this.component, propertyName);
        if (value == null && defaultStyle != null) {
            value = defaultStyle.getProperty(propertyName);
        }
        return value;
    }

    public ServerComponentUpdate getServerComponentUpdate() {
        return this.serverComponentUpdate;
    }

    public ServerMessage getServerMessage() {
        return this.rc.getServerMessage();
    }

    public void renderEventAdd(String eventType, String elementId, String eventHandler) {
        EventProcessor.renderEventAdd((ServerMessage)this.rc.getServerMessage(), (String)eventType, (String)elementId, (String)eventHandler);
    }

    public void renderEventRemove(String eventType, String elementId) {
        EventProcessor.renderEventRemove((ServerMessage)this.rc.getServerMessage(), (String)eventType, (String)elementId);
    }

    public void renderSetProperty(String elementId, String propertyName, String propertyValue) {
        DomPropertyStore.renderSetProperty((ServerMessage)this.getServerMessage(), (String)elementId, (String)propertyName, (String)propertyValue);
    }
}

