/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.MediaMode;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlConfig
implements Config {
    public static final int RTP_DEFAULT_PORT = 8000;
    private Logger logger;
    private File file;
    private Document document;
    private InetAddress localInetAddress;
    private String userPart;
    private String domain;
    private String password;
    private SipURI outboundProxy;
    private int sipPort;
    private MediaMode mediaMode;
    private boolean mediaDebug;
    private String mediaFile;
    private int rtpPort;
    private Node ipAddressNode;
    private Node userPartNode;
    private Node domainNode;
    private Node passwordNode;
    private Node outboundProxyNode;
    private Node sipPortNode;
    private Node mediaModeNode;
    private Node mediaDebugNode;
    private Node mediaFileNode;
    private Node rtpPortNode;
    private InetAddress publicInetAddress;

    public XmlConfig(String fileName, Logger logger) {
        DocumentBuilder documentBuilder;
        this.file = new File(fileName);
        this.logger = logger;
        if (!this.file.exists()) {
            logger.debug("config file " + fileName + " not found");
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("parser configuration exception", e);
            return;
        }
        try {
            this.document = documentBuilder.parse(this.file);
        }
        catch (SAXException e) {
            logger.error("cannot parse " + fileName, e);
            return;
        }
        catch (IOException e) {
            logger.error("IOException", e);
            return;
        }
        Element documentElement = this.document.getDocumentElement();
        this.ipAddressNode = this.getFirstChild(documentElement, "ipAddress");
        String address = this.ipAddressNode.getTextContent();
        try {
            this.localInetAddress = this.isNullOrEmpty(this.ipAddressNode) ? InetAddress.getLocalHost() : InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            logger.error("unknown host: " + address, e);
        }
        this.userPartNode = this.getFirstChild(documentElement, "userPart");
        if (this.isNullOrEmpty(this.userPartNode)) {
            logger.error("userpart not found in configuration file");
        } else {
            this.userPart = this.userPartNode.getTextContent();
        }
        this.domainNode = this.getFirstChild(documentElement, "domain");
        if (this.isNullOrEmpty(this.domainNode)) {
            logger.error("domain not found in configuration file");
        } else {
            this.domain = this.domainNode.getTextContent();
        }
        this.passwordNode = this.getFirstChild(documentElement, "password");
        if (!this.isNullOrEmpty(this.passwordNode)) {
            this.password = this.passwordNode.getTextContent();
        }
        this.outboundProxyNode = this.getFirstChild(documentElement, "outboundProxy");
        if (!this.isNullOrEmpty(this.outboundProxyNode)) {
            String uri = this.outboundProxyNode.getTextContent();
            try {
                this.outboundProxy = new SipURI(uri);
            }
            catch (SipUriSyntaxException e) {
                logger.error("sip uri syntax exception: " + uri, e);
            }
        }
        this.sipPortNode = this.getFirstChild(documentElement, "sipPort");
        this.sipPort = this.isNullOrEmpty(this.sipPortNode) ? 5060 : Integer.parseInt(this.sipPortNode.getTextContent());
        this.mediaModeNode = this.getFirstChild(documentElement, "mediaMode");
        this.mediaMode = this.isNullOrEmpty(this.mediaModeNode) ? MediaMode.captureAndPlayback : MediaMode.valueOf(this.mediaModeNode.getTextContent());
        this.mediaDebugNode = this.getFirstChild(documentElement, "mediaDebug");
        this.mediaDebug = this.isNullOrEmpty(this.mediaDebugNode) ? false : Boolean.parseBoolean(this.mediaDebugNode.getTextContent());
        this.mediaFileNode = this.getFirstChild(documentElement, "mediaFile");
        if (!this.isNullOrEmpty(this.mediaFileNode)) {
            this.mediaFile = this.mediaFileNode.getTextContent();
        }
        if (this.mediaMode == MediaMode.file && (this.mediaFile == null || "".equals(this.mediaFile.trim()))) {
            logger.error("streaming from file but no file provided");
        }
        this.rtpPortNode = this.getFirstChild(documentElement, "rtpPort");
        if (this.isNullOrEmpty(this.rtpPortNode)) {
            this.rtpPort = 8000;
        } else {
            this.rtpPort = Integer.parseInt(this.rtpPortNode.getTextContent());
            if (this.rtpPort % 2 != 0) {
                logger.error("rtp port provided is " + this.rtpPort + " rtp port must be even");
            }
        }
    }

    private boolean isNullOrEmpty(Node node) {
        return node == null || "".equals(node.getTextContent().trim());
    }

    private Node getFirstChild(Node parent, String childName) {
        if (parent == null || childName == null) {
            return null;
        }
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!childName.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    public void save() {
        FileWriter fileWriter;
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            this.logger.error("cannot create transformer", e);
            return;
        }
        try {
            fileWriter = new FileWriter(this.file);
        }
        catch (IOException e) {
            this.logger.error("cannot create file writer", e);
            return;
        }
        StreamResult streamResult = new StreamResult(fileWriter);
        DOMSource domSource = new DOMSource(this.document);
        try {
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerException e) {
            this.logger.error("cannot save config file", e);
            return;
        }
        this.logger.debug("config file saved");
    }

    public InetAddress getLocalInetAddress() {
        return this.localInetAddress;
    }

    public InetAddress getPublicInetAddress() {
        return this.publicInetAddress;
    }

    public String getUserPart() {
        return this.userPart;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPassword() {
        return this.password;
    }

    public SipURI getOutboundProxy() {
        return this.outboundProxy;
    }

    public int getSipPort() {
        return this.sipPort;
    }

    public MediaMode getMediaMode() {
        return this.mediaMode;
    }

    public boolean isMediaDebug() {
        return this.mediaDebug;
    }

    public int getRtpPort() {
        return this.rtpPort;
    }

    public void setLocalInetAddress(InetAddress inetAddress) {
        this.localInetAddress = inetAddress;
        this.ipAddressNode.setTextContent(inetAddress.getHostAddress());
    }

    public void setPublicInetAddress(InetAddress inetAddress) {
        this.publicInetAddress = inetAddress;
    }

    public void setUserPart(String userPart) {
        this.userPart = userPart;
        this.userPartNode.setTextContent(userPart);
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.domainNode.setTextContent(domain);
    }

    public void setPassword(String password) {
        this.password = password;
        this.passwordNode.setTextContent(password);
    }

    public void setOutboundProxy(SipURI outboundProxy) {
        this.outboundProxy = outboundProxy;
        if (outboundProxy == null) {
            this.outboundProxyNode.setTextContent("");
        } else {
            this.outboundProxyNode.setTextContent(outboundProxy.toString());
        }
    }

    public void setSipPort(int sipPort) {
        this.sipPort = sipPort;
        this.sipPortNode.setTextContent(Integer.toString(sipPort));
    }

    public void setMediaMode(MediaMode mediaMode) {
        this.mediaMode = mediaMode;
        this.mediaModeNode.setTextContent(mediaMode.toString());
    }

    public void setMediaDebug(boolean mediaDebug) {
        this.mediaDebug = mediaDebug;
        this.mediaDebugNode.setTextContent(Boolean.toString(mediaDebug));
    }

    public void setRtpPort(int rtpPort) {
        this.rtpPort = rtpPort;
        this.rtpPortNode.setTextContent(Integer.toString(rtpPort));
    }

    public String getMediaFile() {
        return this.mediaFile;
    }

    public void setMediaFile(String mediaFile) {
        this.mediaFile = mediaFile;
    }
}

