/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.peers.Logger;

public class AboutFrame
extends JFrame
implements ActionListener,
HyperlinkListener {
    public static final String LICENSE_FILE = File.separator + "gpl.txt";
    private static final long serialVersionUID = 1L;
    private Logger logger;

    public AboutFrame(String peersHome, Logger logger) {
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        String message = "Peers: java SIP softphone<br>Copyright 2007-2010 Yohann Martineau<br><a href=\"http://peers.sourceforge.net/\">http://peers.sourceforge.net/</a>";
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        textPane.setEditable(false);
        textPane.setText(message);
        textPane.addHyperlinkListener(this);
        textPane.setOpaque(false);
        textPane.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        this.add((Component)textPane, "First");
        String gpl = null;
        try {
            String line;
            FileReader fileReader = new FileReader(peersHome + LICENSE_FILE);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuffer buf = new StringBuffer();
            while ((line = bufferedReader.readLine()) != null) {
                buf.append("  ");
                buf.append(line);
                buf.append("\r\n");
            }
            bufferedReader.close();
            gpl = buf.toString();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        Font font = textArea.getFont();
        font = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        textArea.setFont(font);
        if (gpl != null) {
            textArea.setText(gpl);
        }
        JPanel panel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(textArea);
        textArea.setCaretPosition(0);
        panel.add(scrollPane);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add((Component)panel, "Center");
        panel = new JPanel();
        JButton button = new JButton("Close");
        button.addActionListener(this);
        panel.add(button);
        this.add((Component)panel, "Last");
        this.pack();
        Dimension dimension = scrollPane.getSize();
        dimension = new Dimension(dimension.width + 20, 300);
        scrollPane.setPreferredSize(dimension);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(hyperlinkEvent.getEventType())) {
            try {
                URI uri = hyperlinkEvent.getURL().toURI();
                Desktop.getDesktop().browse(uri);
            }
            catch (URISyntaxException e) {
                this.logger.error(e.getMessage(), e);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
    }
}

