/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.gui;

import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.gui.RegistrationState;
import net.sourceforge.peers.gui.RegistrationStateFailed;
import net.sourceforge.peers.gui.RegistrationStateRegistering;
import net.sourceforge.peers.gui.RegistrationStateSuccess;
import net.sourceforge.peers.gui.RegistrationStateUnregsitered;

public class Registration {
    public final RegistrationState UNREGISTERED;
    public final RegistrationState REGISTERING;
    public final RegistrationState SUCCESS;
    public final RegistrationState FAILED;
    protected JLabel label;
    private RegistrationState state;

    public Registration(JLabel label, Logger logger) {
        this.label = label;
        String id = String.valueOf(this.hashCode());
        this.state = this.UNREGISTERED = new RegistrationStateUnregsitered(id, this, logger);
        this.REGISTERING = new RegistrationStateRegistering(id, this, logger);
        this.SUCCESS = new RegistrationStateSuccess(id, this, logger);
        this.FAILED = new RegistrationStateFailed(id, this, logger);
    }

    public void setState(RegistrationState state) {
        this.state = state;
    }

    public synchronized void registerSent() {
        this.state.registerSent();
    }

    public synchronized void registerFailed() {
        this.state.registerFailed();
    }

    public synchronized void registerSuccessful() {
        this.state.registerSuccessful();
    }

    protected void displayRegistering() {
        URL url = this.getClass().getResource("working.gif");
        ImageIcon imageIcon = new ImageIcon(url);
        this.label.setIcon(imageIcon);
        this.label.setText("Registering");
    }
}

