/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.SoundSource;

public class Capture
implements Runnable {
    public static final int SAMPLE_SIZE = 16;
    public static final int BUFFER_SIZE = 320;
    private PipedOutputStream rawData;
    private boolean isStopped;
    private SoundSource soundSource;
    private Logger logger;
    private CountDownLatch latch;

    public Capture(PipedOutputStream rawData, SoundSource soundSource, Logger logger, CountDownLatch latch) {
        this.rawData = rawData;
        this.soundSource = soundSource;
        this.logger = logger;
        this.latch = latch;
        this.isStopped = false;
    }

    public void run() {
        while (!this.isStopped) {
            byte[] buffer = this.soundSource.readData();
            try {
                if (buffer == null) break;
                this.rawData.write(buffer);
                this.rawData.flush();
            }
            catch (IOException e) {
                this.logger.error("input/output error", e);
                return;
            }
        }
        this.latch.countDown();
        if (this.latch.getCount() != 0L) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                this.logger.error("interrupt exception", e);
            }
        }
    }

    public synchronized void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }
}

