/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import net.sourceforge.peers.Logger;

public class Echo
implements Runnable {
    public static final int BUFFER_SIZE = 2048;
    private DatagramSocket datagramSocket;
    private InetAddress remoteAddress;
    private int remotePort;
    private boolean isRunning;
    private Logger logger;

    public Echo(DatagramSocket datagramSocket, String remoteAddress, int remotePort, Logger logger) throws UnknownHostException {
        this.datagramSocket = datagramSocket;
        this.remoteAddress = InetAddress.getByName(remoteAddress);
        this.remotePort = remotePort;
        this.logger = logger;
        this.isRunning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.isRunning) {
                byte[] buf = new byte[2048];
                DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length);
                try {
                    this.datagramSocket.receive(datagramPacket);
                }
                catch (SocketTimeoutException e) {
                    this.logger.debug("echo socket timeout");
                    continue;
                }
                datagramPacket = new DatagramPacket(buf, datagramPacket.getLength(), this.remoteAddress, this.remotePort);
                this.datagramSocket.send(datagramPacket);
            }
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
        }
        finally {
            this.datagramSocket.close();
        }
    }

    public synchronized void stop() {
        this.isRunning = false;
    }
}

