/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.IOException;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.Decoder;
import net.sourceforge.peers.media.PcmaDecoder;
import net.sourceforge.peers.media.PcmuDecoder;
import net.sourceforge.peers.rtp.RtpListener;
import net.sourceforge.peers.rtp.RtpPacket;
import net.sourceforge.peers.rtp.RtpSession;
import net.sourceforge.peers.sdp.Codec;

public class IncomingRtpReader
implements RtpListener {
    private RtpSession rtpSession;
    private AbstractSoundManager soundManager;
    private Decoder decoder;

    public IncomingRtpReader(RtpSession rtpSession, AbstractSoundManager soundManager, Codec codec, Logger logger) throws IOException {
        logger.debug("playback codec:" + codec.toString().trim());
        this.rtpSession = rtpSession;
        this.soundManager = soundManager;
        switch (codec.getPayloadType()) {
            case 0: {
                this.decoder = new PcmuDecoder();
                break;
            }
            case 8: {
                this.decoder = new PcmaDecoder();
                break;
            }
            default: {
                throw new RuntimeException("unsupported payload type");
            }
        }
        rtpSession.addRtpListener(this);
    }

    public void start() {
        this.rtpSession.start();
    }

    public void receivedRtpPacket(RtpPacket rtpPacket) {
        byte[] rawBuf = this.decoder.process(rtpPacket.getData());
        if (this.soundManager != null) {
            this.soundManager.writeData(rawBuf, 0, rawBuf.length);
        }
    }
}

