/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.Encoder;

public class PcmaEncoder
extends Encoder {
    private static final int cClip = 32635;
    private static byte[] aLawCompressTable = new byte[]{1, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};

    public PcmaEncoder(PipedInputStream rawData, PipedOutputStream encodedData, boolean mediaDebug, Logger logger, String peersHome, CountDownLatch latch) {
        super(rawData, encodedData, mediaDebug, logger, peersHome, latch);
    }

    public byte[] process(byte[] media) {
        byte[] compressed = new byte[media.length / 2];
        int j = 0;
        for (int i = 0; i < compressed.length; ++i) {
            short sample = (short)(media[j++] & 0xFF | media[j++] << 8);
            compressed[i] = this.linearToALawSample(sample);
        }
        return compressed;
    }

    private byte linearToALawSample(short sample) {
        int s;
        int sign = ~sample >> 8 & 0x80;
        if (sign != 128) {
            sample = -sample;
        }
        if (sample > 32635) {
            sample = (short)32635;
        }
        if (sample >= 256) {
            byte exponent = aLawCompressTable[sample >> 8 & 0x7F];
            int mantissa = sample >> exponent + 3 & 0xF;
            s = exponent << 4 | mantissa;
        } else {
            s = sample >> 4;
        }
        return (byte)(s ^= sign ^ 0x55);
    }
}

