/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.Encoder;

public class PcmuEncoder
extends Encoder {
    private static final int cBias = 132;
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};

    private static byte linear2ulaw(short pcm_val) {
        int mask;
        if (pcm_val < 0) {
            pcm_val = (short)(132 - pcm_val);
            mask = 127;
        } else {
            pcm_val = (short)(pcm_val + 132);
            mask = 255;
        }
        int seg = PcmuEncoder.search(pcm_val, seg_end, 8);
        if (seg >= 8) {
            return (byte)(0x7F ^ mask);
        }
        byte uval = (byte)(seg << 4 | pcm_val >> seg + 3 & 0xF);
        return (byte)(uval ^ mask);
    }

    private static int search(int val, short[] table, int size) {
        for (int i = 0; i < size; ++i) {
            if (val > table[i]) continue;
            return i;
        }
        return size;
    }

    public PcmuEncoder(PipedInputStream rawData, PipedOutputStream encodedData, boolean mediaDebug, Logger logger, String peersHome, CountDownLatch latch) {
        super(rawData, encodedData, mediaDebug, logger, peersHome, latch);
    }

    public byte[] process(byte[] media) {
        byte[] compressed = new byte[media.length / 2];
        int j = 0;
        for (int i = 0; i < compressed.length; ++i) {
            short sample = (short)(media[j++] & 0xFF | media[j++] << 8);
            compressed[i] = PcmuEncoder.linear2ulaw(sample);
        }
        return compressed;
    }
}

