/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.nat;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PeerManager
extends Thread {
    private InetAddress localAddress;
    private int localPort;
    private Document document;

    public PeerManager(InetAddress localAddress, int localPort) {
        this.localAddress = localAddress;
        this.localPort = localPort;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void run() {
        DatagramSocket datagramSocket;
        try {
            datagramSocket = new DatagramSocket(this.localPort, this.localAddress);
        }
        catch (SocketException e) {
            e.printStackTrace();
            return;
        }
        while (true) {
            Element root = this.document.getDocumentElement();
            NodeList peers = root.getChildNodes();
            for (int i = 0; i < peers.getLength(); ++i) {
                Node node = peers.item(i);
                if (!node.getNodeName().equals("peer")) continue;
                this.createConnection(node, datagramSocket);
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private void createConnection(Node peer, DatagramSocket datagramSocket) {
        NodeList childNodes = peer.getChildNodes();
        String ipAddress = null;
        String port = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("ipaddress")) {
                ipAddress = node.getTextContent();
                continue;
            }
            if (!nodeName.equals("port")) continue;
            port = node.getTextContent();
        }
        if (ipAddress == null || port == null) {
            return;
        }
        int remotePort = Integer.parseInt(port);
        try {
            InetAddress remoteAddress = InetAddress.getByName(ipAddress);
            for (int i = 0; i < 5; ++i) {
                String message = "hello world " + System.currentTimeMillis();
                byte[] buf = message.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(buf, buf.length, remoteAddress, remotePort);
                datagramSocket.send(datagramPacket);
                System.out.println("> sent:\n" + message);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

