/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sdp;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.peers.sdp.Codec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaDescription {
    private String type;
    private InetAddress ipAddress;
    private Hashtable<String, String> attributes;
    private int port;
    private List<Codec> codecs;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Hashtable<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Hashtable<String, String> attributes) {
        this.attributes = attributes;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<Codec> getCodecs() {
        return this.codecs;
    }

    public void setCodecs(List<Codec> codecs) {
        this.codecs = codecs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('m').append('=');
        buf.append(this.type).append(" ").append(this.port);
        buf.append(" RTP/AVP");
        for (Codec codec : this.codecs) {
            buf.append(" ");
            buf.append(codec.getPayloadType());
        }
        buf.append("\r\n");
        if (this.ipAddress != null) {
            int ipVersion;
            if (this.ipAddress instanceof Inet4Address) {
                ipVersion = 4;
            } else if (this.ipAddress instanceof Inet6Address) {
                ipVersion = 6;
            } else {
                throw new RuntimeException("unknown ip version: " + this.ipAddress);
            }
            buf.append('c').append('=');
            buf.append("IN IP").append(ipVersion).append(" ");
            buf.append(this.ipAddress.getHostAddress()).append("\r\n");
        }
        for (Codec codec : this.codecs) {
            buf.append(codec.toString());
        }
        if (this.attributes != null) {
            for (String attributeName : this.attributes.keySet()) {
                buf.append('a').append('=');
                buf.append(attributeName);
                String attributeValue = this.attributes.get(attributeName);
                if (attributeValue != null && !"".equals(attributeValue.trim())) {
                    buf.append(":").append(attributeValue);
                }
                buf.append("\r\n");
            }
        }
        return buf.toString();
    }
}

