/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.core.useragent.InitialRequestManager;
import net.sourceforge.peers.sip.core.useragent.MessageInterceptor;
import net.sourceforge.peers.sip.core.useragent.MidDialogRequestManager;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;

public class ChallengeManager
implements MessageInterceptor {
    public static final String ALGORITHM_MD5 = "MD5";
    private String username;
    private String password;
    private String realm;
    private String nonce;
    private String opaque;
    private String requestUri;
    private String digest;
    private String profileUri;
    private String qop;
    private String cnonce;
    private static volatile int nonceCount = 1;
    private String nonceCountHex;
    private Config config;
    private Logger logger;
    private int statusCode;
    private SipHeaderFieldValue contact;
    private InitialRequestManager initialRequestManager;
    private MidDialogRequestManager midDialogRequestManager;
    private DialogManager dialogManager;

    public ChallengeManager(Config config, InitialRequestManager initialRequestManager, MidDialogRequestManager midDialogRequestManager, DialogManager dialogManager, Logger logger) {
        this.config = config;
        this.initialRequestManager = initialRequestManager;
        this.midDialogRequestManager = midDialogRequestManager;
        this.dialogManager = dialogManager;
        this.logger = logger;
        this.init();
    }

    private void init() {
        this.username = this.config.getUserPart();
        this.password = this.config.getPassword();
        this.profileUri = "sip:" + this.username + '@' + this.config.getDomain();
    }

    private String md5hash(String message) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(ALGORITHM_MD5);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("no such algorithm MD5", e);
            return null;
        }
        byte[] messageBytes = message.getBytes();
        byte[] messageMd5 = messageDigest.digest(messageBytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out);
        for (int n : messageMd5) {
            int u_b = n < 0 ? 256 + n : n;
            printStream.printf("%02x", u_b);
        }
        return out.toString();
    }

    public void handleChallenge(SipRequest sipRequest, SipResponse sipResponse) {
        SipHeaderFieldName authenticateHeaderName;
        this.init();
        this.statusCode = sipResponse.getStatusCode();
        SipHeaders responseHeaders = sipResponse.getSipHeaders();
        SipHeaders requestHeaders = sipRequest.getSipHeaders();
        this.contact = requestHeaders.get(new SipHeaderFieldName("Contact"));
        if (this.statusCode == 401) {
            authenticateHeaderName = new SipHeaderFieldName("WWW-Authenticate");
        } else if (this.statusCode == 407) {
            authenticateHeaderName = new SipHeaderFieldName("Proxy-Authenticate");
        } else {
            return;
        }
        SipHeaderFieldValue authenticate = responseHeaders.get(authenticateHeaderName);
        if (authenticate == null) {
            return;
        }
        if (!authenticate.getValue().startsWith("Digest")) {
            this.logger.info("unsupported challenge scheme in header: " + authenticate);
            return;
        }
        String headerValue = authenticate.getValue();
        this.realm = this.getParameter("realm", headerValue);
        this.nonce = this.getParameter("nonce", headerValue);
        this.opaque = this.getParameter("opaque", headerValue);
        this.qop = this.getParameter("qop", headerValue);
        if ("auth".equals(this.qop)) {
            this.nonceCountHex = String.format("%08X", nonceCount++);
        }
        String method = sipRequest.getMethod();
        this.requestUri = sipRequest.getRequestUri().toString();
        this.cnonce = UUID.randomUUID().toString();
        this.digest = this.getRequestDigest(method);
        String callId = responseHeaders.get(new SipHeaderFieldName("Call-ID")).getValue();
        Dialog dialog = this.dialogManager.getDialog(callId);
        if (dialog != null) {
            this.midDialogRequestManager.generateMidDialogRequest(dialog, "BYE", this);
        } else {
            SipHeaderFieldValue from = requestHeaders.get(new SipHeaderFieldName("From"));
            String fromTag = from.getParam(new SipHeaderParamName("tag"));
            try {
                this.initialRequestManager.createInitialRequest(this.requestUri, method, this.profileUri, callId, fromTag, this);
            }
            catch (SipUriSyntaxException e) {
                this.logger.error("syntax error", e);
            }
        }
    }

    private String getRequestDigest(String method) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.username);
        buf.append(':');
        buf.append(this.realm);
        buf.append(':');
        buf.append(this.password);
        String ha1 = this.md5hash(buf.toString());
        buf = new StringBuffer();
        buf.append(method);
        buf.append(':');
        buf.append(this.requestUri);
        String ha2 = this.md5hash(buf.toString());
        buf = new StringBuffer();
        buf.append(ha1);
        buf.append(':');
        buf.append(this.nonce);
        buf.append(':');
        if ("auth".equals(this.qop)) {
            buf.append(this.nonceCountHex);
            buf.append(':');
            buf.append(this.cnonce);
            buf.append(':');
            buf.append(this.qop);
            buf.append(':');
        }
        buf.append(ha2);
        return this.md5hash(buf.toString());
    }

    private String getParameter(String paramName, String header) {
        int paramPos = header.indexOf(paramName);
        if (paramPos < 0) {
            return null;
        }
        int paramNameLength = paramName.length();
        if (paramPos + paramNameLength + 3 > header.length()) {
            this.logger.info("Malformed WWW-Authenticate header");
            return null;
        }
        if (header.charAt(paramPos + paramNameLength) != '=') {
            this.logger.info("Malformed WWW-Authenticate header");
            return null;
        }
        if (header.charAt(paramPos + paramNameLength + 1) != '\"') {
            this.logger.info("Malformed WWW-Authenticate header");
            return null;
        }
        int endDelimiter = (header = header.substring(paramPos + paramNameLength + 2)).indexOf(34);
        if (endDelimiter < 0) {
            this.logger.info("Malformed WWW-Authenticate header");
            return null;
        }
        return header.substring(0, endDelimiter);
    }

    public void postProcess(SipMessage sipMessage) {
        SipHeaderParamName expiresName;
        String expiresString;
        SipHeaderFieldName authorizationName;
        if (this.realm == null || this.nonce == null || this.digest == null) {
            return;
        }
        SipHeaders sipHeaders = sipMessage.getSipHeaders();
        String cseq = sipHeaders.get(new SipHeaderFieldName("CSeq")).getValue();
        String method = cseq.substring(cseq.trim().lastIndexOf(32) + 1);
        this.digest = this.getRequestDigest(method);
        StringBuffer buf = new StringBuffer();
        buf.append("Digest").append(" ");
        this.appendParameter(buf, "username", this.username);
        buf.append(',').append(" ");
        this.appendParameter(buf, "realm", this.realm);
        buf.append(',').append(" ");
        this.appendParameter(buf, "nonce", this.nonce);
        buf.append(',').append(" ");
        this.appendParameter(buf, "uri", this.requestUri);
        buf.append(',').append(" ");
        this.appendParameter(buf, "response", this.digest);
        if ("auth".equals(this.qop)) {
            buf.append(',').append(" ");
            this.appendParameter(buf, "nc", this.nonceCountHex);
            buf.append(',').append(" ");
            this.appendParameter(buf, "cnonce", this.cnonce);
            buf.append(',').append(" ");
            this.appendParameter(buf, "qop", this.qop);
        }
        if (this.opaque != null) {
            buf.append(',').append(" ");
            this.appendParameter(buf, "opaque", this.opaque);
        }
        if (this.statusCode == 401) {
            authorizationName = new SipHeaderFieldName("Authorization");
        } else if (this.statusCode == 407) {
            authorizationName = new SipHeaderFieldName("Proxy-Authorization");
        } else {
            return;
        }
        sipHeaders.add(authorizationName, new SipHeaderFieldValue(buf.toString()));
        if (this.contact != null && (expiresString = this.contact.getParam(expiresName = new SipHeaderParamName("expires"))) != null && Integer.parseInt(expiresString) == 0) {
            SipHeaderFieldValue requestContact = sipHeaders.get(new SipHeaderFieldName("Contact"));
            requestContact.addParam(expiresName, expiresString);
        }
    }

    private void appendParameter(StringBuffer buf, String name, String value) {
        buf.append(name);
        buf.append('=');
        buf.append('\"');
        buf.append(value);
        buf.append('\"');
    }
}

