/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent;

import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.MessageInterceptor;
import net.sourceforge.peers.sip.core.useragent.MidDialogRequestManager;
import net.sourceforge.peers.sip.core.useragent.RequestManager;
import net.sourceforge.peers.sip.core.useragent.UAS;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.core.useragent.handlers.ByeHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.CancelHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.InviteHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.OptionsHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.RegisterHandler;
import net.sourceforge.peers.sip.syntaxencoding.NameAddress;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class InitialRequestManager
extends RequestManager
implements ServerTransactionUser {
    public InitialRequestManager(UserAgent userAgent, InviteHandler inviteHandler, CancelHandler cancelHandler, ByeHandler byeHandler, OptionsHandler optionsHandler, RegisterHandler registerHandler, DialogManager dialogManager, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(userAgent, inviteHandler, cancelHandler, byeHandler, optionsHandler, registerHandler, dialogManager, transactionManager, transportManager, logger);
        registerHandler.setInitialRequestManager(this);
    }

    public SipRequest getGenericRequest(String requestUri, String method, String profileUri, String callId, String fromTag) throws SipUriSyntaxException {
        SipRequest request = new SipRequest(method, new SipURI(requestUri));
        SipHeaders headers = request.getSipHeaders();
        Utils.addCommonHeaders(headers);
        NameAddress to = new NameAddress(requestUri);
        headers.add(new SipHeaderFieldName("To"), new SipHeaderFieldValue(to.toString()));
        NameAddress fromNA = new NameAddress(profileUri);
        SipHeaderFieldValue from = new SipHeaderFieldValue(fromNA.toString());
        String localFromTag = fromTag != null ? fromTag : Utils.generateTag();
        from.addParam(new SipHeaderParamName("tag"), localFromTag);
        headers.add(new SipHeaderFieldName("From"), from);
        SipHeaderFieldName callIdName = new SipHeaderFieldName("Call-ID");
        String localCallId = callId != null ? callId : Utils.generateCallID(this.userAgent.getConfig().getLocalInetAddress());
        headers.add(callIdName, new SipHeaderFieldValue(localCallId));
        headers.add(new SipHeaderFieldName("CSeq"), new SipHeaderFieldValue(this.userAgent.generateCSeq(method)));
        return request;
    }

    public SipRequest createInitialRequest(String requestUri, String method, String profileUri) throws SipUriSyntaxException {
        return this.createInitialRequest(requestUri, method, profileUri, null);
    }

    public SipRequest createInitialRequest(String requestUri, String method, String profileUri, String callId) throws SipUriSyntaxException {
        return this.createInitialRequest(requestUri, method, profileUri, callId, null, null);
    }

    public SipRequest createInitialRequest(String requestUri, String method, String profileUri, String callId, String fromTag, MessageInterceptor messageInterceptor) throws SipUriSyntaxException {
        SipRequest sipRequest = this.getGenericRequest(requestUri, method, profileUri, callId, fromTag);
        SipURI outboundProxy = this.userAgent.getOutboundProxy();
        if (outboundProxy != null) {
            NameAddress outboundProxyNameAddress = new NameAddress(outboundProxy.toString());
            sipRequest.getSipHeaders().add(new SipHeaderFieldName("Route"), new SipHeaderFieldValue(outboundProxyNameAddress.toString()), 0);
        }
        ClientTransaction clientTransaction = null;
        if ("INVITE".equals(method)) {
            clientTransaction = this.inviteHandler.preProcessInvite(sipRequest);
        } else if ("REGISTER".equals(method)) {
            clientTransaction = this.registerHandler.preProcessRegister(sipRequest);
        }
        this.createInitialRequestEnd(sipRequest, clientTransaction, profileUri, messageInterceptor, true);
        return sipRequest;
    }

    private void createInitialRequestEnd(SipRequest sipRequest, ClientTransaction clientTransaction, String profileUri, MessageInterceptor messageInterceptor, boolean addContact) {
        if (clientTransaction == null) {
            this.logger.error("method not supported");
            return;
        }
        if (addContact) {
            this.addContact(sipRequest, clientTransaction.getContact(), profileUri);
        }
        if (messageInterceptor != null) {
            messageInterceptor.postProcess(sipRequest);
        }
        clientTransaction.start();
    }

    public void createCancel(SipRequest inviteRequest, MidDialogRequestManager midDialogRequestManager, String profileUri) {
        SipRequest sipRequest;
        SipHeaders inviteHeaders = inviteRequest.getSipHeaders();
        SipHeaderFieldValue callId = inviteHeaders.get(new SipHeaderFieldName("Call-ID"));
        try {
            sipRequest = this.getGenericRequest(inviteRequest.getRequestUri().toString(), "CANCEL", profileUri, callId.getValue(), null);
        }
        catch (SipUriSyntaxException e) {
            this.logger.error("syntax error", e);
            return;
        }
        ClientTransaction clientTransaction = null;
        clientTransaction = this.cancelHandler.preProcessCancel(sipRequest, inviteRequest, midDialogRequestManager);
        if (clientTransaction != null) {
            this.createInitialRequestEnd(sipRequest, clientTransaction, profileUri, null, false);
        }
    }

    public void manageInitialRequest(SipRequest sipRequest) {
        String method;
        SipHeaderFieldValue contentType;
        SipHeaders headers = sipRequest.getSipHeaders();
        SipResponse sipResponse = null;
        if (!UAS.SUPPORTED_METHODS.contains(sipRequest.getMethod())) {
            sipResponse = InitialRequestManager.generateResponse(sipRequest, null, 405, "Method Not Allowed");
            SipHeaders sipHeaders = sipResponse.getSipHeaders();
            sipHeaders.add(new SipHeaderFieldName("Allow"), new SipHeaderFieldValue(Utils.generateAllowHeader()));
        }
        if ((contentType = headers.get(new SipHeaderFieldName("Content-Type"))) == null || !"application/sdp".equals(contentType.getValue())) {
            // empty if block
        }
        if (sipResponse != null) {
            ServerTransaction serverTransaction = this.transactionManager.createServerTransaction(sipResponse, this.userAgent.getSipPort(), "UDP", this, sipRequest);
            serverTransaction.start();
            serverTransaction.receivedRequest(sipRequest);
            serverTransaction.sendReponse(sipResponse);
        }
        if ("INVITE".equals(method = sipRequest.getMethod())) {
            this.inviteHandler.handleInitialInvite(sipRequest);
        } else if ("CANCEL".equals(method)) {
            this.cancelHandler.handleCancel(sipRequest);
        } else if ("OPTIONS".equals(method)) {
            this.optionsHandler.handleOptions(sipRequest);
        }
    }

    public void addContact(SipRequest sipRequest, String contactEnd, String profileUri) {
        SipHeaders sipHeaders = sipRequest.getSipHeaders();
        StringBuffer contactBuf = new StringBuffer();
        contactBuf.append("sip");
        contactBuf.append(':');
        String userPart = Utils.getUserPart(profileUri);
        contactBuf.append(userPart);
        contactBuf.append('@');
        contactBuf.append(contactEnd);
        NameAddress contactNA = new NameAddress(contactBuf.toString());
        SipHeaderFieldValue contact = new SipHeaderFieldValue(contactNA.toString());
        sipHeaders.add(new SipHeaderFieldName("Contact"), new SipHeaderFieldValue(contact.toString()));
    }

    public void transactionFailure() {
    }
}

