/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.syntaxencoding;

import java.util.ArrayList;
import net.sourceforge.peers.sip.syntaxencoding.SipHeader;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldMultiValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;

public class SipHeaders {
    private ArrayList<SipHeader> headers = new ArrayList();

    public void add(SipHeaderFieldName name, SipHeaderFieldValue value, int index) {
        SipHeader header = new SipHeader(name, value);
        if (this.headers.contains(header)) {
            SipHeaderFieldValue oldValue = (header = this.headers.get(this.headers.indexOf(header))).getValue();
            if (oldValue instanceof SipHeaderFieldMultiValue) {
                SipHeaderFieldMultiValue oldMultiVal = (SipHeaderFieldMultiValue)oldValue;
                oldMultiVal.getValues().add(value);
            } else {
                ArrayList<SipHeaderFieldValue> arr = new ArrayList<SipHeaderFieldValue>();
                arr.add(oldValue);
                arr.add(value);
                header.setValue(new SipHeaderFieldMultiValue(arr));
            }
        } else if (index == -1) {
            this.headers.add(header);
        } else {
            this.headers.add(index, header);
        }
    }

    public void add(SipHeaderFieldName name, SipHeaderFieldValue value) {
        this.add(name, value, -1);
    }

    public void remove(SipHeaderFieldName name) {
        this.headers.remove(name);
    }

    public boolean contains(SipHeaderFieldName name) {
        return this.headers.contains(new SipHeader(name, null));
    }

    public SipHeaderFieldValue get(SipHeaderFieldName name) {
        int index = this.headers.indexOf(new SipHeader(name, null));
        if (index < 0) {
            return null;
        }
        return this.headers.get(index).getValue();
    }

    public int getCount() {
        return this.headers.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (SipHeader header : this.headers) {
            buf.append(header.getName().toString());
            buf.append(": ");
            buf.append(header.getValue());
            buf.append("\r\n");
        }
        return buf.toString();
    }
}

