/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.syntaxencoding;

import java.util.Hashtable;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipURI {
    public static final int DEFAULT_PORT = -1;
    private String stringRepresentation;
    private String userinfo;
    private String host;
    private int port = -1;
    private Hashtable<String, String> uriParameters;

    public SipURI(String sipUri) throws SipUriSyntaxException {
        int endHostport;
        this.stringRepresentation = sipUri;
        StringBuffer buf = new StringBuffer(sipUri);
        String scheme = "sip:";
        if (!sipUri.startsWith(scheme)) {
            throw new SipUriSyntaxException("SIP URI must start with " + scheme);
        }
        buf.delete(0, scheme.length());
        int atPos = buf.indexOf("@");
        if (atPos == 0) {
            throw new SipUriSyntaxException("userinfo cannot start with a '@'");
        }
        if (atPos > 0) {
            this.userinfo = buf.substring(0, atPos);
            buf.delete(0, atPos + 1);
        }
        if ((endHostport = buf.indexOf(";")) == 0) {
            throw new SipUriSyntaxException("hostport not present or it cannot start with ';'");
        }
        if (endHostport < 0) {
            endHostport = buf.length();
        }
        String hostport = buf.substring(0, endHostport);
        buf.delete(0, endHostport);
        int colonPos = hostport.indexOf(58);
        if (colonPos > -1) {
            if (colonPos == hostport.length() - 1) {
                throw new SipUriSyntaxException("hostport cannot terminate with a ':'");
            }
            this.port = Integer.parseInt(hostport.substring(colonPos + 1));
        } else {
            colonPos = hostport.length();
        }
        this.host = hostport.substring(0, colonPos);
        if (buf.length() == 1) {
            buf.deleteCharAt(0);
        }
        if (buf.length() <= 0) {
            return;
        }
        this.uriParameters = new Hashtable();
        while (buf.length() > 0) {
            int nextEquals;
            buf.deleteCharAt(0);
            int nextSemicolon = buf.indexOf(";");
            if (nextSemicolon < 0) {
                nextSemicolon = buf.length();
            }
            if ((nextEquals = buf.indexOf("=")) < 0) {
                nextEquals = nextSemicolon;
            }
            if (nextEquals > nextSemicolon) {
                nextEquals = nextSemicolon;
            }
            int afterEquals = nextEquals + 1 > nextSemicolon ? nextSemicolon : nextEquals + 1;
            this.uriParameters.put(buf.substring(0, nextEquals), buf.substring(afterEquals, nextSemicolon));
            buf.delete(0, nextSemicolon);
        }
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Hashtable<String, String> getUriParameters() {
        return this.uriParameters;
    }

    public String getUserinfo() {
        return this.userinfo;
    }
}

