/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transaction;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ClientTransactionUser;
import net.sourceforge.peers.sip.transaction.InviteClientTransactionState;
import net.sourceforge.peers.sip.transaction.InviteClientTransactionStateCalling;
import net.sourceforge.peers.sip.transaction.InviteClientTransactionStateCompleted;
import net.sourceforge.peers.sip.transaction.InviteClientTransactionStateInit;
import net.sourceforge.peers.sip.transaction.InviteClientTransactionStateProceeding;
import net.sourceforge.peers.sip.transaction.InviteClientTransactionStateTerminated;
import net.sourceforge.peers.sip.transaction.InviteTransaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.MessageSender;
import net.sourceforge.peers.sip.transport.SipClientTransportUser;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class InviteClientTransaction
extends InviteTransaction
implements ClientTransaction,
SipClientTransportUser {
    public final InviteClientTransactionState INIT;
    public final InviteClientTransactionState CALLING;
    public final InviteClientTransactionState PROCEEDING;
    public final InviteClientTransactionState COMPLETED;
    public final InviteClientTransactionState TERMINATED;
    protected ClientTransactionUser transactionUser;
    protected String transport;
    private InviteClientTransactionState state;
    private MessageSender messageSender;
    private int nbRetrans;
    private SipRequest ack;
    private int remotePort;
    private InetAddress remoteInetAddress;

    InviteClientTransaction(String branchId, InetAddress inetAddress, int port, String transport, SipRequest sipRequest, ClientTransactionUser transactionUser, Timer timer, TransportManager transportManager, TransactionManager transactionManager, Logger logger) {
        super(branchId, timer, transportManager, transactionManager, logger);
        this.transport = transport;
        SipHeaderFieldValue via = new SipHeaderFieldValue("");
        via.addParam(new SipHeaderParamName("branch"), branchId);
        sipRequest.getSipHeaders().add(new SipHeaderFieldName("Via"), via, 0);
        this.nbRetrans = 0;
        this.state = this.INIT = new InviteClientTransactionStateInit(this.getId(), this, logger);
        this.CALLING = new InviteClientTransactionStateCalling(this.getId(), this, logger);
        this.PROCEEDING = new InviteClientTransactionStateProceeding(this.getId(), this, logger);
        this.COMPLETED = new InviteClientTransactionStateCompleted(this.getId(), this, logger);
        this.TERMINATED = new InviteClientTransactionStateTerminated(this.getId(), this, logger);
        this.request = sipRequest;
        this.transactionUser = transactionUser;
        this.remotePort = port;
        this.remoteInetAddress = inetAddress;
        try {
            this.messageSender = transportManager.createClientTransport(this.request, this.remoteInetAddress, this.remotePort, transport);
        }
        catch (IOException e) {
            logger.error("input/output error", e);
            this.transportError();
        }
    }

    public void setState(InviteClientTransactionState state) {
        this.state.log(state);
        this.state = state;
        if (this.TERMINATED.equals(state)) {
            this.transactionManager = null;
        }
    }

    public void start() {
        this.state.start();
        try {
            this.messageSender.sendMessage(this.request);
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            this.transportError();
        }
        this.logger.debug("InviteClientTransaction.start");
        if ("UDP".equals(this.transport)) {
            this.timer.schedule((TimerTask)new TimerA(), 500L);
        }
        this.timer.schedule((TimerTask)new TimerB(), 32000L);
    }

    public synchronized void receivedResponse(SipResponse sipResponse) {
        this.responses.add(sipResponse);
        int statusCode = sipResponse.getStatusCode();
        if (statusCode < 100) {
            this.logger.error("invalid response code");
        } else if (statusCode < 200) {
            this.state.received1xx();
        } else if (statusCode < 300) {
            this.state.received2xx();
        } else if (statusCode <= 699) {
            this.state.received300To699();
        } else {
            this.logger.error("invalid response code");
        }
    }

    public void transportError() {
        this.state.transportError();
    }

    void createAndSendAck() {
        this.ack = new SipRequest("ACK", this.request.getRequestUri());
        SipHeaderFieldValue topVia = Utils.getTopVia(this.request);
        SipHeaders ackSipHeaders = this.ack.getSipHeaders();
        ackSipHeaders.add(new SipHeaderFieldName("Via"), topVia);
        Utils.copyHeader(this.request, this.ack, "Call-ID");
        Utils.copyHeader(this.request, this.ack, "From");
        Utils.copyHeader(this.getLastResponse(), this.ack, "To");
        SipHeaders requestSipHeaders = this.request.getSipHeaders();
        SipHeaderFieldName cseqName = new SipHeaderFieldName("CSeq");
        SipHeaderFieldValue cseq = requestSipHeaders.get(cseqName);
        cseq.setValue(cseq.toString().replace("INVITE", "ACK"));
        ackSipHeaders.add(cseqName, cseq);
        Utils.copyHeader(this.request, this.ack, "Route");
        this.sendAck();
    }

    void sendAck() {
        try {
            this.messageSender.sendMessage(this.ack);
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            this.transportError();
        }
    }

    void sendRetrans() {
        ++this.nbRetrans;
        try {
            this.messageSender.sendMessage(this.request);
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            this.transportError();
        }
        this.timer.schedule((TimerTask)new TimerA(), (long)Math.pow(2.0, this.nbRetrans) * 500L);
    }

    public void requestTransportError(SipRequest sipRequest, Exception e) {
    }

    public void responseTransportError(Exception e) {
    }

    public String getContact() {
        if (this.messageSender != null) {
            return this.messageSender.getContact();
        }
        return null;
    }

    class TimerD
    extends TimerTask {
        TimerD() {
        }

        public void run() {
            InviteClientTransaction.this.state.timerDFires();
        }
    }

    class TimerB
    extends TimerTask {
        TimerB() {
        }

        public void run() {
            InviteClientTransaction.this.state.timerBFires();
        }
    }

    class TimerA
    extends TimerTask {
        TimerA() {
        }

        public void run() {
            InviteClientTransaction.this.state.timerAFires();
        }
    }
}

