/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transaction;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ClientTransactionUser;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransactionState;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransactionStateCompleted;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransactionStateInit;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransactionStateProceeding;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransactionStateTerminated;
import net.sourceforge.peers.sip.transaction.NonInviteClientTransactionStateTrying;
import net.sourceforge.peers.sip.transaction.NonInviteTransaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transport.MessageSender;
import net.sourceforge.peers.sip.transport.SipClientTransportUser;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class NonInviteClientTransaction
extends NonInviteTransaction
implements ClientTransaction,
SipClientTransportUser {
    public final NonInviteClientTransactionState INIT;
    public final NonInviteClientTransactionState TRYING;
    public final NonInviteClientTransactionState PROCEEDING;
    public final NonInviteClientTransactionState COMPLETED;
    public final NonInviteClientTransactionState TERMINATED;
    protected ClientTransactionUser transactionUser;
    protected String transport;
    protected int nbRetrans;
    private NonInviteClientTransactionState state;
    private MessageSender messageSender;
    private int remotePort;
    private InetAddress remoteInetAddress;

    NonInviteClientTransaction(String branchId, InetAddress inetAddress, int port, String transport, SipRequest sipRequest, ClientTransactionUser transactionUser, Timer timer, TransportManager transportManager, TransactionManager transactionManager, Logger logger) {
        super(branchId, sipRequest.getMethod(), timer, transportManager, transactionManager, logger);
        this.transport = transport;
        SipHeaderFieldValue via = new SipHeaderFieldValue("");
        via.addParam(new SipHeaderParamName("branch"), branchId);
        sipRequest.getSipHeaders().add(new SipHeaderFieldName("Via"), via, 0);
        this.nbRetrans = 0;
        this.state = this.INIT = new NonInviteClientTransactionStateInit(this.getId(), this, logger);
        this.TRYING = new NonInviteClientTransactionStateTrying(this.getId(), this, logger);
        this.PROCEEDING = new NonInviteClientTransactionStateProceeding(this.getId(), this, logger);
        this.COMPLETED = new NonInviteClientTransactionStateCompleted(this.getId(), this, logger);
        this.TERMINATED = new NonInviteClientTransactionStateTerminated(this.getId(), this, logger);
        this.request = sipRequest;
        this.transactionUser = transactionUser;
        this.remotePort = port;
        this.remoteInetAddress = inetAddress;
        try {
            this.messageSender = transportManager.createClientTransport(this.request, this.remoteInetAddress, this.remotePort, transport);
        }
        catch (IOException e) {
            logger.error("input/output error", e);
            this.transportError();
        }
    }

    public void setState(NonInviteClientTransactionState state) {
        this.state.log(state);
        this.state = state;
    }

    public void start() {
        this.state.start();
        try {
            this.messageSender.sendMessage(this.request);
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            this.transportError();
        }
        if ("UDP".equals(this.transport)) {
            this.timer.schedule((TimerTask)new TimerE(), 500L);
        }
        this.timer.schedule((TimerTask)new TimerF(), 32000L);
    }

    void sendRetrans(long delay) {
        try {
            this.messageSender.sendMessage(this.request);
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
            this.transportError();
        }
        this.timer.schedule((TimerTask)new TimerE(), delay);
    }

    public void transportError() {
        this.state.transportError();
    }

    public synchronized void receivedResponse(SipResponse sipResponse) {
        this.responses.add(sipResponse);
        int statusCode = sipResponse.getStatusCode();
        if (statusCode < 100) {
            this.logger.error("invalid response code");
        } else if (statusCode < 200) {
            this.state.received1xx();
        } else if (statusCode <= 699) {
            this.state.received200To699();
        } else {
            this.logger.error("invalid response code");
        }
    }

    public void requestTransportError(SipRequest sipRequest, Exception e) {
    }

    public void responseTransportError(Exception e) {
    }

    public String getContact() {
        if (this.messageSender != null) {
            return this.messageSender.getContact();
        }
        return null;
    }

    class TimerK
    extends TimerTask {
        TimerK() {
        }

        public void run() {
            NonInviteClientTransaction.this.state.timerKFires();
        }
    }

    class TimerF
    extends TimerTask {
        TimerF() {
        }

        public void run() {
            NonInviteClientTransaction.this.state.timerFFires();
        }
    }

    class TimerE
    extends TimerTask {
        TimerE() {
        }

        public void run() {
            NonInviteClientTransaction.this.state.timerEFires();
        }
    }
}

