/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transactionuser;

import java.util.Collection;
import java.util.Hashtable;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogManager {
    private Hashtable<String, Dialog> dialogs;
    private Logger logger;

    public DialogManager(Logger logger) {
        this.logger = logger;
        this.dialogs = new Hashtable();
    }

    public synchronized Dialog createDialog(SipResponse sipResponse) {
        SipHeaders sipHeaders = sipResponse.getSipHeaders();
        String callID = sipHeaders.get(new SipHeaderFieldName("Call-ID")).toString();
        SipHeaderFieldValue from = sipHeaders.get(new SipHeaderFieldName("From"));
        SipHeaderFieldValue to = sipHeaders.get(new SipHeaderFieldName("To"));
        String fromTag = from.getParam(new SipHeaderParamName("tag"));
        String toTag = to.getParam(new SipHeaderParamName("tag"));
        Dialog dialog = sipHeaders.get(new SipHeaderFieldName("Via")) == null ? new Dialog(callID, toTag, fromTag, this.logger) : new Dialog(callID, fromTag, toTag, this.logger);
        this.dialogs.put(dialog.getId(), dialog);
        return dialog;
    }

    public void removeDialog(String dialogId) {
        this.dialogs.remove(dialogId);
    }

    public synchronized Dialog getDialog(SipMessage sipMessage) {
        String toTag;
        SipHeaders sipHeaders = sipMessage.getSipHeaders();
        String callID = sipHeaders.get(new SipHeaderFieldName("Call-ID")).toString();
        SipHeaderFieldValue from = sipHeaders.get(new SipHeaderFieldName("From"));
        SipHeaderFieldValue to = sipHeaders.get(new SipHeaderFieldName("To"));
        SipHeaderParamName tagName = new SipHeaderParamName("tag");
        String fromTag = from.getParam(tagName);
        Dialog dialog = this.dialogs.get(this.getDialogId(callID, fromTag, toTag = to.getParam(tagName)));
        if (dialog != null) {
            return dialog;
        }
        return this.dialogs.get(this.getDialogId(callID, toTag, fromTag));
    }

    public synchronized Dialog getDialog(String callId) {
        for (Dialog dialog : this.dialogs.values()) {
            if (!dialog.getCallId().equals(callId)) continue;
            return dialog;
        }
        return null;
    }

    private String getDialogId(String callID, String localTag, String remoteTag) {
        StringBuffer buf = new StringBuffer();
        buf.append(callID);
        buf.append('|');
        buf.append(localTag);
        buf.append('|');
        buf.append(remoteTag);
        return buf.toString();
    }

    public Collection<Dialog> getDialogCollection() {
        return this.dialogs.values();
    }
}

