/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.transport;

import java.net.InetAddress;

public class SipTransportConnection {
    public static final int EMPTY_PORT = -1;
    private InetAddress localInetAddress;
    private int localPort = -1;
    private InetAddress remoteInetAddress;
    private int remotePort = -1;
    private String transport;

    public SipTransportConnection(InetAddress localInetAddress, int localPort, InetAddress remoteInetAddress, int remotePort, String transport) {
        this.localInetAddress = localInetAddress;
        this.localPort = localPort;
        this.remoteInetAddress = remoteInetAddress;
        this.remotePort = remotePort;
        this.transport = transport;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != SipTransportConnection.class) {
            return false;
        }
        SipTransportConnection other = (SipTransportConnection)obj;
        if (!this.transport.equalsIgnoreCase(other.transport)) {
            return false;
        }
        if ("UDP".equalsIgnoreCase(this.transport)) {
            return this.localInetAddress.equals(other.localInetAddress) && this.localPort == other.localPort;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendInetAddress(buf, this.localInetAddress);
        buf.append(':');
        this.appendPort(buf, this.localPort);
        buf.append('/');
        if (!"UDP".equalsIgnoreCase(this.transport)) {
            this.appendInetAddress(buf, this.remoteInetAddress);
            buf.append(':');
            this.appendPort(buf, this.remotePort);
            buf.append('/');
        }
        buf.append(this.transport.toUpperCase());
        return buf.toString();
    }

    private void appendInetAddress(StringBuffer buf, InetAddress inetAddress) {
        if (inetAddress != null) {
            buf.append(inetAddress.getHostAddress());
        } else {
            buf.append("-");
        }
    }

    private void appendPort(StringBuffer buf, int port) {
        if (port != -1) {
            buf.append(port);
        } else {
            buf.append("-");
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public InetAddress getLocalInetAddress() {
        return this.localInetAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public InetAddress getRemoteInetAddress() {
        return this.remoteInetAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getTransport() {
        return this.transport;
    }
}

