/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.dbf;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConnectionDBF {
    private static final String accessDBFURLPrefix = "jdbc:odbc:Driver={Microsoft dBase Driver (*.dbf)};DBQ=";
    static Logger logger = Logger.getLogger(ConnectionDBF.class);

    public static Connection getDBFConnection(String filename) throws SQLException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("JdbcOdbc Bridge Driver not found!");
        }
        filename = filename.replace('\\', '/').trim();
        String databaseURL = accessDBFURLPrefix + filename;
        Properties prop = new Properties();
        prop.put("charset", "CP866");
        return DriverManager.getConnection(databaseURL, prop);
    }

    public static void sysoutRS(ResultSet rsRab, String st) {
        System.out.print(String.valueOf(st) + " ==> ");
        try {
            ResultSetMetaData md = rsRab.getMetaData();
            int i = 0;
            while (i < md.getColumnCount()) {
                System.out.print(String.valueOf(md.getColumnName(i + 1)) + " / ");
                ++i;
            }
            System.out.println();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void sysoutRSData(ResultSet rsRab, String st) {
        System.out.print(String.valueOf(st) + " ==> ");
        try {
            ResultSetMetaData md = rsRab.getMetaData();
            int i = 0;
            while (i < md.getColumnCount()) {
                System.out.print(String.valueOf(md.getColumnName(i + 1)) + " / ");
                ++i;
            }
            i = 0;
            while (i < md.getColumnCount()) {
                System.out.print(String.valueOf(rsRab.getString(md.getColumnName(i + 1))) + " / ");
                ++i;
            }
            System.out.println();
        }
        catch (SQLException e) {
            logger.debug((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static String toCharSet(String st) {
        String rez = st;
        try {
            rez = new String(rez.getBytes(), "CP866");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return rez;
    }
}

