/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.dbf;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CoreDBaseFile {
    Logger logger = Logger.getLogger(this.getClass());
    public static final Integer DOS_TYPE = 1;
    public static final Integer WIN_TYPE = 2;
    public InputStream is;
    private DBFField[] fieldsList;
    public HashMap<Integer, String> columnNames;

    public static String typeCodeToString(Integer type) {
        if (DOS_TYPE.equals(type)) {
            return "CP866";
        }
        if (WIN_TYPE.equals(type)) {
            return "CP1251";
        }
        return "CP866";
    }

    public DBFField[] getFields(DBFReader reader) throws DBFException {
        DBFField[] res = null;
        res = new DBFField[reader.getFieldCount()];
        int i = 0;
        while (i < res.length) {
            res[i] = reader.getField(i);
            ++i;
        }
        return res;
    }

    public HashMap<String, Object> parseLine(Object[] line) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (this.columnNames != null && line != null) {
            int i = 0;
            while (i < line.length) {
                if (this.columnNames.containsKey(i)) {
                    Object obj = line[i];
                    if (obj instanceof String) {
                        obj = obj.toString().trim();
                    }
                    res.put(this.columnNames.get(i), obj);
                }
                ++i;
            }
        }
        return res;
    }

    public Integer indexOfName(String name) {
        for (Integer key : this.columnNames.keySet()) {
            if (!this.columnNames.get(key).equalsIgnoreCase(name)) continue;
            return key;
        }
        return null;
    }

    public HashMap<Integer, String> parseColumnNameMap(DBFReader reader) {
        HashMap<Integer, String> res = null;
        if (reader != null) {
            try {
                res = new HashMap<Integer, String>(reader.getFieldCount());
                int i = 0;
                while (i < reader.getFieldCount()) {
                    res.put(i, reader.getField(i).getName().trim().toUpperCase());
                    ++i;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    public DBFField[] getFieldsList() {
        return this.fieldsList;
    }

    public void setFieldsList(DBFField[] fieldsList) {
        this.fieldsList = fieldsList;
    }

    public static Object[] updateNull(Object[] line, DBFField[] fieldso) {
        int i = 0;
        while (i < fieldso.length) {
            if (line[i] == null) {
                DBFField field = fieldso[i];
                switch (field.getDataType()) {
                    case 67: {
                        line[i] = "";
                        break;
                    }
                    case 68: {
                        line[i] = new Date();
                        break;
                    }
                    case 76: {
                        line[i] = true;
                        break;
                    }
                    case 70: {
                        line[i] = 0.0;
                        break;
                    }
                    case 78: {
                        line[i] = 0.0;
                        break;
                    }
                }
            }
            ++i;
        }
        return line;
    }
}

