/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.dbf;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import ru.blok.dbf.CoreDBaseFile;

public class ReaderDBaseFile
extends CoreDBaseFile {
    private DBFReader reader;
    private HashMap<String, Object> filters = new HashMap();
    private int currentRec = 0;
    private String rezMessage = "";

    public ReaderDBaseFile(String fileName) {
        this(fileName, ReaderDBaseFile.typeCodeToString(1));
    }

    public ReaderDBaseFile(String fileName, String typeCode) {
        try {
            this.is = new FileInputStream(fileName);
            DBFReader reader = new DBFReader(this.is);
            reader.setCharactersetName(typeCode);
            this.setReader(reader);
            this.columnNames = this.parseColumnNameMap(reader);
            if (this.columnNames.containsValue("")) {
                this.rezMessage = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430 \u0411\u0414.";
            }
            this.setFieldsList(this.getFields(reader));
        }
        catch (FileNotFoundException e) {
            this.rezMessage = e.getLocalizedMessage();
        }
        catch (DBFException e3) {
            this.rezMessage = String.valueOf(e3.getMessage()) + " \u0424\u0430\u0439\u043b - " + fileName;
        }
        catch (Exception exception) {
            this.rezMessage = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430  - " + fileName;
        }
    }

    public void destroy() {
        try {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            this.setReader(null);
            this.setFieldsList(null);
            this.setFilters(null);
            this.columnNames = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object[] getNextRecord() {
        Object[] line = null;
        boolean isRead = true;
        while (isRead) {
            block11: {
                if (this.currentRec < this.reader.getRecordCount()) break block11;
                return null;
            }
            try {
                line = this.reader.nextRecord();
                ++this.currentRec;
                if (line == null || this.filters == null || this.filters.size() == 0) break;
                HashMap<String, Object> columnVaues = this.parseLine(line);
                isRead = false;
                for (String key : this.filters.keySet()) {
                    Object valFilter = this.filters.get(key);
                    Object obj = columnVaues.get(key);
                    if (obj == null) {
                        isRead = true;
                        break;
                    }
                    if (obj instanceof Date && !this.equalsAsDate(valFilter, (Date)obj)) {
                        isRead = true;
                    }
                    if (obj instanceof Double && !this.equalsAsDouble(valFilter, (Double)obj)) {
                        isRead = true;
                    }
                    if (obj instanceof Boolean && !this.equalsAsBoolean(valFilter, (Boolean)obj)) {
                        isRead = true;
                    }
                    if (obj instanceof Float && !this.equalsAsFloat(valFilter, (Float)obj)) {
                        isRead = true;
                    }
                    if (obj instanceof String && !this.equalsAsString(valFilter, (String)obj)) {
                        isRead = true;
                    }
                    if (isRead) break;
                }
                if (isRead) continue;
                break;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return line;
    }

    public boolean equalsAsString(Object valFilter, String obj) {
        if (valFilter instanceof String) {
            return obj.equalsIgnoreCase((String)valFilter);
        }
        return false;
    }

    public boolean equalsAsFloat(Object valFilter, Float obj) {
        if (valFilter instanceof Float) {
            return obj.equals((Float)valFilter);
        }
        if (valFilter instanceof Integer) {
            return obj.equals(Float.valueOf(((Integer)valFilter).floatValue()));
        }
        return false;
    }

    public boolean equalsAsBoolean(Object valFilter, Boolean obj) {
        if (valFilter instanceof Boolean) {
            return obj.equals((Boolean)valFilter);
        }
        if (valFilter instanceof Integer) {
            return obj.equals((Integer)valFilter == 1);
        }
        if (valFilter instanceof String) {
            return obj.equals(((String)valFilter).equalsIgnoreCase("1") || ((String)valFilter).equalsIgnoreCase("\u0434\u0430") || ((String)valFilter).equalsIgnoreCase("true"));
        }
        return false;
    }

    public boolean equalsAsDouble(Object valFilter, Double obj) {
        if (valFilter instanceof Double) {
            return obj.equals((Double)valFilter);
        }
        if (valFilter instanceof Integer) {
            return obj.equals(((Integer)valFilter).doubleValue());
        }
        return false;
    }

    public boolean equalsAsDate(Object valFilter, Date obj) {
        if (valFilter instanceof Date) {
            return obj.equals((Date)valFilter);
        }
        if (valFilter instanceof String) {
            try {
                return obj.equals(new SimpleDateFormat("dd.MM.yyyy").parse((String)valFilter));
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return false;
    }

    public DBFReader getReader() {
        return this.reader;
    }

    public void setReader(DBFReader reader) {
        this.reader = reader;
    }

    public HashMap<Integer, String> getColumnNames() {
        return this.columnNames;
    }

    public HashMap<String, Object> getFilters() {
        return this.filters;
    }

    public void setFilters(HashMap<String, Object> filters) {
        this.filters = filters;
    }

    public void addFilters(String fieldName, Object fieldVal) {
        this.filters.put(fieldName.toUpperCase(), fieldVal);
    }

    public String getRezMessage() {
        return this.rezMessage;
    }

    public void setRezMessage(String rezMessage) {
        this.rezMessage = rezMessage;
    }
}

