/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.dbf;

import com.linuxense.javadbf.DBFException;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import ru.blok.dbf.ConnectionDBF;
import ru.blok.dbf.CoreDBaseFile;

public class WriterDBaseFile
extends CoreDBaseFile {
    String tempFileName;
    String realFileName;
    static DBFWriter writer;
    static DBFReader reader;
    Connection connection = null;

    public WriterDBaseFile(String path, String fileName) {
        this(path, fileName, 1);
    }

    public WriterDBaseFile(String path, String fileName, Integer typeCode) {
        if (fileName.indexOf(".") < 0) {
            fileName = String.valueOf(fileName) + ".dbf";
        } else if (fileName.indexOf(".dbf") < 0) {
            fileName = String.valueOf(fileName.substring(0, fileName.indexOf("."))) + ".dbf";
        }
        String typeCodeName = WriterDBaseFile.typeCodeToString(typeCode);
        try {
            this.connection = ConnectionDBF.getDBFConnection(path);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            this.realFileName = String.valueOf(path) + File.separator + fileName;
            this.is = new FileInputStream(this.realFileName);
            reader = new DBFReader(this.is);
            this.columnNames = this.parseColumnNameMap(reader);
            this.setFieldsList(this.getFields(reader));
            this.is.close();
            this.is = null;
            this.tempFileName = String.valueOf(path) + File.separator + "_" + fileName;
            writer = new DBFWriter();
            writer.setCharactersetName(typeCodeName);
            writer.setFields(this.getFieldsList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String addRecord(Object[] values) {
        try {
            writer.addRecord(values);
        }
        catch (DBFException e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    public void saveData() {
        File file;
        Locale default1 = Locale.getDefault();
        int rez = -1;
        try {
            Locale.setDefault(Locale.US);
            FileOutputStream os = null;
            File outFile = new File(this.tempFileName);
            os = new FileOutputStream(outFile);
            writer.write((OutputStream)os);
            ((OutputStream)os).close();
            os = null;
            String sqlText = "insert into " + this.realFileName + " select * from " + this.tempFileName;
            PreparedStatement prepareStatement = this.connection.prepareStatement(sqlText);
            rez = prepareStatement.executeUpdate();
            Locale.setDefault(default1);
            this.close();
        }
        catch (Exception e) {
            Locale.setDefault(default1);
            e.printStackTrace();
        }
        if (rez > -1 && (file = new File(this.tempFileName)).exists()) {
            file.delete();
        }
    }

    public int deleteRecords(String tableName, String[] fieldNames, String[] fieldVal) {
        int rez = 0;
        String sqlText = "delete from " + tableName + " where (1=1) ";
        String val = " ";
        if (fieldNames != null) {
            int i = 0;
            while (i < fieldNames.length) {
                val = String.valueOf(val) + " and (" + fieldNames[i] + "=" + fieldVal[i] + ")";
                ++i;
            }
        }
        try {
            PreparedStatement prepareStatement = this.connection.prepareStatement(String.valueOf(sqlText) + val);
            rez = prepareStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rez;
    }

    public int countRecords(String tableName, String[] fieldNames, String[] fieldVal) {
        int rez = 0;
        String sqlText = "select count(*) as koll from " + tableName + "  where (1=1) ";
        String val = " ";
        if (fieldNames != null) {
            int i = 0;
            while (i < fieldNames.length) {
                val = String.valueOf(val) + " and (" + fieldNames[i] + "=" + fieldVal[i] + ")";
                ++i;
            }
        }
        try {
            PreparedStatement prepareStatement = this.connection.prepareStatement(String.valueOf(sqlText) + val);
            ResultSet rezu = prepareStatement.executeQuery();
            rezu.next();
            rez = rezu.getInt(1);
            rezu.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rez;
    }

    public Double selectData(String tableName, String cond, String[] fieldNames, String[] fieldVal) {
        Double rez = 0.0;
        String sqlText = "select " + cond + " as ss from " + tableName + "  where (1=1) ";
        String val = " ";
        if (fieldNames != null) {
            int i = 0;
            while (i < fieldNames.length) {
                val = String.valueOf(val) + " and (" + fieldNames[i] + "=" + fieldVal[i] + ")";
                ++i;
            }
        }
        try {
            PreparedStatement prepareStatement = this.connection.prepareStatement(String.valueOf(sqlText) + val);
            ResultSet rezu = prepareStatement.executeQuery();
            rezu.next();
            rez = rezu.getDouble(1);
            rezu.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rez;
    }

    public int countRecordsByPeriod(String tableName, String fieldName, Date dat1, Date dat2) {
        int rez = 0;
        String sqlText = "select count(*) as koll from " + tableName + "  where (1=1) and";
        String val = " (" + fieldName + ">=?) and (" + fieldName + "<=?)";
        try {
            java.sql.Date datS = new java.sql.Date(dat1.getTime());
            java.sql.Date datF = new java.sql.Date(dat2.getTime());
            PreparedStatement prepareStatement = this.connection.prepareStatement(String.valueOf(sqlText) + val);
            prepareStatement.setDate(1, datS);
            prepareStatement.setDate(2, datF);
            ResultSet rezu = prepareStatement.executeQuery();
            rezu.next();
            rez = rezu.getInt(1);
            rezu.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rez;
    }

    public int deleteRecordsByPeriod(String tableName, String fieldName, Date dat1, Date dat2) {
        int rez = 0;
        String sqlText = "delete from " + tableName + "  where (1=1) and";
        String val = " (" + fieldName + ">=?) and (" + fieldName + "<=?)";
        try {
            java.sql.Date datS = new java.sql.Date(dat1.getTime());
            java.sql.Date datF = new java.sql.Date(dat2.getTime());
            PreparedStatement prepareStatement = this.connection.prepareStatement(String.valueOf(sqlText) + val);
            prepareStatement.setDate(1, datS);
            prepareStatement.setDate(2, datF);
            rez = prepareStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rez;
    }

    public void close() {
        try {
            writer = null;
            reader = null;
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

