/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.calltransport;

import java.awt.Container;
import java.awt.Dimension;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.calltransport.CallFrame;
import ru.blok.vms.calltransport.TransportCall;
import ru.blok.vms.calltransport.calls.CallInterface;
import ru.blok.vms.calltransport.calls.peers.PeersTelephone;
import ru.infor.beanviewer.core.BeanPanel;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.UserWSProxy;
import ru.infor.client.soap.proxy.vms.ConversationStatusWSProxy;
import ru.infor.client.soap.proxy.vms.ConversationWSProxy;
import ru.infor.client.soap.proxy.vms.NavigationDeviceWSProxy;
import ru.infor.client.soap.proxy.vms.Transport2DeviceLinkWSProxy;
import ru.infor.client.soap.proxy.vms.TransportWSProxy;
import ru.infor.ws.objects.core.DirectoriesSearchCriteria;
import ru.infor.ws.objects.core.UserSearchCriteria;
import ru.infor.ws.objects.core.entities.User;
import ru.infor.ws.objects.police.entities.PoliceWarrantUI;
import ru.infor.ws.objects.vms.ConversationSearchCriteria;
import ru.infor.ws.objects.vms.NavigationDeviceSearchCriteria;
import ru.infor.ws.objects.vms.Transport2DeviceLinkSearchCriteria;
import ru.infor.ws.objects.vms.TransportUI;
import ru.infor.ws.objects.vms.entities.Conversation;
import ru.infor.ws.objects.vms.entities.ConversationStatus;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.Transport;
import ru.infor.ws.objects.vms.entities.Transport2DeviceLink;
import ru.infor.ws.objects.vms.entities.ext.TransportExt;

public class SystemCall {
    static CallFrame callFrame = null;
    static String keyPage;
    public static int NONE;
    public static int CONNECTING;
    public static int BUSY;
    public static int CONNECTED;
    public static int INCOMING;
    public static int IncomingDirection;
    public static int OutcomingDirection;
    public static String call;
    public static String hangUpcall;
    public static String BUSYst;
    public static String CONNECTINGst;
    public static String CONNECTEDst;
    public static String INCOMINGst;
    public static String NONEst;
    public static String CallAction;
    public static String[] statuses;
    static CallInterface callInterface;
    public static HashMap<String, String> sp;
    static String serverName;
    static String user;
    static String passwd;
    static Transport2DeviceLinkWSProxy t2deviceProxy;
    static UserWSProxy userWSProxy;
    static TransportWSProxy transportWSProxy;
    static ConversationWSProxy conversationWSProxy;
    static ConversationSearchCriteria sc;
    static HashMap<String, ConversationStatus> conversationStatuses;
    static ConversationStatusWSProxy conversationStWSProxy;

    static {
        NONE = 0;
        CONNECTING = 1;
        BUSY = 2;
        CONNECTED = 3;
        INCOMING = 4;
        IncomingDirection = 0;
        OutcomingDirection = 1;
        call = "/data/icons/phone_call.png";
        hangUpcall = "/data/icons/phone_hangUp.png";
        BUSYst = "/data/icons/phone_busy.png";
        CONNECTINGst = "/data/icons/phone_connecting.png";
        CONNECTEDst = "/data/icons/phone_connected.png";
        INCOMINGst = "/data/icons/phone_income.png";
        NONEst = "/data/icons/phone_none.png";
        CallAction = "/data/icons/phone_call_action.png";
        statuses = new String[]{"\u041e\u0442\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d", "\u041f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0432\u044b\u0437\u043e\u0432...", "\u041b\u0438\u043d\u0438\u044f \u0437\u0430\u043d\u044f\u0442\u0430", "\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e", "\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0432\u044b\u0437\u043e\u0432"};
        sp = null;
        serverName = null;
        user = null;
        passwd = null;
        t2deviceProxy = (Transport2DeviceLinkWSProxy)CurrentProxyFactory.getProxy(Transport2DeviceLink.class);
        userWSProxy = (UserWSProxy)CurrentProxyFactory.getProxy(User.class);
        transportWSProxy = (TransportWSProxy)CurrentProxyFactory.getProxy(Transport.class);
        conversationWSProxy = (ConversationWSProxy)CurrentProxyFactory.getProxy(Conversation.class);
        sc = (ConversationSearchCriteria)conversationWSProxy._getSearchCriteriaTemplate();
        conversationStatuses = null;
        conversationStWSProxy = (ConversationStatusWSProxy)CurrentProxyFactory.getProxy(ConversationStatus.class);
    }

    public static void initCallFrame() {
        if (callFrame == null) {
            callFrame = new CallFrame();
            keyPage = String.valueOf(Transport.class.getName()) + callFrame.getClass().getName();
            sp = InitializedVariable.runtimeParameters(null);
            if (sp.get("sip.server.name") != null) {
                serverName = sp.get("sip.server.name");
            }
            if (sp.get("username.sip.server") != null) {
                user = sp.get("username.sip.server");
            }
            if (sp.get("passwd.sip.server") != null) {
                passwd = sp.get("passwd.sip.server");
            }
            if (serverName != null && user != null && passwd != null) {
                System.out.println(String.valueOf(serverName) + " " + user);
                callInterface = new PeersTelephone(serverName, user, passwd);
            }
        }
    }

    public static void showFrame() {
        SystemCall.initCallFrame();
        InitializedVariable.factory.newWindow(CallFrame.class, CallFrame.class, (Object)callFrame, new ViewerContext(), "", keyPage, true);
        Container p = (JPanel)((BeanPanel)InitializedVariable.factory.getCurrentPanel(keyPage)).getPanel();
        while (p != null && !(p instanceof JFrame)) {
            p = p.getParent();
        }
        if (p != null && p instanceof JFrame) {
            ((JFrame)p).setMinimumSize(new Dimension(700, 400));
        }
    }

    private static Object getObjectByTelNum(String phone) {
        NavigationDeviceWSProxy proxy = (NavigationDeviceWSProxy)CurrentProxyFactory.getProxy(NavigationDevice.class);
        NavigationDeviceSearchCriteria sc = (NavigationDeviceSearchCriteria)proxy._getSearchCriteriaTemplate();
        sc.setPhoneLike(phone);
        NavigationDeviceWSProxy.SearchResultListNavigationDevice r = proxy.getList(InitializedVariable.context, sc);
        if (!r.isEmpty() && r.getObjList().length > 0) {
            NavigationDevice d = (NavigationDevice)r.getObjList()[0];
            Transport2DeviceLinkSearchCriteria t2delSC = new Transport2DeviceLinkSearchCriteria();
            t2delSC.setDeviceIdList(new Long[]{d.getId()});
            t2delSC.setActiveOnDate(new Date());
            Transport2DeviceLinkWSProxy.SearchResultListTransport2DeviceLink sr = t2deviceProxy.getList(InitializedVariable.context, t2delSC);
            if (!sr.isEmpty()) {
                return ((Transport2DeviceLink)sr.getObjList()[0]).getTransport();
            }
            return null;
        }
        UserSearchCriteria scu = (UserSearchCriteria)userWSProxy._getSearchCriteriaTemplate();
        scu.setPhone(phone);
        UserWSProxy.SearchResultListUser ru = userWSProxy.getUsers(InitializedVariable.context, scu);
        if (!ru.isEmpty() && ru.getObjList().length > 0) {
            return ru.getObjList()[0];
        }
        return null;
    }

    public static NavigationDevice getCurrentDevice(Long transportId) {
        Transport2DeviceLinkSearchCriteria t2delSC = new Transport2DeviceLinkSearchCriteria();
        t2delSC.setTransportIdList(new Long[]{transportId});
        t2delSC.setActiveOnDate(new Date());
        Transport2DeviceLinkWSProxy.SearchResultListTransport2DeviceLink sr = t2deviceProxy.getList(InitializedVariable.context, t2delSC);
        if (!sr.isEmpty()) {
            return ((Transport2DeviceLink)sr.getObjList()[0]).getDevice();
        }
        return null;
    }

    private static String getTelNumByObject(Object object) {
        String num = "";
        if (object instanceof TransportExt) {
            NavigationDevice d = ((TransportExt)((Object)object)).getCurrentDevice();
            if (d != null && d.getPhone() != null) {
                num = d.getPhone();
                return num;
            }
        } else if (object instanceof TransportUI) {
            NavigationDevice d = SystemCall.getCurrentDevice(((TransportUI)object).getId());
            if (d != null && d.getPhone() != null) {
                num = d.getPhone();
                return num;
            }
        } else if (object instanceof PoliceWarrantUI) {
            NavigationDevice d = SystemCall.getCurrentDevice(((PoliceWarrantUI)object).getTransportId());
            if (d != null && d.getPhone() != null) {
                num = d.getPhone();
                return num;
            }
        } else if (object instanceof User) {
            num = ((User)object).getPhone();
        }
        return num;
    }

    public static TransportCall getTransportCall(Object o, String phone) {
        String ids;
        Long id = null;
        TransportCall call = null;
        if (o != null) {
            if (phone == null) {
                phone = SystemCall.getTelNumByObject(o);
            }
            if (o instanceof Transport) {
                id = ((Transport)o).getId();
            } else if (o instanceof TransportUI) {
                id = ((TransportUI)o).getId();
            } else if (o instanceof User) {
                id = ((User)o).getId();
            } else if (o instanceof PoliceWarrantUI) {
                id = ((PoliceWarrantUI)o).getId();
            }
            ids = String.valueOf(id.toString()) + phone.replaceAll("\\+", "");
            call = callFrame.getCallById(ids);
        } else {
            ids = phone.replaceAll("\\+", "");
        }
        if (call == null) {
            call = new TransportCall();
            if (o != null) {
                call.setObject(o);
            } else {
                call.setObject(phone);
            }
            call.setId(ids);
            call.setPhone(phone);
            callFrame.addTransportCall(call);
        }
        return call;
    }

    public static void call(Object o) {
        SystemCall.call(o, null);
    }

    public static void call(Object o, String phone) {
        SystemCall.initCallFrame();
        TransportCall call = SystemCall.getTransportCall(o, phone);
        SystemCall.showFrame();
        if (callInterface != null) {
            callInterface.call(call);
        }
    }

    public static void callTC(TransportCall call) {
        SystemCall.showFrame();
        if (callInterface != null) {
            if (call.getStatus() == INCOMING) {
                callInterface.answer(call);
            } else {
                callInterface.call(call);
            }
        }
    }

    public static void hangUpCall(Object object) {
        SystemCall.initCallFrame();
        TransportCall call = SystemCall.getTransportCall(object, null);
        if (callInterface != null) {
            callInterface.hangUp(call);
        }
        SystemCall.showFrame();
    }

    public static void hangUpTC(TransportCall call) {
        SystemCall.showFrame();
        if (callInterface != null) {
            callInterface.hangUp(call);
        }
    }

    public static void removeTtansport(TransportCall call) {
        SystemCall.initCallFrame();
        if (call.getStatus() != NONE && callInterface != null) {
            callInterface.hangUp(call);
        }
        callFrame.removeTransportCall(call.getId());
    }

    public static TransportCall incomingCall(String phone) {
        TransportCall call;
        Object o = SystemCall.getObjectByTelNum(phone);
        if (o != null) {
            call = SystemCall.getTransportCall(o, phone);
        } else {
            call = new TransportCall();
            call.setPhone(phone);
            call.setObject(phone);
            callFrame.addTransportCall(call);
        }
        call.setStatus(INCOMING);
        SystemCall.showFrame();
        return call;
    }

    public static TransportCall getTransportCallByIdCall(String id) {
        for (TransportCall call : callFrame.getListCall()) {
            if (!id.equals(call.getIdcall())) continue;
            return call;
        }
        return null;
    }

    public static HashMap<String, ConversationStatus> getConversationStatuses() {
        if (conversationStatuses == null) {
            Object[] oo;
            conversationStatuses = new HashMap();
            DirectoriesSearchCriteria sc = new DirectoriesSearchCriteria();
            sc.setCount(Integer.valueOf(Integer.MAX_VALUE));
            Object[] objectArray = oo = conversationStWSProxy.getList(InitializedVariable.context, sc).getObjList();
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                conversationStatuses.put(((ConversationStatus)o).getCode(), (ConversationStatus)o);
                ++n2;
            }
        }
        return conversationStatuses;
    }

    public static void saveCall(TransportCall call) {
        Conversation con = new Conversation();
        con.setDirection(call.getDirection());
        con.setExternalId(call.getIdcall());
        con.setOperator(InitializedVariable.user);
        if (call.getStatus() == NONE) {
            con.setStatus(SystemCall.getConversationStatuses().get("02"));
        } else if (call.getDateConnected() != null) {
            con.setStatus(SystemCall.getConversationStatuses().get("00"));
        } else if (((Object)((Object)call.getState())).equals(BUSY)) {
            con.setStatus(SystemCall.getConversationStatuses().get("02"));
        } else {
            con.setStatus(SystemCall.getConversationStatuses().get("01"));
        }
        if (call.getObject() != null && call.getObject() instanceof Transport) {
            con.setTransport((Transport)call.getObject());
        } else if (call.getObject() != null && call.getObject() instanceof TransportUI) {
            Transport t = transportWSProxy.getCurrentObject(InitializedVariable.context, ((TransportUI)call.getObject()).getId());
            con.setTransport(t);
        }
        con.setConversationDate(call.getBegindate());
        if (con.getConversationDate() == null) {
            con.setConversationDate(new Date());
        }
        con.setPhoneNumber(call.getPhone());
        con.setType(call.getType());
        conversationWSProxy.save(InitializedVariable.context, con);
    }

    public static void close() {
        callFrame = null;
        if (callInterface != null) {
            callInterface.close();
        }
    }
}

