/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.calltransport.calls.peers;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import net.sourceforge.peers.Config;
import net.sourceforge.peers.JavaConfig;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.javaxsound.JavaxSoundManager;
import net.sourceforge.peers.media.AbstractSoundManager;
import net.sourceforge.peers.media.MediaMode;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import ru.blok.vms.calltransport.SystemCall;
import ru.blok.vms.calltransport.TransportCall;
import ru.blok.vms.calltransport.calls.CallInterface;

public class PeersTelephone
implements CallInterface {
    static String peersHome = "temp/peers";
    UserAgent userAgent;
    String server;
    private HashMap<String, SipRequest> req = new HashMap();

    public PeersTelephone(String server, String user, String passwd) {
        Logger logger = new Logger(){

            public void debug(String message) {
            }

            public void info(String message) {
            }

            public void error(String message) {
                System.out.println(message);
            }

            public void error(String message, Exception exception) {
                exception.printStackTrace();
            }

            public void traceNetwork(String message, String direction) {
            }
        };
        this.server = server;
        String address = null;
        if (SystemCall.sp.get("ip.sip.client") != null) {
            address = SystemCall.sp.get("ip.sip.client");
        }
        JavaxSoundManager soundManager = new JavaxSoundManager(false, logger, peersHome);
        JavaConfig config = new JavaConfig();
        InetAddress localInetAddress = null;
        try {
            localInetAddress = address == null ? InetAddress.getLocalHost() : InetAddress.getByName(address);
        }
        catch (Exception e) {
            logger.error("unknown host: " + address, e);
        }
        config.setLocalInetAddress(localInetAddress);
        config.setUserPart(user);
        config.setDomain(server);
        config.setPassword(passwd);
        String sipport = null;
        if (sipport == null) {
            config.setSipPort(5060);
        } else {
            config.setSipPort(Integer.parseInt(sipport));
        }
        String mediaMode = null;
        if (mediaMode == null) {
            config.setMediaMode(MediaMode.captureAndPlayback);
        } else {
            config.setMediaMode(MediaMode.valueOf(mediaMode));
        }
        config.setMediaDebug(false);
        config.setMediaFile(null);
        Integer port = null;
        if (port == null) {
            config.setRtpPort(0);
        } else {
            config.setRtpPort(port.intValue());
        }
        try {
            this.userAgent = new UserAgent(new SipListener(){

                public void registering(SipRequest arg0) {
                    System.out.println("registering");
                }

                public void registerSuccessful(SipResponse arg0) {
                    System.out.println("registerSuccessful");
                }

                public void registerFailed(SipResponse arg0) {
                    System.out.println("registerFailed");
                }

                public void ringing(SipResponse arg0) {
                    System.out.println("ringing");
                    String callId = Utils.getMessageCallId((SipMessage)arg0);
                    TransportCall call = SystemCall.getTransportCallByIdCall(callId);
                    call.setStatus(SystemCall.CONNECTING);
                    call.setBegindate(new Date());
                }

                public void remoteHangup(SipRequest arg0) {
                    System.out.println("remoteHangup");
                    String callId = Utils.getMessageCallId((SipMessage)arg0);
                    TransportCall call = SystemCall.getTransportCallByIdCall(callId);
                    call.setStatus(SystemCall.NONE);
                    call.setDateOut(new Date());
                    SystemCall.saveCall(call);
                    PeersTelephone.this.req.remove(call.getIdcall());
                }

                public void incomingCall(SipRequest sipRequest, SipResponse arg1) {
                    System.out.println("incomingCall");
                    SipHeaders sipHeaders = sipRequest.getSipHeaders();
                    SipHeaderFieldName sipHeaderFieldName = new SipHeaderFieldName("From");
                    SipHeaderFieldValue from = sipHeaders.get(sipHeaderFieldName);
                    String fromValue = from.getValue();
                    String callId = Utils.getMessageCallId((SipMessage)sipRequest);
                    PeersTelephone.this.req.put(callId, sipRequest);
                    int k = fromValue.indexOf("sip:");
                    k = k >= 0 ? (k += 4) : 0;
                    String fromV = fromValue.substring(k, fromValue.indexOf("@"));
                    TransportCall call = SystemCall.incomingCall(fromV);
                    call.setIdcall(callId);
                    call.setDirection(SystemCall.IncomingDirection);
                    call.setBegindate(new Date());
                }

                public void error(SipResponse arg0) {
                    System.out.println("Error");
                    String callId = Utils.getMessageCallId((SipMessage)arg0);
                    TransportCall call = SystemCall.getTransportCallByIdCall(callId);
                    if (call.getStatus() == SystemCall.CONNECTING) {
                        call.setStatus(SystemCall.BUSY);
                        call.setDateOut(new Date());
                        SystemCall.saveCall(call);
                    }
                }

                public void calleePickup(SipResponse arg0) {
                    System.out.println("calleePickup");
                    String callId = Utils.getMessageCallId((SipMessage)arg0);
                    TransportCall call = SystemCall.getTransportCallByIdCall(callId);
                    call.setStatus(SystemCall.CONNECTED);
                    call.setDateConnected(new Date());
                }
            }, (Config)config, logger, (AbstractSoundManager)soundManager);
            this.userAgent.register();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void call(TransportCall call) {
        System.out.println("call");
        String callId = Utils.generateCallID((InetAddress)this.userAgent.getConfig().getLocalInetAddress());
        call.setIdcall(callId);
        call.setDirection(SystemCall.OutcomingDirection);
        call.setBegindate(null);
        call.setDateConnected(null);
        call.setDateOut(null);
        String uri = "sip:" + call.getPhone() + "@" + this.server;
        SipRequest sipRequest = null;
        try {
            sipRequest = this.userAgent.invite(uri, callId);
            this.req.put(callId, sipRequest);
        }
        catch (SipUriSyntaxException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void hangUp(TransportCall call) {
        System.out.println("hangUp");
        SipRequest sipRequest = this.req.get(call.getIdcall());
        try {
            if (call.getStatus() == SystemCall.INCOMING) {
                this.userAgent.rejectCall(sipRequest);
            } else {
                this.userAgent.terminate(sipRequest);
            }
        }
        catch (Exception exception) {}
        call.setStatus(SystemCall.NONE);
        call.setDateOut(new Date());
        SystemCall.saveCall(call);
        this.req.remove(call.getIdcall());
    }

    @Override
    public void answer(TransportCall call) {
        System.out.println("answer");
        SipRequest sipRequest = this.req.get(call.getIdcall());
        DialogManager dialogManager = this.userAgent.getDialogManager();
        Dialog dialog = dialogManager.getDialog(call.getIdcall());
        this.userAgent.acceptCall(sipRequest, dialog);
        call.setStatus(SystemCall.CONNECTED);
        call.setDateConnected(new Date());
    }

    @Override
    public void close() {
        try {
            if (this.userAgent != null) {
                this.userAgent.unregister();
            }
        }
        catch (SipUriSyntaxException e) {
            e.printStackTrace();
        }
    }
}

