/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.calltransport.calls.sip;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import ru.blok.vms.calltransport.SystemCall;
import ru.blok.vms.calltransport.TransportCall;
import ru.blok.vms.calltransport.calls.CallInterface;
import ru.infor.sip.OSGi;
import ru.infor.sip.VOIPLink;

public class SipTelephone
implements CallInterface {
    static Logger logger = Logger.getLogger(SipTelephone.class);
    VOIPLink voipLink;
    private List<TransportCall> listOut = new ArrayList<TransportCall>();

    public SipTelephone(final String server, final String user, final String passwd) {
        this.voipLink = new VOIPLink(){
            boolean ready = false;

            public void state(String id, String state) {
                if (!this.ready) {
                    if ("System".equals(id) && "READY".equals(state)) {
                        this.ready = true;
                        HashMap<String, String> ap = new HashMap<String, String>();
                        ap.put("Encodings.speex/16000", "700");
                        ap.put("OVERRIDE_ENCODINGS", "false");
                        ap.put("Encodings.GSM/8000", "450");
                        ap.put("Encodings.SILK/24000", "704");
                        ap.put("PROTOCOL_NAME", "SIP");
                        ap.put("POLLING_PERIOD", "30");
                        ap.put("DTMF_METHOD", "AUTO_DTMF");
                        ap.put("Encodings.SILK/8000", "0");
                        ap.put("SAVP_OPTION", "0");
                        ap.put("Encodings.SILK/16000", "703");
                        ap.put("Encodings.H263-1998/90000", "0");
                        ap.put("Encodings.PCMA/8000", "600");
                        String userid = String.valueOf(user) + "@" + server;
                        ap.put("USER_ID", userid);
                        ap.put("XCAP_ENABLE", "false");
                        ap.put("KEEP_ALIVE_INTERVAL", "25");
                        ap.put("ENCRYPTION_PROTOCOL_STATUS.SDES", "false");
                        ap.put("ENCRYPTION_PROTOCOL.ZRTP", "0");
                        ap.put("XIVO_ENABLE", "false");
                        ap.put("PROXY_AUTO_CONFIG", "true");
                        ap.put("Encodings.VP8/90000", "0");
                        ap.put("Encodings.speex/8000", "352");
                        ap.put("Encodings.SILK/12000", "0");
                        ap.put("IS_PRESENCE_ENABLED", "true");
                        ap.put("DEFAULT_SIPZRTP_ATTRIBUTE", "true");
                        ap.put("Encodings.PCMU/8000", "650");
                        ap.put("Encodings.iLBC/8000", "500");
                        ap.put("DEFAULT_ENCRYPTION", "true");
                        ap.put("SERVER_ADDRESS", server);
                        ap.put("Encodings.H264/90000", "1100");
                        ap.put("Encodings.G722/8000", "705");
                        ap.put("ENCRYPTION_PROTOCOL_STATUS.ZRTP", "true");
                        ap.put("KEEP_ALIVE_METHOD", "OPTIONS");
                        ap.put("Encodings.telephone-event/8000", "1");
                        ap.put("Encodings.speex/32000", "701");
                        ap.put("PASSWORD", passwd);
                        ap.put("DTMF_MINIMAL_TONE_DURATION", "70");
                        ap.put("FORCE_P2P_MODE", "false");
                        ap.put("Encodings.opus/48000", "750");
                        ap.put("ENCRYPTION_PROTOCOL.SDES", "1");
                        ap.put("SUBSCRIPTION_EXPIRATION", "3600");
                        ap.put("SDES_CIPHER_SUITES", "AES_CM_128_HMAC_SHA1_80,AES_CM_128_HMAC_SHA1_32");
                        OSGi.register(ap);
                    }
                } else {
                    logger.debug((Object)(String.valueOf(id) + ">>>>>>>>" + state));
                    System.out.println(String.valueOf(id) + ">>>>>>>>" + state);
                    TransportCall call = SystemCall.getTransportCallByIdCall(id);
                    if (call != null) {
                        if ("Connecting".equals(state)) {
                            call.setStatus(SystemCall.CONNECTING);
                            call.setBegindate(new Date());
                        } else if ("Connected".equals(state) || "In Progress".equals(state)) {
                            call.setStatus(SystemCall.CONNECTED);
                            call.setDateConnected(new Date());
                        } else if ("Disconnected".equals(state) || "Failed".equals(state) || "Ended".equals(state)) {
                            call.setStatus(SystemCall.NONE);
                            call.setDateOut(new Date());
                            SystemCall.saveCall(call);
                        } else if ("Busy".equals(state)) {
                            call.setStatus(SystemCall.BUSY);
                            call.setDateOut(new Date());
                            SystemCall.saveCall(call);
                        }
                    }
                }
            }

            public void outgoingCall(String id, String address) {
                TransportCall call = null;
                for (TransportCall c : SipTelephone.this.listOut) {
                    if (!address.contains(c.getPhone())) continue;
                    call = c;
                }
                if (call != null) {
                    call.setIdcall(id);
                    call.setDirection(SystemCall.OutcomingDirection);
                    SipTelephone.this.listOut.remove(call);
                }
            }

            public void incomingCall(String id, String address) {
                TransportCall call = SystemCall.incomingCall(address);
                call.setIdcall(id);
                call.setDirection(SystemCall.IncomingDirection);
                call.setBegindate(new Date());
            }
        };
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("try register1");
                    OSGi.init((VOIPLink)SipTelephone.this.voipLink);
                    System.out.println("try register2");
                }
                catch (Exception e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @Override
    public void call(TransportCall call) {
        try {
            OSGi.call((String)call.getPhone());
            this.listOut.add(call);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void hangUp(TransportCall call) {
        OSGi.hangup((String)call.getIdcall());
    }

    @Override
    public void answer(TransportCall call) {
        OSGi.answer((String)call.getIdcall());
    }

    @Override
    public void close() {
    }
}

