/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.calltransport.ui;

import java.awt.Desktop;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.calltransport.ui.SoundItem;
import ru.blok.vms.calltransport.ui.TrackWithSound;
import ru.blok.vms.core.ResourceStrings;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.core.SecurityWSProxy;
import ru.infor.common.FileUtils;
import ru.infor.common.SysProperties;

public class PlayNote
extends BeanViewerAction<ViewerContext> {
    static SecurityWSProxy proxy = new SecurityWSProxy(CurrentProxyFactory.getCurrentSOAPConnection());
    public static String cachePrefix = "";
    public static SimpleDateFormat dfYMD;

    static {
        String cacheDataFolder = SysProperties.getProperty((String)"cache.data.folder", (String)"");
        if (!cacheDataFolder.trim().equals("")) {
            cacheDataFolder = String.valueOf(cacheDataFolder) + File.separator;
        }
        cachePrefix = String.valueOf(cacheDataFolder) + "data" + File.separator + "sounds" + File.separator;
        dfYMD = new SimpleDateFormat("yyyyMMdd");
    }

    public boolean isNotEnableWithEmptySelection() {
        return true;
    }

    public String getHint() {
        return "\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0437\u0430\u043c\u0435\u0442\u043a\u0443";
    }

    public String getName() {
        return "\u041e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u044c \u0437\u0430\u043c\u0435\u0442\u043a\u0443";
    }

    public String getIcon() {
        return ResourceStrings.btPlayBlue;
    }

    private static void loadDataFromServer(SoundItem noteRoute, File dest) {
        String servername = "http://" + TrackWithSound.serverName + "/";
        try {
            String urlStr = String.valueOf(servername) + noteRoute.getFilename();
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)InitializedVariable.getCurrentConnection((URL)url);
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            InputStream input = conn.getInputStream();
            FileUtils.copy((InputStream)input, (File)dest.getAbsoluteFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getFileName(SoundItem item) {
        File desc = null;
        String destinationDir = String.valueOf(cachePrefix) + String.valueOf(InitializedVariable.user.getId()).trim() + File.separator + dfYMD.format(item.getDate());
        desc = new File(String.valueOf(destinationDir) + File.separator + item.getFilename());
        desc.getParentFile().mkdirs();
        return desc;
    }

    public static File getNotesFile(SoundItem item) {
        File desc = PlayNote.getFileName(item);
        PlayNote.loadDataFromServer(item, desc);
        return desc;
    }

    public static void runNote(SoundItem item, PanelContext pc) {
        try {
            File desc = PlayNote.getNotesFile(item);
            String destinationDir = desc.getAbsolutePath();
            int s = destinationDir.indexOf("\\.");
            if (s > 0) {
                destinationDir = String.valueOf(destinationDir.substring(0, s + 1)) + destinationDir.substring(s + 2);
                desc = new File(destinationDir);
            }
            Desktop.getDesktop().open(desc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(Object message) {
        BigContentViewer bg = (BigContentViewer)((ViewerContext)this.getContext()).getPresentator().getViewer();
        try {
            Object o = bg.getEditInstance();
            if (o != null) {
                SoundItem note = (SoundItem)o;
                PlayNote.runNote(note, (PanelContext)((ViewerContext)this.getContext()).getParentContext());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

