/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.calltransport.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.calltransport.ui.SoundItem;
import ru.blok.vms.core.ResourceStrings;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class SoundPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    protected HashMap<SoundItem, Polygon> mapV = new HashMap();
    List<SoundItem> listSoundItems;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        this.paintIcons2(g, map, vp2, vp3);
    }

    protected void paintIcons2(Graphics2D g, T map, Rectangle2D vp2, Rectangle2D vp3) {
        this.mapV.clear();
        SoundItem selectNote = null;
        if (this.listSoundItems != null) {
            for (SoundItem p : this.listSoundItems) {
                if (p.isSelect()) {
                    selectNote = p;
                    continue;
                }
                this.mapV.put(p, this.paintIcon(ResourceStrings.audioIcon, p.getLat(), p.getLon(), map, g, vp2, vp3, false));
            }
        }
        if (selectNote != null) {
            this.mapV.put(selectNote, this.paintIcon(ResourceStrings.audioIcon, selectNote.getLat(), selectNote.getLon(), map, g, vp2, vp3, true));
        }
    }

    public List<SoundItem> getListSoundItems() {
        return this.listSoundItems;
    }

    public void setListSoundItems(List<SoundItem> listSoundItems) {
        this.listSoundItems = listSoundItems;
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
    }

    public SoundItem includNote(Point2D pClick) {
        for (SoundItem p : this.mapV.keySet()) {
            if (this.mapV.get(p) == null || !this.mapV.get(p).contains(pClick)) continue;
            return p;
        }
        return null;
    }

    protected Polygon paintIcon(String icon, double lat, double lon, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, boolean select) {
        int y;
        int x;
        Point2D point = map.getTileFactory().geoToPixel(new GeoPosition(lat, lon), map.getZoom());
        if (vp2.contains(point)) {
            x = (int)(point.getX() - vp2.getX());
            y = (int)(point.getY() - vp2.getY());
            try {
                BufferedImage img1 = ImageIO.read(((Object)((Object)this)).getClass().getResource(icon));
                int imwidth = ((Image)img1).getWidth(null);
                int imheight = ((Image)img1).getHeight(null);
                if (select) {
                    g.setColor(Color.RED);
                    g.fillRect(x - imheight - 3, y - imwidth - 3, imheight + 6, imwidth + 6);
                    g.drawImage((Image)img1, x - imwidth, y - imheight, (ImageObserver)map);
                    Polygon p1 = new Polygon();
                    p1.addPoint((int)point.getX() + 3, (int)point.getY() + 3);
                    p1.addPoint((int)(point.getX() - (double)imwidth - 3.0), (int)point.getY() + 3);
                    p1.addPoint((int)(point.getX() - (double)imwidth - 3.0), (int)(point.getY() - (double)imheight - 3.0));
                    p1.addPoint((int)(point.getX() + 3.0), (int)(point.getY() - (double)imheight - 3.0));
                    return p1;
                }
                g.drawImage((Image)img1, x - imwidth, y - imheight, (ImageObserver)map);
                Polygon p1 = new Polygon();
                p1.addPoint((int)point.getX(), (int)point.getY());
                p1.addPoint((int)(point.getX() - (double)imwidth), (int)point.getY());
                p1.addPoint((int)(point.getX() - (double)imwidth), (int)(point.getY() - (double)imheight));
                p1.addPoint((int)point.getX(), (int)(point.getY() - (double)imheight));
                return p1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (vp3.contains(point)) {
            x = (int)(point.getX() - vp3.getX());
            y = (int)(point.getY() - vp3.getY());
            try {
                BufferedImage img1 = ImageIO.read(((Object)((Object)this)).getClass().getResource(icon));
                int imwidth = ((Image)img1).getWidth(null);
                int imheight = ((Image)img1).getHeight(null);
                if (select) {
                    g.setColor(Color.RED);
                    g.fillRect(x - imheight - 3, y - imwidth - 3, imheight + 6, imwidth + 6);
                    g.drawImage((Image)img1, x - imwidth, y - imheight, (ImageObserver)map);
                    Polygon p1 = new Polygon();
                    p1.addPoint((int)point.getX() + 3, (int)point.getY() + 3);
                    p1.addPoint((int)(point.getX() - (double)imwidth - 3.0), (int)point.getY() + 3);
                    p1.addPoint((int)(point.getX() - (double)imwidth - 3.0), (int)(point.getY() - (double)imheight - 3.0));
                    p1.addPoint((int)(point.getX() + 3.0), (int)(point.getY() - (double)imheight - 3.0));
                    return p1;
                }
                g.drawImage((Image)img1, x - imwidth, y - imheight, (ImageObserver)map);
                Polygon p1 = new Polygon();
                p1.addPoint((int)point.getX(), (int)point.getY());
                p1.addPoint((int)(point.getX() - (double)imwidth), (int)point.getY());
                p1.addPoint((int)(point.getX() - (double)imwidth), (int)(point.getY() - (double)imheight));
                p1.addPoint((int)point.getX(), (int)(point.getY() - (double)imheight));
                return p1;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

