/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.calltransport.ui;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.blok.common.core.InitializedVariable;
import ru.blok.vms.calltransport.ui.ListViewerSoundItem;
import ru.blok.vms.calltransport.ui.PlayNote;
import ru.blok.vms.calltransport.ui.SoundItem;
import ru.blok.vms.ui.mapviewer.imap.IMapViewerWithOneTrack;
import ru.blok.vms.ui.tracks.TrackAll;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.ws.objects.vms.entities.AbstractNDData;
import ru.infor.ws.objects.vms.entities.NavigationDevice;
import ru.infor.ws.objects.vms.entities.Transport2DeviceLink;
import ru.infor.ws.objects.vms.entities.ext.TransportExt;

@ListView(views={@View(title="\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u0441\u0435\u0433\u043e \u043f\u0443\u0442\u0438", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class TrackWithSound
extends TrackAll {
    static HashMap<String, String> sp2 = null;
    public static String serverName = null;
    private static SimpleDateFormat dateWithTimeFormat;
    SoundItem selectedSoundItem;
    List<SoundItem> listSoundItems = new ArrayList<SoundItem>();

    static {
        sp2 = InitializedVariable.runtimeParameters(null);
        if (sp2.get("sound.server.name") != null) {
            serverName = sp2.get("sound.server.name");
        }
        dateWithTimeFormat = new SimpleDateFormat("yyyyMMddHHmm");
    }

    public TrackWithSound(String keyPage) {
        super(keyPage);
    }

    private String concat(String b, String e) {
        String filter = "";
        int i = 0;
        while (b.charAt(i) == e.charAt(i) && i < b.length()) {
            filter = String.valueOf(filter) + b.charAt(i);
            ++i;
        }
        int ii = i;
        while (ii < b.length()) {
            filter = String.valueOf(filter) + ".";
            ++ii;
        }
        return filter;
    }

    private String setFilter(Date from, Date end) {
        String frb = dateWithTimeFormat.format(from);
        String fre = dateWithTimeFormat.format(end);
        return this.concat(frb, fre);
    }

    private SoundItem parse(String s, Date from, Date end) {
        if (s.startsWith("<pre>")) {
            s = s.substring(5);
        }
        try {
            String ds = s.substring(7, 19);
            Date d = dateWithTimeFormat.parse(ds);
            if (from.before(d) && end.after(d)) {
                String[] sa = s.split("-");
                String source = sa[1];
                String dest = sa[2].substring(0, sa[2].length() - 4);
                SoundItem si = new SoundItem(s, d, source, dest);
                return si;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public synchronized void reload(List<AbstractNDData> list1) {
        super.reload(list1);
        if (this.getLinkT2D().getObjList() == null || this.getLinkT2D().getObjList().length == 0) {
            return;
        }
        Object[] oo = this.getLinkT2D().getObjList();
        Date from = this.getDateFrom();
        Date end = this.getDateTill();
        this.listSoundItems.clear();
        if (oo.length > 0) {
            String datefilter = this.setFilter(from, end);
            Object[] objectArray = oo;
            int n = oo.length;
            int n2 = 0;
            while (n2 < n) {
                NavigationDevice device;
                Object o = objectArray[n2];
                Transport2DeviceLink link = (Transport2DeviceLink)o;
                if ((link.getBeginDate() == null || link.getBeginDate().before(end)) && (link.getEndDate() == null || link.getEndDate().after(from)) && (device = link.getDevice()).getPhone() != null) {
                    String dev = device.getPhone();
                    if (dev.substring(0, 1).equals("+")) {
                        dev = dev.substring(1);
                    }
                    String url1 = "http://" + serverName + "/" + "?date=" + datefilter + "&src=" + dev;
                    String url2 = "http://" + serverName + "/" + "?date=" + datefilter + "&dst=" + dev;
                    try {
                        SoundItem si;
                        String line;
                        URL url = new URL(url1);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        ArrayList<String> ss = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            ss.add(line);
                        }
                        reader.close();
                        for (String s : ss) {
                            si = this.parse(s, from, end);
                            if (si == null) continue;
                            this.listSoundItems.add(si);
                            si.setSrcName(((TransportExt)link.getTransport()).getNameSMP());
                        }
                        ss = new ArrayList();
                        url = new URL(url2);
                        reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        while ((line = reader.readLine()) != null) {
                            ss.add(line);
                        }
                        reader.close();
                        for (String s : ss) {
                            si = this.parse(s, from, end);
                            if (si == null) continue;
                            this.listSoundItems.add(si);
                            si.setDestName(((TransportExt)link.getTransport()).getNameSMP());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        Collections.sort(this.listSoundItems, new Comparator<SoundItem>(){

            @Override
            public int compare(SoundItem o1, SoundItem o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        int i = 0;
        int currentItems = 0;
        List<AbstractNDData> data = this.getList();
        if (this.listSoundItems.size() > 0 && data.size() > 0) {
            while (this.listSoundItems.get(currentItems).getDate().before(data.get(i).getCreatedDateTime())) {
                this.listSoundItems.get(currentItems).setData(data.get(i));
                this.listSoundItems.get(currentItems).setIndex(i);
                ++currentItems;
            }
            while (data.size() > i + 1 && currentItems < this.listSoundItems.size()) {
                if (data.get(i).getCreatedDateTime().before(this.listSoundItems.get(currentItems).getDate()) && data.get(i + 1).getCreatedDateTime().after(this.listSoundItems.get(currentItems).getDate())) {
                    this.listSoundItems.get(currentItems).setData(data.get(i));
                    this.listSoundItems.get(currentItems).setIndex(i);
                    ++currentItems;
                }
                ++i;
            }
            while (currentItems < this.listSoundItems.size()) {
                this.listSoundItems.get(currentItems).setData(data.get(i));
                this.listSoundItems.get(currentItems).setIndex(i);
                ++currentItems;
            }
        }
        for (SoundItem s : this.listSoundItems) {
            AbstractNDData d = s.getData();
            if (s.getIndex() + 1 < data.size() && d.getCreatedDateTime().before(s.getDate())) {
                AbstractNDData d1 = data.get(s.getIndex() + 1);
                long l = d1.getCreatedDateTime().getTime() - d.getCreatedDateTime().getTime();
                long l2 = s.getDate().getTime() - d.getCreatedDateTime().getTime();
                double k = l2 / l;
                double lat = d.getLat() + (d1.getLat() - d.getLat()) * k;
                double lon = d.getLon() + (d1.getLon() - d.getLon()) * k;
                s.setLat(lat);
                s.setLon(lon);
                continue;
            }
            s.setLat(d.getLat());
            s.setLon(d.getLon());
        }
        ((IMapViewerWithOneTrack)this.getValue().mapViewerWithTrack).setSoundItems(this.listSoundItems);
        ((PanelContext)((ViewerContext)this.getLoadData().getContext()).getParentContext()).getPanel().updateUIForPresentatorName("listSoundItems");
        ((PanelContext)((ViewerContext)this.getLoadData().getContext()).getParentContext()).getPanel().updateUIForPresentatorName("value");
    }

    public SoundItem getSelectedSoundItem() {
        return this.selectedSoundItem;
    }

    public void setSelectedSoundItem(SoundItem soundItem) {
        this.selectedSoundItem = soundItem;
        for (SoundItem i : this.listSoundItems) {
            i.setSelect(i.equals(soundItem));
        }
    }

    public void setSelectedSoundItem(SoundItem soundItem, PanelContext pc) {
        this.setSelectedSoundItem(soundItem);
        if (soundItem == null) {
            ((ListViewer)pc.getPanel().getPresentatorForName("listSoundItems").getViewer()).getTM().clearSelection();
        } else {
            ((ListViewer)pc.getPanel().getPresentatorForName("listSoundItems").getViewer()).getTM().setSelectedRows(new int[]{this.getListSoundItems().indexOf(this.selectedSoundItem)});
        }
    }

    @ListField(fields={@Field(title="", order=5000, propertiesLayout="Scroll1:Split1/h/l/0.3:m1:Tab1/\u0417\u0430\u043f\u0438\u0441\u0438 \u0437\u0432\u043e\u043d\u043a\u043e\u0432", viewer={ListViewerSoundItem.class}, content=SoundItem.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=PlayNote.class, doubleclick=true)})})})
    public List<SoundItem> getListSoundItems() {
        return this.listSoundItems;
    }
}

