/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.importroute;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.PGgeometry;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.vms.RouteWSProxy;
import ru.infor.common.SysProperties;
import ru.infor.ws.objects.vms.RouteSearchCriteria;
import ru.infor.ws.objects.vms.RouteWatchAreaParams;
import ru.infor.ws.objects.vms.entities.Route;

@ListView(views={@View(title="\u0418\u043c\u043f\u043e\u0440\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043e\u0432 \u0438\u0437 osm", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class ImportRouteFromOsm {
    static Connection connection = null;
    BeanViewerAction<ViewerContext> bva = new BeanViewerAction<ViewerContext>(){

        public String getName() {
            return "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0438\u043c\u043f\u043e\u0440\u0442 \u0433\u0435\u043e\u043c\u0435\u0442\u0440\u0438\u0438 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043e\u0432";
        }

        public void actionPerformed(Object message) {
            try {
                ImportRouteFromOsm.getConnection();
                ImportRouteFromOsm.this.importRoutes();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    RouteWSProxy proxy = (RouteWSProxy)CurrentProxyFactory.getProxy(Route.class);
    RouteSearchCriteria criteria = (RouteSearchCriteria)this.proxy._getSearchCriteriaTemplate();

    @ListField(fields={@Field(title="", order=40, propertiesLayout="Split1/v/l/0.5:0", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBva() {
        return this.bva;
    }

    private static void getConnection() throws Exception {
        Class.forName(SysProperties.getProperty((String)"connectionosm.driver", (String)""));
        String url = SysProperties.getProperty((String)"connectionosm.url", (String)"");
        String user = SysProperties.getProperty((String)"connectionosm.USER", (String)"");
        String password = SysProperties.getProperty((String)"connectionosm.PASSWORD", (String)"");
        connection = DriverManager.getConnection(url, user, password);
    }

    private void importRoutes() throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery(" select * from relations r    where r.id in (select relation_id from relation_tags where k = 'operator' and v like '\u041f\u0410\u0422\u041f \u21161') ");
        while (rs.next()) {
            long rel_id = rs.getLong("id");
            String name = null;
            Statement stmtname = connection.createStatement();
            ResultSet rsname = stmtname.executeQuery(" select * from relation_tags where k = 'ref' and relation_id = " + rel_id);
            if (rsname.next()) {
                name = rsname.getString("v");
            }
            Statement stmt1 = connection.createStatement();
            ResultSet rs1 = stmt1.executeQuery(" select w.linestring as l from relations r  join relation_members rm on rm.relation_id = r.id join ways w  on rm.member_id= w.id where rm.member_type='W'  and r.id =  " + rel_id);
            ArrayList<LineString> ll = new ArrayList<LineString>();
            while (rs1.next()) {
                PGgeometry g = (PGgeometry)rs1.getObject("l");
                if (!(g.getGeometry() instanceof LineString)) continue;
                ll.add((LineString)g.getGeometry());
            }
            MultiLineString ms = new MultiLineString(ll.toArray(new LineString[0]));
            ms.setSrid(4326);
            this.setRoute(name, ms);
            System.out.println("import route " + name);
        }
    }

    private void setRoute(String name, MultiLineString ms) {
        this.criteria.setNum("*" + name + "*");
        Object[] oo = this.proxy.getList(InitializedVariable.context, this.criteria).getObjList();
        if (oo != null && oo.length > 0) {
            Route r = (Route)oo[0];
            r.setRouteGeom(ms.toString());
            r = this.proxy.save(InitializedVariable.context, r);
            RouteWatchAreaParams params = new RouteWatchAreaParams();
            params.setRouteIdList(new Long[]{r.getId()});
            params.setDeltaInMeters(Double.valueOf(10.0));
            this.proxy.generateRouteWatchArea(InitializedVariable.context, params);
        }
    }
}

