/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.plugin.viewer;

import java.util.logging.Logger;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.directories.FRCAsyncDirectoryViewer;
import ru.blok.common.ui.users.UserList;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.DefaultTableCellViewer;
import ru.infor.beanviewer.viewer.simple.ExtendedDirectoryViewer;
import ru.infor.client.soap.proxy.core.UserWSProxy;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.core.UserSearchCriteria;
import ru.infor.ws.objects.core.entities.User;

public class UserListViewer<T>
extends FRCAsyncDirectoryViewer<T> {
    private Long[] lID;

    public Class getTableCellViewerClass() {
        return UserListCellViewer.class;
    }

    public UserListViewer(UIFactory<T> factory) {
        super(factory);
    }

    public CommonSearchCriteria updateSearchCriteria(CommonSearchCriteria sc, String value) {
        ((UserSearchCriteria)sc).setQuickSearch(value);
        return sc;
    }

    public void setContentClass(Class<?> cls) {
        super.setContentClass(User.class);
    }

    public Object getValue() {
        Object o = super.getValue();
        if (o instanceof User) {
            this.lID = new Long[]{((User)o).getId()};
        }
        return this.lID;
    }

    public void setValue(Object object) {
        this.lID = object instanceof User ? new Long[]{((User)object).getId()} : (Long[])object;
        super.setValue((Object)this.valueToString(object));
    }

    public String valueToString(Object value) {
        if (this.lID == null) {
            return "";
        }
        if (this.lID.length == 1) {
            User wb = null;
            UserWSProxy proxy = (UserWSProxy)CurrentProxyFactory.getProxy(User.class);
            UserSearchCriteria sc = new UserSearchCriteria();
            sc.setIdList(new Long[]{this.lID[0]});
            UserWSProxy.SearchResultListUser sr = proxy.getUsers(InitializedVariable.context, sc);
            if (!sr.isEmpty()) {
                wb = (User)sr.getObjList()[0];
            }
            if (wb != null) {
                return this.objectToString(wb);
            }
            return "";
        }
        return "\u041e\u0442\u0431\u043e\u0440 \u043f\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c (" + this.lID.length + " \u0448\u0442.)";
    }

    public String objectToString(Object o) {
        if (o == null) {
            return super.objectToString(o);
        }
        return ((User)o).getName();
    }

    public void buttonActionPerfomed() {
        try {
            UserList list = new UserList(this.getViewerContext().getKeyPage());
            this.getFactory().newPage(User.class, UserList.class, (Object)list, this.getViewerContext(), "filterInListForListId");
        }
        catch (Exception exception) {
            Logger.getLogger(ExtendedDirectoryViewer.class.getName()).severe("Can't create directory presentation " + this.getPresentationClass().getName());
        }
    }

    public static class UserListCellViewer<T>
    extends DefaultTableCellViewer<T> {
        public UserListCellViewer(UIFactory<T> factory) {
            super(factory);
        }

        public void setValue(Object object) {
            super.setValue((Object)(object == null ? "" : ((User)object).getName()));
        }
    }
}

