/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.testshowdatamap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.vms.testshowdatamap.MapValuePoint;
import ru.blok.vms.testshowdatamap.Point;
import ru.blok.vms.ui.mapviewer.imap.IMapValue;
import ru.blok.vms.ui.mapviewer.mapviewerwithtrack.view.MapViewPainter;

public class PointPainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    MapValuePoint value;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        this.paintRoute(map, g, vp2, vp3);
    }

    protected void paintRoute(T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        if (this.value.getList() != null && this.value.getList().size() > 0) {
            g.setColor(Color.RED);
            Point p = this.value.getList().get(0);
            GeoPosition n = new GeoPosition(p.getLat(), p.getLon());
            Point2D pointFrom = map.getTileFactory().geoToPixel(n, map.getZoom());
            int i = 1;
            while (i < this.value.getList().size()) {
                Point p1 = this.value.getList().get(i);
                GeoPosition n1 = new GeoPosition(p1.getLat(), p1.getLon());
                Point2D pointTo = map.getTileFactory().geoToPixel(n1, map.getZoom());
                this.paintL(pointFrom, pointTo, map, g, vp2, vp3, p.getNum());
                pointFrom = pointTo;
                p = p1;
                n = n1;
                ++i;
            }
            this.paintL(pointFrom, null, map, g, vp2, vp3, p.getNum());
        }
    }

    protected void paintL(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, String text) {
        if (point != null && vp2.contains(point) || vp2.contains(pointFrom)) {
            g.setColor(Color.RED);
            if (point != null) {
                g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
            }
            if (map.getZoom() < 2) {
                g.setColor(Color.BLUE);
                g.fillRect((int)(pointFrom.getX() - vp2.getX()) - 2, (int)(pointFrom.getY() - vp2.getY()) - 2, 5, 5);
                g.drawString(text, (int)(pointFrom.getX() - vp2.getX()) + 3, (int)(pointFrom.getY() - vp2.getY()) - 3);
            }
        }
    }

    @Override
    public void setValue(IMapValue mapValueWithTrack) {
        this.value = (MapValuePoint)mapValueWithTrack;
    }
}

