/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui;

import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.infor.client.soap.proxy.core.EventLogWSProxy;
import ru.infor.client.soap.proxy.core.UserWSProxy;
import ru.infor.client.soap.proxy.core.UsersGroupWSProxy;
import ru.infor.ws.objects.CommonSearchCriteria;
import ru.infor.ws.objects.core.UsersGroupSearchCriteria;
import ru.infor.ws.objects.core.entities.EventLog;
import ru.infor.ws.objects.core.entities.User;
import ru.infor.ws.objects.core.entities.UsersGroup;
import ru.infor.ws.proxy.interfaces.InvocationContext;

public class HelpUtils {
    static Integer SizeStringEventLog = 228;
    static HashMap<String, Long> mapTimes = new HashMap();
    static EventLogWSProxy eventLogProxy = (EventLogWSProxy)CurrentProxyFactory.getProxy(EventLog.class);
    static UserWSProxy userProxy = (UserWSProxy)CurrentProxyFactory.getProxy(User.class);
    static UsersGroupWSProxy usergroupProxy = (UsersGroupWSProxy)CurrentProxyFactory.getProxy(UsersGroup.class);
    private static HashMap<Long, UsersGroup> mapUG = null;
    static Color[] listColor = new Color[]{new Color(255, 0, 0, 255), new Color(0, 0, 255, 255), new Color(255, 255, 0, 255), new Color(255, 0, 255, 100), new Color(0, 255, 255, 100), new Color(0, 0, 0, 100), new Color(127, 255, 0, 100), new Color(0, 255, 0, 255)};

    public static HashMap<Long, UsersGroup> getMapUG() {
        if (mapUG == null) {
            mapUG = new HashMap();
        }
        return mapUG;
    }

    public static UsersGroup getPrimaryGroup(Long userId) {
        UsersGroup ug = HelpUtils.getMapUG().get(userId);
        if (ug != null) {
            return ug;
        }
        User user = userProxy._universalGetCurrentObject((InvocationContext)InitializedVariable.context, userId);
        if (user != null) {
            UsersGroupSearchCriteria criteria = new UsersGroupSearchCriteria();
            criteria.setIdList(new Long[]{user.getPrimaryGroupId()});
            UsersGroupWSProxy.SearchResultListUsersGroup sr = usergroupProxy.getUsersGroupList(InitializedVariable.context, criteria);
            if (!sr.isEmpty()) {
                ug = (UsersGroup)sr.getObjList()[0];
                HelpUtils.getMapUG().put(userId, ug);
            }
        }
        return ug;
    }

    public static String getPrimaryGroupName(Long userId) {
        UsersGroup ug = HelpUtils.getPrimaryGroup(userId);
        if (ug != null) {
            return ug.getName();
        }
        return "";
    }

    public static void putToMapTimes(String key) {
        if (mapTimes == null) {
            mapTimes = new HashMap();
        }
        mapTimes.put(key, System.currentTimeMillis());
    }

    public static Long getFromMapTimes(String key) {
        if (mapTimes.get(key) != null) {
            return mapTimes.get(key);
        }
        return null;
    }

    public static void deleteToMapTimes(String key) {
        if (mapTimes.get(key) != null) {
            mapTimes.remove(key);
        }
    }

    public static void eraseMapTimes() {
        if (mapTimes != null) {
            mapTimes.clear();
        }
    }

    public static void showDeltaTime(String key) {
        Long beg = HelpUtils.getFromMapTimes(key);
        if (beg == null) {
            HelpUtils.putToMapTimes(key);
            beg = HelpUtils.getFromMapTimes(key);
        }
        System.out.println("***************    key=" + key + " t=" + (double)(System.currentTimeMillis() - beg) / 1000.0 + " sec");
    }

    public static Double convertString2Double(String val, String fp) {
        String[] mfp;
        if (val == null) {
            return null;
        }
        if (fp == null) {
            return null;
        }
        fp = fp.replaceAll("De", "###0").replaceAll("Mi", "###0").replaceAll("Se", "###0").replaceAll("9", "#");
        String[] mval = val.split(" ");
        if (mval.length != (mfp = fp.split(" ")).length) {
            return null;
        }
        if (mfp.length == 1) {
            try {
                return Double.parseDouble(mval[0]);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (mfp.length == 2) {
            try {
                return Double.parseDouble(mval[0]) + Double.parseDouble(mval[1]) / 60.0;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return Double.parseDouble(mval[0]) + Double.parseDouble(mval[1]) / 60.0 + Double.parseDouble(mval[2]) / 3600.0;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String convertLatLon(Double d, String fp) {
        if (d == null) {
            return "";
        }
        if (!(d instanceof Double)) {
            return d.toString();
        }
        String[] mf = HelpUtils.partitionTemplate(fp);
        Double de = Math.floor(d);
        Double mi0 = (d - de) * 60.0;
        Double mi = Math.floor(mi0);
        Double se0 = (mi0 - mi) * 60.0;
        String ss = mf[0].replaceAll("De", "###0");
        ss = ss.replaceAll("9", "#");
        DecimalFormat df = new DecimalFormat(ss);
        if (mf.length == 1) {
            return df.format(d);
        }
        String rez = df.format(de).concat("\u00b0").concat(" ");
        ss = mf[1].replaceAll("Mi", "###0");
        ss = ss.replaceAll("9", "#");
        df = new DecimalFormat(ss);
        if (mf.length == 2) {
            rez = rez.concat(df.format(mi0)).concat("'");
            return rez;
        }
        rez = rez.concat(df.format(mi)).concat("' ");
        ss = mf[2].replaceAll("Se", "###0");
        ss = ss.replaceAll("9", "#");
        df = new DecimalFormat(ss);
        rez = rez.concat(df.format(se0)).concat("\"");
        return rez;
    }

    public static String[] partitionTemplate(String fp) {
        ArrayList<String> listF = new ArrayList<String>();
        if (fp.toLowerCase().indexOf("de") < 0) {
            listF.add("De.99");
            return listF.toArray(new String[listF.size()]);
        }
        String de = fp.substring(fp.toLowerCase().indexOf("de"));
        int i1 = de.indexOf(" ");
        if (i1 < 0 && de.length() == fp.length()) {
            listF.add(fp);
            return listF.toArray(new String[listF.size()]);
        }
        if ((de = de.substring(0, i1)).indexOf(".") > 0) {
            listF.add(de.trim());
            return listF.toArray(new String[listF.size()]);
        }
        listF.add(de);
        if (fp.toLowerCase().indexOf("mi") < 0) {
            return listF.toArray(new String[listF.size()]);
        }
        String mi = fp.substring(fp.toLowerCase().indexOf("mi"));
        i1 = mi.indexOf(" ");
        if (i1 < 0) {
            listF.add(mi);
            return listF.toArray(new String[listF.size()]);
        }
        if ((mi = mi.substring(0, i1)).indexOf(".") > 0) {
            listF.add(mi.trim());
            return listF.toArray(new String[listF.size()]);
        }
        listF.add(mi);
        if (fp.toLowerCase().indexOf("se") < 0) {
            return listF.toArray(new String[listF.size()]);
        }
        String se = fp.substring(fp.toLowerCase().indexOf("se"));
        i1 = se.indexOf(" ");
        if (i1 < 0) {
            listF.add(se);
            return listF.toArray(new String[listF.size()]);
        }
        if ((se = se.substring(0, i1)).indexOf(".") > 0) {
            listF.add(se.trim());
            return listF.toArray(new String[listF.size()]);
        }
        listF.add(se);
        return listF.toArray(new String[listF.size()]);
    }

    public static Color getCurrentColor(int currentColorIndex, boolean shortLength) {
        if (shortLength) {
            return listColor[new BigDecimal(currentColorIndex).toBigInteger().mod(new BigDecimal(7).toBigInteger()).intValue()];
        }
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArray[1] = 127;
        int[] zn = nArray;
        if (currentColorIndex > 27) {
            currentColorIndex = 1;
        }
        int a = new BigDecimal(currentColorIndex).toBigInteger().mod(new BigDecimal(3).toBigInteger()).intValue();
        int a3 = (currentColorIndex - a) / 3;
        int b = new BigDecimal(a3).toBigInteger().mod(new BigDecimal(3).toBigInteger()).intValue();
        int c = (a3 - b) / 3;
        return new Color(zn[c], zn[b], zn[a], 127);
    }

    public static Date getRouteScheduleRunTime(Date time) {
        if (time == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        c.set(1, 2013);
        c.set(2, 0);
        c.set(5, 1);
        if (c.get(11) < 3) {
            c.add(5, 1);
        }
        return c.getTime();
    }

    public static boolean afterTime(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        Calendar c = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date1);
        c.setTime(date2);
        c2.set(12, c.get(12));
        c2.set(11, c.get(11));
        c2.set(13, c.get(13));
        return c1.after(c2);
    }

    public static boolean beforeTime(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        Calendar c = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date1);
        c.setTime(date2);
        c2.set(12, c.get(12));
        c2.set(11, c.get(11));
        c2.set(13, c.get(13));
        return c1.before(c2);
    }

    public static Date copyTimeFromDate(Date date1, Date date2) {
        if (date2 == null || date1 == null) {
            return HelpUtils.getRouteScheduleRunTime(date1);
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        c2.set(12, c1.get(12));
        c2.set(11, c1.get(11));
        c2.set(13, c1.get(13));
        return HelpUtils.getRouteScheduleRunTime(c2.getTime());
    }

    public static Date copyTimeFromDateNoShift(Date date1, Date date2) {
        if (date2 == null) {
            return CommonSearchCriteria.beginOfDay((Date)date1);
        }
        if (date1 == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        c2.set(12, c1.get(12));
        c2.set(11, c1.get(11));
        c2.set(13, c1.get(13));
        return c2.getTime();
    }

    public static boolean equalsTimeFromDate(Date date1, Date date2) {
        Calendar time1 = Calendar.getInstance();
        Calendar time2 = Calendar.getInstance();
        Calendar c = Calendar.getInstance();
        if (date2 == null || date1 == null) {
            return false;
        }
        time1.setTime(date1);
        time2.setTime(date1);
        c.setTime(date2);
        time2.set(11, c.get(11));
        time2.set(12, c.get(12));
        time2.set(13, c.get(13));
        return time1.equals(time2);
    }

    public static Double getShareOfHoursFromMinute(Integer min) {
        if (min == null) {
            return new Double(0.0);
        }
        return min.doubleValue() / 60.0;
    }

    public static Double getShareOfHoursFromDuration(Date start, Date end) {
        if (start == null || end == null || end.before(start)) {
            return new Double(0.0);
        }
        return new Double(new Long(end.getTime() - start.getTime()).doubleValue() / 60000.0 / 60.0);
    }

    public static Double getNigthShareOfHoursFromDuration(Date start, Date end) {
        if (start == null || end == null || end.before(start)) {
            return new Double(0.0);
        }
        Double res = new Double(0.0);
        Calendar c_start = Calendar.getInstance();
        c_start.setTime(start);
        Calendar c_end = Calendar.getInstance();
        c_end.setTime(HelpUtils.getRouteScheduleRunTime(end));
        Calendar c_6 = Calendar.getInstance();
        c_6.setTime(HelpUtils.getRouteScheduleRunTime(start));
        Calendar c_22 = Calendar.getInstance();
        c_22.setTime(HelpUtils.getRouteScheduleRunTime(start));
        if (c_start.getTime().before(c_6.getTime()) && c_end.getTime().before(c_6.getTime())) {
            res = res + HelpUtils.getShareOfHoursFromDuration(c_start.getTime(), c_end.getTime());
        }
        if (c_start.getTime().after(c_22.getTime()) && c_end.getTime().after(c_22.getTime())) {
            res = res + HelpUtils.getShareOfHoursFromDuration(c_start.getTime(), c_end.getTime());
        }
        if (c_start.getTime().before(c_6.getTime()) && c_end.getTime().after(c_6.getTime())) {
            res = res + HelpUtils.getShareOfHoursFromDuration(c_start.getTime(), c_6.getTime());
        }
        if (c_start.getTime().before(c_22.getTime()) && c_end.getTime().after(c_22.getTime())) {
            res = res + HelpUtils.getShareOfHoursFromDuration(c_22.getTime(), c_end.getTime());
        }
        return res;
    }

    public static void addRecordInEventLog(String record) {
        if (record != null && record.length() > 0) {
            int s = 0;
            int e = SizeStringEventLog;
            while (s < record.length()) {
                String str = s == 0 ? "" : "\u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435: ";
                if (s + SizeStringEventLog < record.length()) {
                    e = s + SizeStringEventLog;
                    if ((e = record.lastIndexOf(" ", e)) == -1 || e < s) {
                        e = s + SizeStringEventLog;
                    }
                    str = String.valueOf(str) + record.substring(s, e) + "...";
                } else {
                    e = record.length();
                    str = String.valueOf(str) + record.substring(s, e);
                }
                s = e + 1;
                String initi = "\u041a\u043b\u0438\u0435\u043d\u0442 - ".concat(InitializedVariable.context.getInitiator() != null ? InitializedVariable.context.getInitiator() : "").concat(" (").concat(InitializedVariable.context.getClientIPAddress() != null && !InitializedVariable.context.getClientIPAddress().trim().equals("") ? InitializedVariable.context.getClientIPAddress() : "?").concat(") ");
                eventLogProxy.loggingEvent(InitializedVariable.context, new Date(), InitializedVariable.context.getUserName(), initi, str);
            }
        }
    }
}

