/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.vms.ui;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;

public class Sisnet {
    public static void main(String[] args) throws Exception {
        SBASMessageType sbsmsg = new SBASMessageType();
        SBASCorrectionsType sbscorr = new SBASCorrectionsType();
        SBASDegradationsType sbsdegr = new SBASDegradationsType();
        SBASEphemerisType sbseph = new SBASEphemerisType();
        SBASAlmanacsType sbsalm = new SBASAlmanacsType();
        SBASIonosphericType sbsion = new SBASIonosphericType();
        SBASTimeType sbstime = new SBASTimeType();
        SBASServiceType sbsserv = new SBASServiceType();
        SBASCovarianceType sbscov = new SBASCovarianceType();
        InputStream is = Files.newInputStream(Paths.get("sis_201507291120.log", new String[0]), new OpenOption[0]);
        int b = 0;
        while (b != -1) {
            b = is.read();
            if (b != 42 || (b = is.read()) != 77 || (b = is.read()) != 83 || (b = is.read()) != 71 || (b = is.read()) != 44) continue;
            int l = 0;
            byte[] msg = new byte[80];
            b = is.read();
            while (b != 10 && b != -1 && l < msg.length) {
                msg[l++] = (byte)b;
                b = is.read();
            }
            if (b != 10) continue;
            if (msg[l - 1] == 13) {
                --l;
            }
            msg[l] = 0;
            int ret = Sisnet.sisnetmsg2sbasmsg(msg, sbsmsg);
            if (ret != 0) {
                System.out.printf("Error SISNET message: %d \r\n", ret);
                continue;
            }
            Sisnet.decode_msgtype(sbsmsg, sbscorr, sbsdegr, sbseph, sbsalm, sbsion, sbstime, sbsserv, sbscov);
            Sisnet.view_msgtype(sbsmsg, sbscorr, sbsdegr, sbseph, sbsalm, sbsion, sbstime, sbsserv, sbscov);
        }
    }

    public static int sisnetmsg2sbasmsg(byte[] msg, SBASMessageType sbsmsg) {
        byte b;
        byte[] ab = new byte[68];
        int n = 0;
        int tmp = 0;
        while (msg[n] != 44) {
            if (msg[n] >= 48 && msg[n] <= 57) {
                tmp = tmp * 10 + (msg[n++] - 48);
                continue;
            }
            return 1;
        }
        sbsmsg.week = tmp;
        ++n;
        tmp = 0;
        while (msg[n] != 44) {
            if (msg[n] >= 48 && msg[n] <= 57) {
                tmp = tmp * 10 + (msg[n++] - 48);
                continue;
            }
            return 2;
        }
        sbsmsg.TOW = tmp;
        tmp = ++n;
        int i = 0;
        while (i < 67) {
            if (msg[n] >= 48 && msg[n] <= 57) {
                ab[i] = (byte)(msg[n] - 48);
            } else if (msg[n] >= 65 && msg[n] <= 70) {
                ab[i] = (byte)(msg[n] - 65 + 10);
            } else if (msg[n] == 124 || msg[n] == 47) {
                ab[i] = msg[n];
            } else if (msg[n] == 42) {
                ab[i] = msg[n];
                i = 64;
                if (msg[n + 1] == 32) {
                    msg[n + 1] = 48;
                }
            } else {
                return 3;
            }
            ++n;
            ++i;
        }
        n = tmp;
        i = 0;
        while (ab[i] != 42 && i < 64) {
            int j;
            if (ab[i] == 124) {
                j = ab[++i];
                while (j > 1) {
                    msg[n++] = ab[i - 2];
                    --j;
                }
            } else if (ab[i] == 47) {
                j = ab[++i] * 16;
                j += ab[++i];
                while (j > 1) {
                    msg[n++] = ab[i - 3];
                    --j;
                }
            } else {
                msg[n++] = ab[i];
            }
            ++i;
        }
        if (ab[i] != 42) {
            return 4;
        }
        msg[n] = 0;
        ab[0] = 0;
        ab[64] = (byte)((ab[65] << 4) + ab[66]);
        n = tmp;
        i = 0;
        while (i < 29) {
            b = (byte)(msg[n++] << 4);
            sbsmsg.message[i] = b = (byte)(b + msg[n++]);
            ab[64] = (byte)(ab[64] ^ b);
            int n2 = i;
            ab[n2] = (byte)(ab[n2] + (byte)(b >>> 6 & 3));
            ab[i + 1] = (byte)(b << 2);
            ++i;
        }
        sbsmsg.message[28] = (byte)(sbsmsg.message[28] & 0xC0);
        tmp = 0;
        while (i < 32) {
            b = (byte)(msg[n++] << 4);
            b = (byte)(b + msg[n++]);
            ab[64] = (byte)(ab[64] ^ b);
            int n3 = i;
            ab[n3] = (byte)(ab[n3] + (byte)(b >>> 6 & 3));
            ab[i + 1] = (byte)(b << 2);
            tmp = (tmp << 8) + (ab[i] & 0xFF);
            ++i;
        }
        if (ab[64] != 0) {
            return 5;
        }
        if (Sisnet.crc24q(ab, 29) != tmp) {
            return 6;
        }
        return 0;
    }

    private static int crc24q(byte[] buff, int len) {
        int[] nArray = new int[256];
        nArray[1] = 8801531;
        nArray[2] = 9098509;
        nArray[3] = 825846;
        nArray[4] = 9692897;
        nArray[5] = 0x15AA1A;
        nArray[6] = 1651692;
        nArray[7] = 10452759;
        nArray[8] = 10584377;
        nArray[9] = 2608578;
        nArray[10] = 2839604;
        nArray[11] = 11344079;
        nArray[12] = 3303384;
        nArray[13] = 11807523;
        nArray[14] = 12104405;
        nArray[15] = 4128302;
        nArray[16] = 12930697;
        nArray[17] = 4391538;
        nArray[18] = 5217156;
        nArray[19] = 13227903;
        nArray[20] = 5679208;
        nArray[21] = 13690003;
        nArray[22] = 14450021;
        nArray[23] = 5910942;
        nArray[24] = 6606768;
        nArray[25] = 14844747;
        nArray[26] = 15604413;
        nArray[27] = 6837830;
        nArray[28] = 16197969;
        nArray[29] = 7431594;
        nArray[30] = 8256604;
        nArray[31] = 16494759;
        nArray[32] = 840169;
        nArray[33] = 9084178;
        nArray[34] = 8783076;
        nArray[35] = 18463;
        nArray[36] = 10434312;
        nArray[37] = 1670131;
        nArray[38] = 1434117;
        nArray[39] = 9678590;
        nArray[40] = 11358416;
        nArray[41] = 2825259;
        nArray[42] = 2590173;
        nArray[43] = 10602790;
        nArray[44] = 4109873;
        nArray[45] = 12122826;
        nArray[46] = 11821884;
        nArray[47] = 3289031;
        nArray[48] = 13213536;
        nArray[49] = 5231515;
        nArray[50] = 4409965;
        nArray[51] = 12912278;
        nArray[52] = 5929345;
        nArray[53] = 14431610;
        nArray[54] = 13675660;
        nArray[55] = 5693559;
        nArray[56] = 6823513;
        nArray[57] = 15618722;
        nArray[58] = 14863188;
        nArray[59] = 6588335;
        nArray[60] = 0xFBF8B8;
        nArray[61] = 8238147;
        nArray[62] = 7417269;
        nArray[63] = 16212302;
        nArray[64] = 1680338;
        nArray[65] = 10481449;
        nArray[66] = 9664223;
        nArray[67] = 1391140;
        nArray[68] = 9061683;
        nArray[69] = 788936;
        nArray[70] = 36926;
        nArray[71] = 8838341;
        nArray[72] = 12067563;
        nArray[73] = 4091408;
        nArray[74] = 3340262;
        nArray[75] = 11844381;
        nArray[76] = 2868234;
        nArray[77] = 11372785;
        nArray[78] = 10555655;
        nArray[79] = 2579964;
        nArray[80] = 14478683;
        nArray[81] = 5939616;
        nArray[82] = 5650518;
        nArray[83] = 13661357;
        nArray[84] = 5180346;
        nArray[85] = 13190977;
        nArray[86] = 12967607;
        nArray[87] = 4428364;
        nArray[88] = 8219746;
        nArray[89] = 16457881;
        nArray[90] = 16234863;
        nArray[91] = 7468436;
        nArray[92] = 15633027;
        nArray[93] = 6866552;
        nArray[94] = 6578062;
        nArray[95] = 14816117;
        nArray[96] = 1405499;
        nArray[97] = 9649856;
        nArray[98] = 10463030;
        nArray[99] = 1698765;
        nArray[100] = 8819930;
        nArray[101] = 55329;
        nArray[102] = 803287;
        nArray[103] = 9047340;
        nArray[104] = 11858690;
        nArray[105] = 3325945;
        nArray[106] = 4072975;
        nArray[107] = 12086004;
        nArray[108] = 2561507;
        nArray[109] = 10574104;
        nArray[110] = 11387118;
        nArray[111] = 2853909;
        nArray[112] = 13647026;
        nArray[113] = 5664841;
        nArray[114] = 5958079;
        nArray[115] = 14460228;
        nArray[116] = 4446803;
        nArray[117] = 12949160;
        nArray[118] = 13176670;
        nArray[119] = 5194661;
        nArray[120] = 7454091;
        nArray[121] = 16249200;
        nArray[122] = 16476294;
        nArray[123] = 8201341;
        nArray[124] = 14834538;
        nArray[125] = 6559633;
        nArray[126] = 6852199;
        nArray[127] = 15647388;
        nArray[128] = 3360676;
        nArray[129] = 11864927;
        nArray[130] = 12161705;
        nArray[131] = 4185682;
        nArray[132] = 10527045;
        nArray[133] = 2551230;
        nArray[134] = 2782280;
        nArray[135] = 11286707;
        nArray[136] = 9619101;
        nArray[137] = 1346150;
        nArray[138] = 1577872;
        nArray[139] = 10379115;
        nArray[140] = 73852;
        nArray[141] = 8875143;
        nArray[142] = 9172337;
        nArray[143] = 899466;
        nArray[144] = 16124205;
        nArray[145] = 7357910;
        nArray[146] = 8182816;
        nArray[147] = 16421083;
        nArray[148] = 6680524;
        nArray[149] = 14918455;
        nArray[150] = 15678145;
        nArray[151] = 6911546;
        nArray[152] = 5736468;
        nArray[153] = 13747439;
        nArray[154] = 14507289;
        nArray[155] = 5968354;
        nArray[156] = 12873461;
        nArray[157] = 4334094;
        nArray[158] = 5159928;
        nArray[159] = 13170435;
        nArray[160] = 4167245;
        nArray[161] = 12180150;
        nArray[162] = 11879232;
        nArray[163] = 3346363;
        nArray[164] = 11301036;
        nArray[165] = 2767959;
        nArray[166] = 2532769;
        nArray[167] = 10545498;
        nArray[168] = 10360692;
        nArray[169] = 1596303;
        nArray[170] = 1360505;
        nArray[171] = 9604738;
        nArray[172] = 913813;
        nArray[173] = 9157998;
        nArray[174] = 8856728;
        nArray[175] = 92259;
        nArray[176] = 16439492;
        nArray[177] = 8164415;
        nArray[178] = 7343561;
        nArray[179] = 16138546;
        nArray[180] = 6897189;
        nArray[181] = 15692510;
        nArray[182] = 14936872;
        nArray[183] = 6662099;
        nArray[184] = 5986813;
        nArray[185] = 14488838;
        nArray[186] = 13733104;
        nArray[187] = 5750795;
        nArray[188] = 13156124;
        nArray[189] = 5174247;
        nArray[190] = 4352529;
        nArray[191] = 12855018;
        nArray[192] = 2810998;
        nArray[193] = 11315341;
        nArray[194] = 10498427;
        nArray[195] = 2522496;
        nArray[196] = 12124823;
        nArray[197] = 4148844;
        nArray[198] = 3397530;
        nArray[199] = 11901793;
        nArray[200] = 9135439;
        nArray[201] = 862644;
        nArray[202] = 110658;
        nArray[203] = 8912057;
        nArray[204] = 1606574;
        nArray[205] = 10407765;
        nArray[206] = 9590435;
        nArray[207] = 1317464;
        nArray[208] = 0xEFAAFF;
        nArray[209] = 6940164;
        nArray[210] = 6651890;
        nArray[211] = 14889737;
        nArray[212] = 8145950;
        nArray[213] = 16384229;
        nArray[214] = 16161043;
        nArray[215] = 7394792;
        nArray[216] = 5123014;
        nArray[217] = 13133629;
        nArray[218] = 12910283;
        nArray[219] = 4370992;
        nArray[220] = 14535975;
        nArray[221] = 5997020;
        nArray[222] = 5707818;
        nArray[223] = 13718737;
        nArray[224] = 2504095;
        nArray[225] = 10516836;
        nArray[226] = 11329682;
        nArray[227] = 2796649;
        nArray[228] = 11916158;
        nArray[229] = 3383173;
        nArray[230] = 4130419;
        nArray[231] = 12143240;
        nArray[232] = 8893606;
        nArray[233] = 129117;
        nArray[234] = 876971;
        nArray[235] = 9121104;
        nArray[236] = 1331783;
        nArray[237] = 9576124;
        nArray[238] = 10389322;
        nArray[239] = 1625009;
        nArray[240] = 14908182;
        nArray[241] = 6633453;
        nArray[242] = 6925851;
        nArray[243] = 15721184;
        nArray[244] = 7380471;
        nArray[245] = 16175372;
        nArray[246] = 16402682;
        nArray[247] = 8127489;
        nArray[248] = 4389423;
        nArray[249] = 12891860;
        nArray[250] = 13119266;
        nArray[251] = 5137369;
        nArray[252] = 13704398;
        nArray[253] = 5722165;
        nArray[254] = 6015427;
        nArray[255] = 14517560;
        int[] tbl_CRC24Q = nArray;
        int crc = 0;
        int i = 0;
        while (i < len) {
            crc = crc << 8 & 0xFFFFFF ^ tbl_CRC24Q[(crc >> 16 ^ buff[i]) & 0xFF];
            ++i;
        }
        return crc &= 0xFFFFFF;
    }

    public static int getbitu(byte[] buff, int pos, int len) {
        int bits = 0;
        int i = pos;
        while (i < pos + len) {
            bits = (bits << 1) + (buff[i / 8] >>> 7 - i % 8 & 1);
            ++i;
        }
        return bits;
    }

    private static int getbits(byte[] buff, int pos, int len) {
        int bits = 0;
        bits = buff[pos / 8] >> 7 - pos % 8 & 1;
        if (bits != 0) {
            bits = -1;
        }
        int i = pos;
        while (i < pos + len) {
            bits = (bits << 1) + (buff[i / 8] >> 7 - i % 8 & 1);
            ++i;
        }
        return bits;
    }

    public static int decode_msgtype(SBASMessageType sbsmsg, SBASCorrectionsType sbscorr, SBASDegradationsType sbsdegr, SBASEphemerisType sbseph, SBASAlmanacsType sbsalm, SBASIonosphericType sbsion, SBASTimeType sbstime, SBASServiceType sbsserv, SBASCovarianceType sbscov) {
        int ret = 0;
        switch (sbsmsg.message[1] >>> 2 & 0x3F) {
            case 0: {
                ret = Sisnet.decode_mt2(sbsmsg, sbscorr);
                break;
            }
            case 1: {
                ret = Sisnet.decode_mt1(sbsmsg, sbscorr);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                ret = Sisnet.decode_mt2(sbsmsg, sbscorr);
                break;
            }
            case 6: {
                ret = Sisnet.decode_mt6(sbsmsg, sbscorr);
                break;
            }
            case 7: {
                ret = Sisnet.decode_mt7(sbsmsg, sbscorr);
                break;
            }
            case 9: {
                ret = Sisnet.decode_mt9(sbsmsg, sbseph);
                break;
            }
            case 10: {
                ret = Sisnet.decode_mt10(sbsmsg, sbsdegr);
                break;
            }
            case 12: {
                ret = Sisnet.decode_mt12(sbsmsg, sbstime);
                break;
            }
            case 17: {
                ret = Sisnet.decode_mt17(sbsmsg, sbsalm);
                break;
            }
            case 18: {
                ret = Sisnet.decode_mt18(sbsmsg, sbsion);
                break;
            }
            case 24: {
                ret = Sisnet.decode_mt24(sbsmsg, sbscorr);
                break;
            }
            case 25: {
                ret = Sisnet.decode_mt25(sbsmsg, sbscorr);
                break;
            }
            case 26: {
                ret = Sisnet.decode_mt26(sbsmsg, sbsion);
                break;
            }
            case 27: {
                ret = Sisnet.decode_mt27(sbsmsg, sbsserv);
                break;
            }
            case 28: {
                ret = Sisnet.decode_mt28(sbsmsg, sbscov, sbscorr);
                break;
            }
            case 62: 
            case 63: {
                break;
            }
            default: {
                System.out.printf("Unknown message type\r\n", new Object[0]);
            }
        }
        return ret;
    }

    private static int decode_mt1(SBASMessageType sbsmsg, SBASCorrectionsType sbscorr) {
        int i = 1;
        int n = 0;
        while (i <= 210 && n < 51) {
            int tmp = Sisnet.getbitu(sbsmsg.message, 13 + i, 1);
            if (tmp != 0) {
                int sat;
                if (i <= 37) {
                    sat = i;
                } else if (i <= 61) {
                    sat = i;
                } else if (i <= 119) {
                    sat = 0;
                } else if (i <= 138) {
                    sat = i;
                    sbsmsg.PRN = (short)sat;
                } else {
                    sat = i <= 182 ? 0 : (i <= 192 ? 0 : (i <= 202 ? 0 : 0));
                }
                int n2 = n;
                n = (short)(n2 + 1);
                sbscorr.PRN[n2] = sat;
            }
            i = (short)(i + 1);
        }
        sbscorr.IODP = (byte)Sisnet.getbitu(sbsmsg.message, 224, 2);
        sbscorr.numSat = (short)n;
        return 0;
    }

    private static int decode_mt2(SBASMessageType sbsmsg, SBASCorrectionsType sbscorr) {
        if (sbscorr.IODP != (byte)Sisnet.getbitu(sbsmsg.message, 16, 2)) {
            return 0;
        }
        long t = ((long)sbsmsg.week * 604800L + (long)sbsmsg.TOW) * 1000L;
        int type = sbsmsg.message[1] >>> 2 & 0x3F;
        if (type == 0) {
            type = 2;
        }
        byte IODF = (byte)Sisnet.getbitu(sbsmsg.message, 14, 2);
        short j = (short)(13 * (type - 2));
        int i = 0;
        while (i < 13 && j < sbscorr.numSat) {
            sbscorr.fastCorr_t0[j] = t;
            sbscorr.fastCorr_PRC[j] = (double)Sisnet.getbits(sbsmsg.message, 18 + i * 12, 12) * 0.125;
            sbscorr.fastCorr_UDREI[j] = (byte)(Sisnet.getbitu(sbsmsg.message, 174 + i * 4, 4) + 1);
            sbscorr.fastCorr_IODF[j] = IODF;
            i = (short)(i + 1);
            j = (short)(j + 1);
        }
        return 0;
    }

    private static int decode_mt6(SBASMessageType sbsmsg, SBASCorrectionsType sbscorr) {
        byte[] IODF = new byte[4];
        short i = 0;
        while (i < 4) {
            IODF[i] = (byte)Sisnet.getbitu(sbsmsg.message, 14 + i * 2, 2);
            i = (short)(i + 1);
        }
        i = 0;
        while (i < sbscorr.numSat) {
            if (sbscorr.fastCorr_IODF[i] == IODF[i / 13]) {
                sbscorr.fastCorr_UDREI[i] = (byte)(Sisnet.getbitu(sbsmsg.message, 22 + i * 4, 4) + 1);
            }
            i = (short)(i + 1);
        }
        return 0;
    }

    private static int decode_mt7(SBASMessageType sbsmsg, SBASCorrectionsType sbscorr) {
        if (sbscorr.IODP != (byte)Sisnet.getbitu(sbsmsg.message, 18, 2)) {
            return 0;
        }
        sbscorr.tlat = Sisnet.getbitu(sbsmsg.message, 14, 4);
        short i = 0;
        while (i < sbscorr.numSat) {
            sbscorr.fastCorr_AI[i] = (byte)Sisnet.getbitu(sbsmsg.message, 22 + i * 4, 4);
            i = (short)(i + 1);
        }
        return 0;
    }

    private static int decode_mt9(SBASMessageType sbsmsg, SBASEphemerisType sbseph) {
        sbseph.PRN = sbsmsg.PRN;
        long t = (long)Sisnet.getbitu(sbsmsg.message, 22, 13) * 16L;
        sbseph.t0 = t * 1000L;
        sbseph.TOF = ((long)sbsmsg.week * 604800L + (long)sbsmsg.TOW) * 1000L;
        sbseph.SVaccuracy = (byte)Sisnet.getbitu(sbsmsg.message, 35, 4);
        sbseph.SVhealth = sbseph.SVaccuracy == 15 ? (byte)1 : 0;
        sbseph.PositionX = (double)Sisnet.getbits(sbsmsg.message, 39, 30) * 0.08;
        sbseph.PositionY = (double)Sisnet.getbits(sbsmsg.message, 69, 30) * 0.08;
        sbseph.PositionZ = (double)Sisnet.getbits(sbsmsg.message, 99, 25) * 0.4;
        sbseph.VelocityX = (double)Sisnet.getbits(sbsmsg.message, 124, 17) * 6.25E-4;
        sbseph.VelocityY = (double)Sisnet.getbits(sbsmsg.message, 141, 17) * 6.25E-4;
        sbseph.VelocityZ = (double)Sisnet.getbits(sbsmsg.message, 158, 18) * 0.004;
        sbseph.AccelerationX = (double)Sisnet.getbits(sbsmsg.message, 176, 10) * 1.25E-5;
        sbseph.AccelerationY = (double)Sisnet.getbits(sbsmsg.message, 186, 10) * 1.25E-5;
        sbseph.AccelerationZ = (double)Sisnet.getbits(sbsmsg.message, 196, 10) * 6.25E-5;
        sbseph.Af0 = (double)Sisnet.getbits(sbsmsg.message, 206, 12) * 4.656612873077393E-10;
        sbseph.Af1 = (double)Sisnet.getbits(sbsmsg.message, 218, 8) * 1.818989403545856E-12 / 2.0;
        return 0;
    }

    private static int decode_mt10(SBASMessageType sbsmsg, SBASDegradationsType sbsdegr) {
        sbsdegr.Brrc = (float)Sisnet.getbitu(sbsmsg.message, 14, 10) * 0.002f;
        sbsdegr.Cltc_lsb = (float)Sisnet.getbitu(sbsmsg.message, 24, 10) * 0.002f;
        sbsdegr.Cltc_v1 = (float)Sisnet.getbitu(sbsmsg.message, 34, 10) * 5.0E-5f;
        sbsdegr.Iltc_v1 = (short)Sisnet.getbitu(sbsmsg.message, 44, 9);
        sbsdegr.Cltc_v0 = (float)Sisnet.getbitu(sbsmsg.message, 53, 10) * 0.002f;
        sbsdegr.Iltc_v0 = (short)Sisnet.getbitu(sbsmsg.message, 63, 9);
        sbsdegr.Cgeo_lsb = (float)Sisnet.getbitu(sbsmsg.message, 72, 10) * 5.0E-4f;
        sbsdegr.Cgeo_v = (float)Sisnet.getbitu(sbsmsg.message, 82, 10) * 5.0E-5f;
        sbsdegr.Igeo = (short)Sisnet.getbitu(sbsmsg.message, 92, 9);
        sbsdegr.Cer = (float)Sisnet.getbitu(sbsmsg.message, 101, 6) * 0.5f;
        sbsdegr.Ciono_step = (float)Sisnet.getbitu(sbsmsg.message, 107, 10) * 0.001f;
        sbsdegr.Iiono = (short)Sisnet.getbitu(sbsmsg.message, 117, 9);
        sbsdegr.Ciono_ramp = (float)Sisnet.getbitu(sbsmsg.message, 126, 10) * 5.0E-6f;
        sbsdegr.RSSudre = (byte)Sisnet.getbitu(sbsmsg.message, 136, 1);
        sbsdegr.RSSiono = (byte)Sisnet.getbitu(sbsmsg.message, 137, 1);
        sbsdegr.Ccovariance = (float)Sisnet.getbitu(sbsmsg.message, 138, 7) * 0.1f;
        return 0;
    }

    private static int decode_mt12(SBASMessageType sbsmsg, SBASTimeType sbstime) {
        sbstime.A1snt = (double)Sisnet.getbits(sbsmsg.message, 14, 24) * 8.881784197001252E-16;
        sbstime.A0snt = (double)Sisnet.getbits(sbsmsg.message, 38, 32) * 9.313225746154785E-10;
        sbstime.t0t = Sisnet.getbitu(sbsmsg.message, 70, 8) * 4096;
        sbstime.WNt = (short)Sisnet.getbitu(sbsmsg.message, 78, 8);
        sbstime.DTls = (short)Sisnet.getbits(sbsmsg.message, 86, 8);
        sbstime.WNlsf = (short)Sisnet.getbitu(sbsmsg.message, 94, 8);
        sbstime.DN = (short)Sisnet.getbitu(sbsmsg.message, 102, 8);
        sbstime.DTlsf = (short)Sisnet.getbits(sbsmsg.message, 110, 8);
        sbstime.UTC = (byte)Sisnet.getbitu(sbsmsg.message, 118, 3);
        sbstime.TOW = Sisnet.getbitu(sbsmsg.message, 121, 20);
        sbstime.WN = Sisnet.getbitu(sbsmsg.message, 141, 10);
        sbstime.GLO = (byte)Sisnet.getbitu(sbsmsg.message, 151, 1);
        sbstime.aiglonass = (double)Sisnet.getbits(sbsmsg.message, 152, 32) * 9.313225746154785E-10;
        return 0;
    }

    private static int decode_mt17(SBASMessageType sbsmsg, SBASAlmanacsType sbsalm) {
        int i = 0;
        while (i < 3) {
            sbsalm.ID[i] = (byte)Sisnet.getbitu(sbsmsg.message, 14 + i * 67, 2);
            sbsalm.PRN[i] = (short)Sisnet.getbitu(sbsmsg.message, 16 + i * 67, 8);
            sbsalm.Status[i] = (byte)Sisnet.getbitu(sbsmsg.message, 24 + i * 67, 8);
            sbsalm.PositionX[i] = Sisnet.getbits(sbsmsg.message, 32 + i * 67, 15) * 2600;
            sbsalm.PositionY[i] = Sisnet.getbits(sbsmsg.message, 47 + i * 67, 15) * 2600;
            sbsalm.PositionZ[i] = Sisnet.getbits(sbsmsg.message, 62 + i * 67, 9);
            sbsalm.VelocityX[i] = Sisnet.getbits(sbsmsg.message, 71 + i * 67, 3);
            sbsalm.VelocityY[i] = Sisnet.getbits(sbsmsg.message, 74 + i * 67, 3);
            sbsalm.VelocityZ[i] = Sisnet.getbits(sbsmsg.message, 77 + i * 67, 4);
            i = (short)(i + 1);
        }
        sbsalm.TOF = (long)Sisnet.getbitu(sbsmsg.message, 215, 11) * 1000L;
        return 0;
    }

    private static int decode_mt18(SBASMessageType sbsmsg, SBASIonosphericType sbsion) {
        byte[] byArray = new byte[29];
        byArray[0] = -85;
        byArray[1] = -75;
        byArray[2] = -65;
        byArray[3] = -55;
        byArray[4] = -50;
        byArray[5] = -45;
        byArray[6] = -40;
        byArray[7] = -35;
        byArray[8] = -30;
        byArray[9] = -25;
        byArray[10] = -20;
        byArray[11] = -15;
        byArray[12] = -10;
        byArray[13] = -5;
        byArray[15] = 5;
        byArray[16] = 10;
        byArray[17] = 15;
        byArray[18] = 20;
        byArray[19] = 25;
        byArray[20] = 30;
        byArray[21] = 35;
        byArray[22] = 40;
        byArray[23] = 45;
        byArray[24] = 50;
        byArray[25] = 55;
        byArray[26] = 65;
        byArray[27] = 75;
        byArray[28] = 85;
        byte[] IGPband11 = byArray;
        byte[][] byArrayArray = new byte[9][];
        byArrayArray[0] = new byte[]{1, 3, 1, 3, 1, 3, 1, 3};
        byte[] byArray2 = new byte[8];
        byArray2[1] = 3;
        byArray2[2] = 1;
        byArray2[3] = 3;
        byArray2[4] = 1;
        byArray2[5] = 3;
        byArray2[6] = 1;
        byArray2[7] = 3;
        byArrayArray[1] = byArray2;
        byArrayArray[2] = new byte[]{1, 3, 1, 3, 1, 3, 1, 3};
        byte[] byArray3 = new byte[8];
        byArray3[0] = 1;
        byArray3[1] = 3;
        byArray3[3] = 3;
        byArray3[4] = 1;
        byArray3[5] = 3;
        byArray3[6] = 1;
        byArray3[7] = 3;
        byArrayArray[3] = byArray3;
        byArrayArray[4] = new byte[]{1, 3, 1, 3, 1, 3, 1, 3};
        byte[] byArray4 = new byte[8];
        byArray4[0] = 1;
        byArray4[1] = 3;
        byArray4[2] = 1;
        byArray4[3] = 3;
        byArray4[5] = 3;
        byArray4[6] = 1;
        byArray4[7] = 3;
        byArrayArray[5] = byArray4;
        byArrayArray[6] = new byte[]{1, 3, 1, 3, 1, 3, 1, 3};
        byte[] byArray5 = new byte[8];
        byArray5[0] = 1;
        byArray5[1] = 3;
        byArray5[2] = 1;
        byArray5[3] = 3;
        byArray5[4] = 1;
        byArray5[5] = 3;
        byArray5[7] = 3;
        byArrayArray[7] = byArray5;
        byArrayArray[8] = new byte[]{1, 3, 1, 3, 1, 3, 1, 3};
        byte[][] IGPband12 = byArrayArray;
        short[][] IGPband13 = new short[][]{{28, 51, 78, 101, 128, 151, 178, 201}, {28, 51, 78, 101, 128, 151, 178, 201}, {27, 50, 78, 101, 128, 151, 178, 201}, {27, 50, 78, 101, 128, 151, 178, 201}, {27, 50, 77, 100, 128, 151, 178, 201}, {27, 50, 77, 100, 128, 151, 178, 201}, {27, 50, 77, 100, 127, 150, 178, 201}, {27, 50, 77, 100, 127, 150, 178, 201}, {27, 50, 77, 100, 127, 150, 177, 200}};
        short[][] IGPband2 = new short[][]{{72, 60, -180, 5, 108, 65, -180, 10, 144, 70, -180, 10, 180, 75, -180, 10, 192, 85, -180, 30}, {72, -60, -180, 5, 108, -65, -180, 10, 144, -70, -180, 10, 180, -75, -180, 10, 192, -85, -170, 30}};
        byte band = (byte)Sisnet.getbitu(sbsmsg.message, 18, 4);
        sbsion.IODI[band] = (byte)Sisnet.getbitu(sbsmsg.message, 22, 2);
        short n = 0;
        int m = 0;
        if (band >= 0 && band <= 8) {
            short k = IGPband12[band][m];
            short i = 1;
            while (i <= 201) {
                short j;
                if (i > IGPband13[band][m]) {
                    if ((m = (int)((short)(m + 1))) > 7) break;
                    k = IGPband12[band][m];
                }
                if ((j = (short)Sisnet.getbitu(sbsmsg.message, 23 + i, 1)) != 0) {
                    sbsion.IGP_number[band][n] = (short)(band * 201 + i - 1);
                    sbsion.IGP_latitude[band][n] = IGPband11[k];
                    short s = n;
                    n = (short)(s + 1);
                    sbsion.IGP_longitude[band][s] = (short)(-180 + (band * 8 + m) * 5);
                }
                i = (short)(i + 1);
                k = (short)(k + 1);
            }
        } else if (9 <= band && band <= 10) {
            int k = 0;
            short i = 1;
            while (i <= 192) {
                short j;
                if (i > IGPband2[band - 9][m * 4]) {
                    if ((m = (int)((short)(m + 1))) > 4) break;
                    k = 0;
                }
                if ((j = (short)Sisnet.getbitu(sbsmsg.message, 23 + i, 1)) != 0) {
                    sbsion.IGP_number[band][n] = (short)(1807 + (band - 9) * 192 + i);
                    sbsion.IGP_latitude[band][n] = IGPband2[band - 9][m * 4 + 1];
                    short s = n;
                    n = (short)(s + 1);
                    sbsion.IGP_longitude[band][s] = (short)(IGPband2[band - 9][m * 4 + 2] + IGPband2[band - 9][m * 4 + 3] * k);
                }
                i = (short)(i + 1);
                k = (short)(k + 1);
            }
        } else {
            return 0;
        }
        sbsion.numIGP[band] = n;
        return 0;
    }

    private static int decode_longcorr0(SBASMessageType sbsmsg, int p, SBASCorrectionsType sbscorr) {
        byte n = (byte)Sisnet.getbitu(sbsmsg.message, p, 6);
        if (n == 0 || n > 51) {
            return 0;
        }
        sbscorr.longCorr_IODE[n - 1] = (short)Sisnet.getbitu(sbsmsg.message, p + 6, 8);
        sbscorr.longCorr_dPositionX[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 14, 9) * 0.125;
        sbscorr.longCorr_dPositionY[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 23, 9) * 0.125;
        sbscorr.longCorr_dPositionZ[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 32, 9) * 0.125;
        sbscorr.longCorr_dVelocityX[n - 1] = 0.0;
        sbscorr.longCorr_dVelocityY[n - 1] = 0.0;
        sbscorr.longCorr_dVelocityZ[n - 1] = 0.0;
        sbscorr.longCorr_dAf0[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 41, 10) * 4.656612873077393E-10;
        sbscorr.longCorr_dAf1[n - 1] = 0.0;
        sbscorr.longCorr_t0[n - 1] = ((long)sbsmsg.week * 604800L + (long)sbsmsg.TOW) * 1000L;
        return 0;
    }

    private static int decode_longcorr1(SBASMessageType sbsmsg, int p, SBASCorrectionsType sbscorr) {
        byte n = (byte)Sisnet.getbitu(sbsmsg.message, p, 6);
        if (n == 0 || n > 51) {
            return 0;
        }
        sbscorr.longCorr_IODE[n - 1] = (short)Sisnet.getbitu(sbsmsg.message, p + 6, 8);
        sbscorr.longCorr_dPositionX[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 14, 11) * 0.125;
        sbscorr.longCorr_dPositionY[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 25, 11) * 0.125;
        sbscorr.longCorr_dPositionZ[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 36, 11) * 0.125;
        sbscorr.longCorr_dVelocityX[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 58, 8) * 4.8828125E-4;
        sbscorr.longCorr_dVelocityY[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 66, 8) * 4.8828125E-4;
        sbscorr.longCorr_dVelocityZ[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 74, 8) * 4.8828125E-4;
        sbscorr.longCorr_dAf0[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 47, 11) * 4.656612873077393E-10;
        sbscorr.longCorr_dAf1[n - 1] = (double)Sisnet.getbits(sbsmsg.message, p + 82, 8) * 1.818989403545856E-12;
        long t = (long)Sisnet.getbitu(sbsmsg.message, p + 90, 13) * 16L - (long)sbsmsg.TOW % 86400L;
        if (t <= -43200L) {
            t += 86400L;
        } else if (t > 43200L) {
            t -= 86400L;
        }
        sbscorr.longCorr_t0[n - 1] = ((long)sbsmsg.week * 604800L + (long)sbsmsg.TOW + t) * 1000L;
        return 0;
    }

    private static int decode_longcorrh(SBASMessageType sbsmsg, int p, SBASCorrectionsType sbscorr) {
        if (Sisnet.getbitu(sbsmsg.message, p, 1) == 0) {
            if (sbscorr.IODP == (byte)Sisnet.getbitu(sbsmsg.message, p + 103, 2)) {
                Sisnet.decode_longcorr0(sbsmsg, p + 1, sbscorr);
                Sisnet.decode_longcorr0(sbsmsg, p + 52, sbscorr);
                return 0;
            }
        } else if (sbscorr.IODP == (byte)Sisnet.getbitu(sbsmsg.message, p + 104, 2)) {
            Sisnet.decode_longcorr1(sbsmsg, p + 1, sbscorr);
            return 0;
        }
        return 0;
    }

    private static int decode_mt24(SBASMessageType sbsmsg, SBASCorrectionsType sbscorr) {
        if (sbscorr.IODP != (byte)Sisnet.getbitu(sbsmsg.message, 110, 2)) {
            return 0;
        }
        byte IODF = (byte)Sisnet.getbitu(sbsmsg.message, 114, 2);
        short j = (short)(Sisnet.getbitu(sbsmsg.message, 112, 2) * 13);
        int i = 0;
        while (i < 6 && j < sbscorr.numSat) {
            sbscorr.fastCorr_t0[j] = ((long)sbsmsg.week * 604800L + (long)sbsmsg.TOW) * 1000L;
            sbscorr.fastCorr_PRC[j] = (double)Sisnet.getbits(sbsmsg.message, 14 + i * 12, 12) * 0.125;
            sbscorr.fastCorr_UDREI[j] = (byte)(Sisnet.getbitu(sbsmsg.message, 86 + i * 4, 4) + 1);
            sbscorr.fastCorr_IODF[j] = IODF;
            i = (short)(i + 1);
            j = (short)(j + 1);
        }
        Sisnet.decode_longcorrh(sbsmsg, 120, sbscorr);
        return 0;
    }

    private static int decode_mt25(SBASMessageType sbsmsg, SBASCorrectionsType sbscorr) {
        Sisnet.decode_longcorrh(sbsmsg, 14, sbscorr);
        Sisnet.decode_longcorrh(sbsmsg, 120, sbscorr);
        return 0;
    }

    private static int decode_mt26(SBASMessageType sbsmsg, SBASIonosphericType sbsion) {
        byte band = (byte)Sisnet.getbitu(sbsmsg.message, 14, 4);
        if (band > 10 || sbsion.IODI[band] != (byte)Sisnet.getbitu(sbsmsg.message, 217, 2)) {
            return 0;
        }
        long t = ((long)sbsmsg.week * 604800L + (long)sbsmsg.TOW) * 1000L;
        short j = (short)(Sisnet.getbitu(sbsmsg.message, 18, 4) * 15);
        int i = 0;
        while (i < 15 && j < sbsion.numIGP[band]) {
            double delay = Sisnet.getbitu(sbsmsg.message, 22 + i * 13, 9);
            sbsion.IGP_t0[band][j] = t;
            sbsion.IGP_delay[band][j] = delay == 511.0 ? 0.0 : delay * 0.125;
            sbsion.IGP_GIVEI[band][j] = (byte)(Sisnet.getbitu(sbsmsg.message, 31 + i * 13, 4) + 1);
            i = (short)(i + 1);
            j = (short)(j + 1);
        }
        return 0;
    }

    private static int decode_mt27(SBASMessageType sbsmsg, SBASServiceType sbsserv) {
        sbsserv.IODS = (byte)Sisnet.getbitu(sbsmsg.message, 14, 3);
        sbsserv.numServiceMsg = (byte)Sisnet.getbitu(sbsmsg.message, 17, 3);
        sbsserv.ServiceMsgNumber = (byte)Sisnet.getbitu(sbsmsg.message, 20, 3);
        sbsserv.numRegion = (byte)Sisnet.getbitu(sbsmsg.message, 23, 3);
        sbsserv.priority = (byte)Sisnet.getbitu(sbsmsg.message, 26, 2);
        sbsserv.dUDREinside = (byte)Sisnet.getbitu(sbsmsg.message, 28, 4);
        sbsserv.dUDREoutside = (byte)Sisnet.getbitu(sbsmsg.message, 32, 4);
        int i = 0;
        while (i < 5) {
            sbsserv.latitude1[i] = (short)Sisnet.getbits(sbsmsg.message, 36 + i * 35, 8);
            sbsserv.longitude1[i] = (short)Sisnet.getbits(sbsmsg.message, 44 + i * 35, 9);
            sbsserv.latitude2[i] = (short)Sisnet.getbits(sbsmsg.message, 53 + i * 35, 8);
            sbsserv.longitude2[i] = (short)Sisnet.getbits(sbsmsg.message, 61 + i * 35, 9);
            sbsserv.FormRegion[i] = (byte)Sisnet.getbitu(sbsmsg.message, 70 + i * 35, 1);
            i = (short)(i + 1);
        }
        return 0;
    }

    private static int decode_mt28(SBASMessageType sbsmsg, SBASCovarianceType sbscov, SBASCorrectionsType sbscorr) {
        if (sbscorr.numSat != 0) {
            sbscov.IODP = (byte)Sisnet.getbitu(sbsmsg.message, 14, 2);
            int i = 0;
            while (i < 2) {
                byte n = (byte)Sisnet.getbitu(sbsmsg.message, 16 + i * 105, 6);
                sbscov.PRN[n] = sbscorr.PRN[n];
                sbscov.scale[n] = (byte)Sisnet.getbitu(sbsmsg.message, 22 + i * 105, 3);
                sbscov.E_1_1[n] = (short)Sisnet.getbitu(sbsmsg.message, 25 + i * 105, 9);
                sbscov.E_2_2[n] = (short)Sisnet.getbitu(sbsmsg.message, 34 + i * 105, 9);
                sbscov.E_3_3[n] = (short)Sisnet.getbitu(sbsmsg.message, 43 + i * 105, 9);
                sbscov.E_4_4[n] = (short)Sisnet.getbitu(sbsmsg.message, 52 + i * 105, 9);
                sbscov.E_1_2[n] = (short)Sisnet.getbits(sbsmsg.message, 61 + i * 105, 10);
                sbscov.E_1_3[n] = (short)Sisnet.getbits(sbsmsg.message, 71 + i * 105, 10);
                sbscov.E_1_4[n] = (short)Sisnet.getbits(sbsmsg.message, 81 + i * 105, 10);
                sbscov.E_2_3[n] = (short)Sisnet.getbits(sbsmsg.message, 91 + i * 105, 10);
                sbscov.E_2_4[n] = (short)Sisnet.getbits(sbsmsg.message, 101 + i * 105, 10);
                sbscov.E_3_4[n] = (short)Sisnet.getbits(sbsmsg.message, 111 + i * 105, 10);
                i = (short)(i + 1);
            }
        }
        return 0;
    }

    public static int view_msgtype(SBASMessageType sbsmsg, SBASCorrectionsType sbscorr, SBASDegradationsType sbsdegr, SBASEphemerisType sbseph, SBASAlmanacsType sbsalm, SBASIonosphericType sbsion, SBASTimeType sbstime, SBASServiceType sbsserv, SBASCovarianceType sbscov) {
        int ret = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        long t = 315954000000L;
        System.out.printf(String.valueOf(dateFormat.format(t += ((long)sbsmsg.week * 604800L + (long)sbsmsg.TOW) * 1000L)) + "\r\n", new Object[0]);
        switch (sbsmsg.message[1] >>> 2 & 0x3F) {
            case 0: {
                ret = Sisnet.view_mt2(sbscorr, (byte)2);
                break;
            }
            case 1: {
                ret = Sisnet.view_mt1(sbscorr);
                break;
            }
            case 2: {
                ret = Sisnet.view_mt2(sbscorr, (byte)2);
                break;
            }
            case 3: {
                ret = Sisnet.view_mt2(sbscorr, (byte)3);
                break;
            }
            case 4: {
                ret = Sisnet.view_mt2(sbscorr, (byte)4);
                break;
            }
            case 5: {
                ret = Sisnet.view_mt2(sbscorr, (byte)5);
                break;
            }
            case 6: {
                ret = Sisnet.view_mt6(sbscorr);
                break;
            }
            case 7: {
                ret = Sisnet.view_mt7(sbscorr);
                break;
            }
            case 9: {
                ret = Sisnet.view_mt9(sbseph);
                break;
            }
            case 10: {
                ret = Sisnet.view_mt10(sbsdegr);
                break;
            }
            case 12: {
                ret = Sisnet.view_mt12(sbstime);
                break;
            }
            case 17: {
                ret = Sisnet.view_mt17(sbsalm);
                break;
            }
            case 18: {
                ret = Sisnet.view_mt18(sbsion, sbsmsg);
                break;
            }
            case 24: {
                ret = Sisnet.view_mt24(sbscorr, sbsmsg);
                break;
            }
            case 25: {
                ret = Sisnet.view_mt25(sbscorr, sbsmsg);
                break;
            }
            case 26: {
                ret = Sisnet.view_mt26(sbsion, sbsmsg);
                break;
            }
            case 27: {
                ret = Sisnet.view_mt27(sbsserv);
                break;
            }
            case 28: {
                ret = Sisnet.view_mt28(sbscov);
                break;
            }
        }
        return ret;
    }

    private static int view_mt1(SBASCorrectionsType sbscorr) {
        int j = 0;
        int k = 0;
        System.out.printf("MT01 - prn masks\r\n", new Object[0]);
        System.out.printf("  NSAT=%2d  IODP=%1d\r\n", sbscorr.numSat, sbscorr.IODP);
        System.out.printf("  GPS PRN\r\n", new Object[0]);
        short i = 1;
        while (i <= 37) {
            if (sbscorr.PRN[k] == i) {
                System.out.printf("  %3d", i);
                k = (short)(k + 1);
            } else {
                System.out.printf("     ", new Object[0]);
            }
            if (i % 8 == 0) {
                System.out.printf("\r\n", new Object[0]);
            }
            i = (short)(i + 1);
        }
        System.out.printf("\r\n", new Object[0]);
        System.out.printf("  GLO PRN\r\n", new Object[0]);
        j = 1;
        while (i <= 61) {
            if (sbscorr.PRN[k] == i) {
                System.out.printf("  %3d", i - 37);
                if (k < 50) {
                    k = (short)(k + 1);
                }
            } else {
                System.out.printf("     ", new Object[0]);
            }
            if (j % 8 == 0) {
                System.out.printf("\r\n", new Object[0]);
            }
            i = (short)(i + 1);
            j = (short)(j + 1);
        }
        System.out.printf("\r\n", new Object[0]);
        System.out.printf("  Other PRN\r\n", new Object[0]);
        j = 1;
        while (i <= 210) {
            if (sbscorr.PRN[k] == i) {
                System.out.printf("  %3d", i);
                if (k < 50) {
                    k = (short)(k + 1);
                }
                if (j % 8 == 0) {
                    System.out.printf("\r\n", new Object[0]);
                }
                j = (short)(j + 1);
            }
            i = (short)(i + 1);
        }
        System.out.printf("\r\n", new Object[0]);
        return 0;
    }

    private static int view_mt2(SBASCorrectionsType sbscorr, byte type) {
        System.out.printf("MT%02d - fast corrections\r\n", type);
        short j = (short)(13 * (type - 2));
        if (j >= sbscorr.numSat) {
            return 3;
        }
        System.out.printf("  NSAT=%3d  IODF=%1d\r\n", sbscorr.numSat, sbscorr.fastCorr_IODF[j]);
        int i = 0;
        while (i < 13 && j < sbscorr.numSat) {
            System.out.printf("  PRN=%3d", sbscorr.PRN[j]);
            System.out.printf("  PRC=%8.3fm", sbscorr.fastCorr_PRC[j]);
            if (sbscorr.fastCorr_UDREI[j] != 0 && sbscorr.fastCorr_UDREI[j] < 15) {
                System.out.printf("  UDREI=%2d", sbscorr.fastCorr_UDREI[j] - 1);
            } else {
                System.out.printf("  UDREI=NM", new Object[0]);
            }
            System.out.printf("\r\n", new Object[0]);
            i = (short)(i + 1);
            j = (short)(j + 1);
        }
        return 0;
    }

    private static int view_mt6(SBASCorrectionsType sbscorr) {
        System.out.printf("MT06 - integrity info\r\n", new Object[0]);
        System.out.printf("  NSAT=%3d\r\n", sbscorr.numSat);
        short i = 0;
        while (i < sbscorr.numSat) {
            System.out.printf("  PRN=%3d", sbscorr.PRN[i]);
            if (sbscorr.fastCorr_UDREI[i] != 0 && sbscorr.fastCorr_UDREI[i] < 15) {
                System.out.printf("  UDREI=%2d", sbscorr.fastCorr_UDREI[i] - 1);
            } else {
                System.out.printf("  UDREI=NM", new Object[0]);
            }
            System.out.printf("\r\n", new Object[0]);
            i = (short)(i + 1);
        }
        return 0;
    }

    private static int view_mt7(SBASCorrectionsType sbscorr) {
        System.out.printf("MT07 - fast correction degradation factor\r\n", new Object[0]);
        System.out.printf("  NSAT=%3d  TLAT=%2ds\r\n", sbscorr.numSat, sbscorr.tlat);
        short i = 0;
        while (i < sbscorr.numSat) {
            System.out.printf("  PRN=%3d  AI=%2d\r\n", sbscorr.PRN[i], sbscorr.fastCorr_AI[i]);
            i = (short)(i + 1);
        }
        return 0;
    }

    private static int view_mt9(SBASEphemerisType sbseph) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        System.out.printf("MT09 - geo navigation message\r\n", new Object[0]);
        System.out.printf("  PRN=%3d", sbseph.PRN);
        System.out.printf("  URA=%2d", sbseph.SVaccuracy);
        long t = 315954000000L;
        System.out.printf("  TOF=" + dateFormat.format(t += sbseph.TOF), new Object[0]);
        System.out.printf("  t0=%ds\r\n", sbseph.t0 / 1000L);
        System.out.printf("  Px=%12.2fm", sbseph.PositionX);
        System.out.printf("  Py=%12.2fm", sbseph.PositionY);
        System.out.printf("  Pz=%9.1fm\r\n", sbseph.PositionZ);
        System.out.printf("  Vx=%12.6fm/s", sbseph.VelocityX);
        System.out.printf("  Vy=%12.6fm/s", sbseph.VelocityY);
        System.out.printf("  Vz=%9.3fm/s\r\n", sbseph.VelocityZ);
        System.out.printf("  Ax=%12.7fm/s^2", sbseph.AccelerationX);
        System.out.printf("  Ay=%12.7fm/s^2", sbseph.AccelerationY);
        System.out.printf("  Az=%9.7fm/s^2\r\n", sbseph.AccelerationZ);
        System.out.printf("  Af0=%12.9Es  Af1=%12.9Es/s\r\n", sbseph.Af0, sbseph.Af1);
        return 0;
    }

    private static int view_mt10(SBASDegradationsType sbsdegr) {
        System.out.printf("MT10 - degradation parameters\r\n", new Object[0]);
        System.out.printf("  Brrc=%5.3fm     Cltc_lsb=%5.3fm\r\n", Float.valueOf(sbsdegr.Brrc), Float.valueOf(sbsdegr.Cltc_lsb));
        System.out.printf("  Cltc_v1=%7.5fm/s  Iltc_v1=%3ds", Float.valueOf(sbsdegr.Cltc_v1), sbsdegr.Iltc_v1);
        System.out.printf("  Cltc_v0=%5.3fm  Iltc_v0=%3ds\r\n", Float.valueOf(sbsdegr.Cltc_v0), sbsdegr.Iltc_v0);
        System.out.printf("  Cgeo_lsb=%6.4fm    Cgeo_v=%7.5fm/s", Float.valueOf(sbsdegr.Cgeo_lsb), Float.valueOf(sbsdegr.Cgeo_v));
        System.out.printf("  Igeo=%3ds  Cer=%4.1fm\r\n", sbsdegr.Igeo, Float.valueOf(sbsdegr.Cer));
        System.out.printf("  Ciono_step=%5.3fm   Iiono=%3ds", Float.valueOf(sbsdegr.Ciono_step), sbsdegr.Iiono);
        System.out.printf("  Ciono_ramp=%8.6fm/s\r\n", Float.valueOf(sbsdegr.Ciono_ramp));
        System.out.printf("  RSSudre=%1d  RSSiono=%1d", sbsdegr.RSSudre, sbsdegr.RSSiono);
        System.out.printf("  Ccovariance=%4.1f\r\n", Float.valueOf(sbsdegr.Ccovariance));
        return 0;
    }

    private static int view_mt12(SBASTimeType sbstime) {
        System.out.printf("MT12 - network Time/UTC offset parameters\r\n", new Object[0]);
        System.out.printf("  A0snt=%12.9Es  A1snt=%12.9Es/s\r\n", sbstime.A0snt, sbstime.A1snt);
        System.out.printf("  t0t=%6ds  WNt=%3dweeks  DTls=%4ds\r\n", sbstime.t0t, sbstime.WNt, sbstime.DTls);
        System.out.printf("  WNlsf=%3dweeks  DN=%3ddays  DTlsf=%4ds\r\n", sbstime.WNlsf, sbstime.DN, sbstime.DTlsf);
        System.out.printf("  UTC=%1d  TOW=%6ds  WN=%4dweeks  GLO=%1d\r\n", sbstime.UTC, sbstime.TOW, sbstime.WN, sbstime.GLO);
        System.out.printf("  aiglonass=%12.9Es\r\n", sbstime.aiglonass);
        return 0;
    }

    private static int view_mt17(SBASAlmanacsType sbsalm) {
        System.out.printf("MT17 - geo almanacs message\r\n", new Object[0]);
        int i = 0;
        while (i < 3) {
            if (sbsalm.PRN[i] != 0) {
                System.out.printf("  PRN=%3d  ID=%1d", sbsalm.PRN[i], sbsalm.ID[i]);
                if ((sbsalm.Status[i] & 1) == 0) {
                    System.out.printf("  Ranging=Yes", new Object[0]);
                } else {
                    System.out.printf("  Ranging=No ", new Object[0]);
                }
                if ((sbsalm.Status[i] & 2) == 0) {
                    System.out.printf("  Corrections=Yes", new Object[0]);
                } else {
                    System.out.printf("  Corrections=No ", new Object[0]);
                }
                if ((sbsalm.Status[i] & 4) == 0) {
                    System.out.printf("  Integrity=Yes", new Object[0]);
                } else {
                    System.out.printf("  Integrity=No ", new Object[0]);
                }
                switch (sbsalm.Status[i] >>> 4 & 0xF) {
                    case 0: {
                        System.out.printf("  WAAS", new Object[0]);
                        break;
                    }
                    case 1: {
                        System.out.printf("  EGNOS", new Object[0]);
                        break;
                    }
                    case 2: {
                        System.out.printf("  MSAS", new Object[0]);
                        break;
                    }
                    case 3: {
                        System.out.printf("  GAGAN", new Object[0]);
                        break;
                    }
                    case 4: {
                        System.out.printf("  \u0421\u0414\u041a\u041c", new Object[0]);
                        break;
                    }
                }
                System.out.printf("\r\n", new Object[0]);
                System.out.printf("   Px=%9.0fm  ", sbsalm.PositionX[i]);
                System.out.printf("  Py=%9.0fm  ", sbsalm.PositionY[i]);
                System.out.printf("  Pz=%6.0fm\r\n", sbsalm.PositionZ[i]);
                System.out.printf("   Vx=%9.0fm/s", sbsalm.VelocityX[i]);
                System.out.printf("  Vy=%9.0fm/s", sbsalm.VelocityY[i]);
                System.out.printf("  Vz=%6.0fm/s\r\n", sbsalm.VelocityZ[i]);
            }
            i = (short)(i + 1);
        }
        return 0;
    }

    private static int view_mt18(SBASIonosphericType sbsion, SBASMessageType sbsmsg) {
        System.out.printf("MT18 - ionospheric grid point masks\r\n", new Object[0]);
        byte band = (byte)Sisnet.getbitu(sbsmsg.message, 18, 4);
        short longitude = band < 9 ? (short)((short)(-180 + band * 8 * 5)) : (short)-180;
        System.out.printf("  band=%2d  bandlongitude=%4d  numIGP=%3d\r\n", band, longitude, sbsion.numIGP[band]);
        short n = 0;
        int i = 0;
        while (i < 35) {
            short latitude = (short)(85 - i * 5);
            System.out.printf("  %3d ", latitude);
            int j = 0;
            while (j < 72) {
                longitude = (short)(-180 + j * 5);
                n = 0;
                while (n < sbsion.numIGP[band]) {
                    if (sbsion.IGP_latitude[band][n] == latitude && sbsion.IGP_longitude[band][n] == longitude) {
                        if (sbsion.IGP_GIVEI[band][n] == 0) {
                            System.out.printf("*", new Object[0]);
                            break;
                        }
                        if (sbsion.IGP_GIVEI[band][n] > 15) {
                            System.out.printf("-", new Object[0]);
                            break;
                        }
                        System.out.printf("+", new Object[0]);
                        break;
                    }
                    n = (short)(n + 1);
                }
                if (n >= sbsion.numIGP[band]) {
                    System.out.printf(".", new Object[0]);
                }
                j = (short)(j + 1);
            }
            System.out.printf("\r\n", new Object[0]);
            i = (short)(i + 1);
        }
        return 0;
    }

    private static int view_mt24(SBASCorrectionsType sbscorr, SBASMessageType sbsmsg) {
        System.out.printf("MT24 - mixed fast/long term correction\r\n", new Object[0]);
        short j = (short)(Sisnet.getbitu(sbsmsg.message, 112, 2) * 13);
        System.out.printf("  NSAT=%3d  IODF=%1d\r\n", sbscorr.numSat, sbscorr.fastCorr_IODF[j]);
        int i = 0;
        while (i < 6) {
            if (j >= sbscorr.numSat) break;
            System.out.printf("  PRN=%3d", sbscorr.PRN[j]);
            System.out.printf("  PRC=%8.3fm", sbscorr.fastCorr_PRC[j]);
            if (sbscorr.fastCorr_UDREI[j] != 0 && sbscorr.fastCorr_UDREI[j] < 15) {
                System.out.printf("  UDREI=%2d", sbscorr.fastCorr_UDREI[j] - 1);
            } else {
                System.out.printf("  UDREI=NM", new Object[0]);
            }
            System.out.printf("\r\n", new Object[0]);
            i = (short)(i + 1);
            j = (short)(j + 1);
        }
        System.out.printf("\r\n", new Object[0]);
        if (Sisnet.getbitu(sbsmsg.message, 120, 1) == 0) {
            if (sbscorr.IODP == (byte)Sisnet.getbitu(sbsmsg.message, 223, 2)) {
                short n = (short)Sisnet.getbitu(sbsmsg.message, 121, 6);
                if (n == 0 || n > 51) {
                    return 0;
                }
                System.out.printf("  PRN=%3d  IODE=%3d\r\n", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
                System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
                System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
                System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
                System.out.printf("    dAf0=%12.9Es\r\n", sbscorr.longCorr_dAf0[n - 1]);
                n = (short)Sisnet.getbitu(sbsmsg.message, 172, 6);
                if (n == 0 || n > 51) {
                    return 0;
                }
                System.out.printf("  PRN=%3d  IODE=%3d\r\n", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
                System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
                System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
                System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
                System.out.printf("    dAf0=%12.9Es\r\n", sbscorr.longCorr_dAf0[n - 1]);
            }
        } else if (sbscorr.IODP == (byte)Sisnet.getbitu(sbsmsg.message, 224, 2)) {
            short n = (short)Sisnet.getbitu(sbsmsg.message, 121, 6);
            if (n == 0 || n > 51) {
                return 0;
            }
            System.out.printf("  PRN=%3d  IODE=%3d\r\n", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
            System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
            System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
            System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
            System.out.printf("    dVx=%8.5fm/s", sbscorr.longCorr_dVelocityX[n - 1]);
            System.out.printf("  dVy=%8.5fm/s", sbscorr.longCorr_dVelocityY[n - 1]);
            System.out.printf("  dVz=%8.5fm/s\r\n", sbscorr.longCorr_dVelocityZ[n - 1]);
            System.out.printf("    dAf0=%12.9Es  dAf1=%12.9Es/s\r\n", sbscorr.longCorr_dAf0[n - 1], sbscorr.longCorr_dAf1[n - 1]);
        }
        return 0;
    }

    private static int view_mt25(SBASCorrectionsType sbscorr, SBASMessageType sbsmsg) {
        short n;
        System.out.printf("MT25 - long term satellite error correction\r\n", new Object[0]);
        if (Sisnet.getbitu(sbsmsg.message, 14, 1) == 0) {
            if (sbscorr.IODP == (byte)Sisnet.getbitu(sbsmsg.message, 117, 2)) {
                n = (short)Sisnet.getbitu(sbsmsg.message, 15, 6);
                if (n == 0 || n > 51) {
                    return 0;
                }
                System.out.printf("  PRN=%3d  IODE=%3d", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
                System.out.printf("  IODEV=%3ds", ((sbscorr.longCorr_IODE[n - 1] & 0x1F) + 1) * 30);
                System.out.printf("  IODEL=%3ds\r\n", (sbscorr.longCorr_IODE[n - 1] >>> 5 & 7) * 30);
                System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
                System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
                System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
                System.out.printf("    dAf0=%12.9Es\r\n", sbscorr.longCorr_dAf0[n - 1]);
                n = (short)Sisnet.getbitu(sbsmsg.message, 66, 6);
                if (n == 0 || n > 51) {
                    return 0;
                }
                System.out.printf("  PRN=%3d  IODE=%3d", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
                System.out.printf("  IODEV=%3ds", ((sbscorr.longCorr_IODE[n - 1] & 0x1F) + 1) * 30);
                System.out.printf("  IODEL=%3ds\r\n", (sbscorr.longCorr_IODE[n - 1] >>> 5 & 7) * 30);
                System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
                System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
                System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
                System.out.printf("    dAf0=%12.9Es\r\n", sbscorr.longCorr_dAf0[n - 1]);
            }
        } else if (sbscorr.IODP == (byte)Sisnet.getbitu(sbsmsg.message, 118, 2)) {
            n = (short)Sisnet.getbitu(sbsmsg.message, 15, 6);
            if (n == 0 || n > 51) {
                return 0;
            }
            System.out.printf("  PRN=%3d  IODE=%3d", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
            System.out.printf("  IODEV=%3ds", ((sbscorr.longCorr_IODE[n - 1] & 0x1F) + 1) * 30);
            System.out.printf("  IODEL=%3ds\r\n", (sbscorr.longCorr_IODE[n - 1] >>> 5 & 7) * 30);
            System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
            System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
            System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
            System.out.printf("    dVx=%8.5fm/s", sbscorr.longCorr_dVelocityX[n - 1]);
            System.out.printf("  dVy=%8.5fm/s", sbscorr.longCorr_dVelocityY[n - 1]);
            System.out.printf("  dVz=%8.5f m/s\r\n", sbscorr.longCorr_dVelocityZ[n - 1]);
            System.out.printf("    dAf0=%12.9Es  dAf1=%12.9Es/s\r\n", sbscorr.longCorr_dAf0[n - 1], sbscorr.longCorr_dAf1[n - 1]);
        }
        if (Sisnet.getbitu(sbsmsg.message, 120, 1) == 0) {
            if (sbscorr.IODP == (byte)Sisnet.getbitu(sbsmsg.message, 223, 2)) {
                n = (short)Sisnet.getbitu(sbsmsg.message, 121, 6);
                if (n == 0 || n > 51) {
                    return 0;
                }
                System.out.printf("  PRN=%3d  IODE=%3d", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
                System.out.printf("  IODEV=%3ds", ((sbscorr.longCorr_IODE[n - 1] & 0x1F) + 1) * 30);
                System.out.printf("  IODEL=%3ds\r\n", (sbscorr.longCorr_IODE[n - 1] >>> 5 & 7) * 30);
                System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
                System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
                System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
                System.out.printf("    dAf0=%12.9Es\r\n", sbscorr.longCorr_dAf0[n - 1]);
                n = (short)Sisnet.getbitu(sbsmsg.message, 172, 6);
                if (n == 0 || n > 51) {
                    return 0;
                }
                System.out.printf("  PRN=%3d  IODE=%3d", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
                System.out.printf("  IODEV=%3ds", ((sbscorr.longCorr_IODE[n - 1] & 0x1F) + 1) * 30);
                System.out.printf("  IODEL=%3ds\r\n", (sbscorr.longCorr_IODE[n - 1] >>> 5 & 7) * 30);
                System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
                System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
                System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
                System.out.printf("    dAf0=%12.9Es\r\n", sbscorr.longCorr_dAf0[n - 1]);
            }
        } else if (sbscorr.IODP == (byte)Sisnet.getbitu(sbsmsg.message, 224, 2)) {
            n = (short)Sisnet.getbitu(sbsmsg.message, 121, 6);
            if (n == 0 || n > 51) {
                return 0;
            }
            System.out.printf("  PRN=%3d  IODE=%3d", sbscorr.PRN[n - 1], sbscorr.longCorr_IODE[n - 1]);
            System.out.printf("  IODEV=%3ds", ((sbscorr.longCorr_IODE[n - 1] & 0x1F) + 1) * 30);
            System.out.printf("  IODEL=%3ds\r\n", (sbscorr.longCorr_IODE[n - 1] >>> 5 & 7) * 30);
            System.out.printf("    dPx=%8.3fm", sbscorr.longCorr_dPositionX[n - 1]);
            System.out.printf("  dPy=%8.3fm", sbscorr.longCorr_dPositionY[n - 1]);
            System.out.printf("  dPz=%8.3fm\r\n", sbscorr.longCorr_dPositionZ[n - 1]);
            System.out.printf("    dVx=%8.5fm/s", sbscorr.longCorr_dVelocityX[n - 1]);
            System.out.printf("  dVy=%8.5fm/s", sbscorr.longCorr_dVelocityY[n - 1]);
            System.out.printf("  dVz=%8.5fm/s\r\n", sbscorr.longCorr_dVelocityZ[n - 1]);
            System.out.printf("    dAf0=%12.9Es  dAf1=%12.9Es/s\r\n", sbscorr.longCorr_dAf0[n - 1], sbscorr.longCorr_dAf1[n - 1]);
        }
        return 0;
    }

    private static int view_mt26(SBASIonosphericType sbsion, SBASMessageType sbsmsg) {
        System.out.printf("MT26 - ionospheric delay corrections\r\n", new Object[0]);
        byte band = (byte)Sisnet.getbitu(sbsmsg.message, 14, 4);
        short j = (short)Sisnet.getbitu(sbsmsg.message, 18, 4);
        j = (short)(j * 15);
        int i = 0;
        while (i < 15) {
            if (j >= sbsion.numIGP[band]) break;
            System.out.printf("  IGP#=%4d  band=%2d  lat=%3ddeg", sbsion.IGP_number[band][j], band, sbsion.IGP_latitude[band][j]);
            System.out.printf("  lon=%4ddeg  delay=%6.3fm", sbsion.IGP_longitude[band][j], sbsion.IGP_delay[band][j]);
            if (sbsion.IGP_GIVEI[band][j] == 0 || sbsion.IGP_GIVEI[band][j] > 15) {
                System.out.printf("  GIVEI=NM", new Object[0]);
            } else {
                System.out.printf("  GIVEI=%2d", sbsion.IGP_GIVEI[band][j] - 1);
            }
            System.out.printf("\r\n", new Object[0]);
            i = (short)(i + 1);
            j = (short)(j + 1);
        }
        return 0;
    }

    private static int view_mt27(SBASServiceType sbsserv) {
        System.out.printf("MT27 - service message\r\n", new Object[0]);
        System.out.printf("  IODS=%1d  numServiceMsg=%1d", sbsserv.IODS, sbsserv.numServiceMsg + 1);
        System.out.printf("  ServiceMsgNumber=%1d\r\n", sbsserv.ServiceMsgNumber + 1);
        System.out.printf("  numRegion=%1d  priority=%1d", sbsserv.numRegion, sbsserv.priority);
        System.out.printf("  dUDREinside=%2d  dUDREoutside=%2d\r\n", sbsserv.dUDREinside, sbsserv.dUDREoutside);
        short i = 0;
        while (i < 5 && i < sbsserv.numRegion) {
            System.out.printf("  Region=%1d  latitude1=%3ddeg  longitude1=%4ddeg", i + 1, sbsserv.latitude1[i], sbsserv.longitude1[i]);
            System.out.printf("  latitude2=%3ddeg  longitude2=%4ddeg", sbsserv.latitude2[i], sbsserv.longitude2[i]);
            if (sbsserv.FormRegion[i] == 0) {
                System.out.printf("  triangle\r\n", new Object[0]);
            } else {
                System.out.printf("  square\r\n", new Object[0]);
            }
            i = (short)(i + 1);
        }
        return 0;
    }

    private static int view_mt28(SBASCovarianceType sbscov) {
        System.out.printf("MT28 - covariance matrix\r\n", new Object[0]);
        int i = 0;
        while (i < 51) {
            if (sbscov.PRN[i] != 0) {
                System.out.printf("  PRN=%3d  scale=%1d", sbscov.PRN[i], sbscov.scale[i]);
                System.out.printf("  E11=%-3d  E12=%-3d  ", sbscov.E_1_1[i], sbscov.E_1_2[i]);
                System.out.printf("  E13=%-3d  E14=%-3d", sbscov.E_1_3[i], sbscov.E_1_4[i]);
                System.out.printf("  E22=%-4d  E23=%-4d  E24=%-4d", sbscov.E_2_2[i], sbscov.E_2_3[i], sbscov.E_2_4[i]);
                System.out.printf("  E33=%-4d  E34=%-4d  E44=%-4d\r\n", sbscov.E_3_3[i], sbscov.E_3_4[i], sbscov.E_4_4[i]);
            }
            i = (short)(i + 1);
        }
        return 0;
    }

    public static class SBASAlmanacsType {
        byte[] ID = new byte[3];
        short[] PRN = new short[3];
        byte[] Status = new byte[3];
        double[] PositionX = new double[3];
        double[] PositionY = new double[3];
        double[] PositionZ = new double[3];
        double[] VelocityX = new double[3];
        double[] VelocityY = new double[3];
        double[] VelocityZ = new double[3];
        long TOF;
    }

    public static class SBASCorrectionsType {
        public byte IODP;
        short numSat;
        int tlat;
        short[] PRN = new short[51];
        long[] fastCorr_t0 = new long[51];
        byte[] fastCorr_IODF = new byte[51];
        double[] fastCorr_PRC = new double[51];
        byte[] fastCorr_UDREI = new byte[51];
        byte[] fastCorr_AI = new byte[51];
        long[] longCorr_t0 = new long[51];
        short[] longCorr_IODE = new short[51];
        double[] longCorr_dPositionX = new double[51];
        double[] longCorr_dPositionY = new double[51];
        double[] longCorr_dPositionZ = new double[51];
        double[] longCorr_dVelocityX = new double[51];
        double[] longCorr_dVelocityY = new double[51];
        double[] longCorr_dVelocityZ = new double[51];
        double[] longCorr_dAf0 = new double[51];
        double[] longCorr_dAf1 = new double[51];

        public byte getIODP() {
            return this.IODP;
        }

        public void setIODP(byte iODP) {
            this.IODP = iODP;
        }

        public short getNumSat() {
            return this.numSat;
        }

        public void setNumSat(short numSat) {
            this.numSat = numSat;
        }

        public int getTlat() {
            return this.tlat;
        }

        public void setTlat(int tlat) {
            this.tlat = tlat;
        }

        public short[] getPRN() {
            return this.PRN;
        }

        public void setPRN(short[] pRN) {
            this.PRN = pRN;
        }

        public long[] getFastCorr_t0() {
            return this.fastCorr_t0;
        }

        public void setFastCorr_t0(long[] fastCorr_t0) {
            this.fastCorr_t0 = fastCorr_t0;
        }

        public byte[] getFastCorr_IODF() {
            return this.fastCorr_IODF;
        }

        public void setFastCorr_IODF(byte[] fastCorr_IODF) {
            this.fastCorr_IODF = fastCorr_IODF;
        }

        public double[] getFastCorr_PRC() {
            return this.fastCorr_PRC;
        }

        public void setFastCorr_PRC(double[] fastCorr_PRC) {
            this.fastCorr_PRC = fastCorr_PRC;
        }

        public byte[] getFastCorr_UDREI() {
            return this.fastCorr_UDREI;
        }

        public void setFastCorr_UDREI(byte[] fastCorr_UDREI) {
            this.fastCorr_UDREI = fastCorr_UDREI;
        }

        public byte[] getFastCorr_AI() {
            return this.fastCorr_AI;
        }

        public void setFastCorr_AI(byte[] fastCorr_AI) {
            this.fastCorr_AI = fastCorr_AI;
        }

        public long[] getLongCorr_t0() {
            return this.longCorr_t0;
        }

        public void setLongCorr_t0(long[] longCorr_t0) {
            this.longCorr_t0 = longCorr_t0;
        }

        public short[] getLongCorr_IODE() {
            return this.longCorr_IODE;
        }

        public void setLongCorr_IODE(short[] longCorr_IODE) {
            this.longCorr_IODE = longCorr_IODE;
        }

        public double[] getLongCorr_dPositionX() {
            return this.longCorr_dPositionX;
        }

        public void setLongCorr_dPositionX(double[] longCorr_dPositionX) {
            this.longCorr_dPositionX = longCorr_dPositionX;
        }

        public double[] getLongCorr_dPositionY() {
            return this.longCorr_dPositionY;
        }

        public void setLongCorr_dPositionY(double[] longCorr_dPositionY) {
            this.longCorr_dPositionY = longCorr_dPositionY;
        }

        public double[] getLongCorr_dPositionZ() {
            return this.longCorr_dPositionZ;
        }

        public void setLongCorr_dPositionZ(double[] longCorr_dPositionZ) {
            this.longCorr_dPositionZ = longCorr_dPositionZ;
        }

        public double[] getLongCorr_dVelocityX() {
            return this.longCorr_dVelocityX;
        }

        public void setLongCorr_dVelocityX(double[] longCorr_dVelocityX) {
            this.longCorr_dVelocityX = longCorr_dVelocityX;
        }

        public double[] getLongCorr_dVelocityY() {
            return this.longCorr_dVelocityY;
        }

        public void setLongCorr_dVelocityY(double[] longCorr_dVelocityY) {
            this.longCorr_dVelocityY = longCorr_dVelocityY;
        }

        public double[] getLongCorr_dVelocityZ() {
            return this.longCorr_dVelocityZ;
        }

        public void setLongCorr_dVelocityZ(double[] longCorr_dVelocityZ) {
            this.longCorr_dVelocityZ = longCorr_dVelocityZ;
        }

        public double[] getLongCorr_dAf0() {
            return this.longCorr_dAf0;
        }

        public void setLongCorr_dAf0(double[] longCorr_dAf0) {
            this.longCorr_dAf0 = longCorr_dAf0;
        }

        public double[] getLongCorr_dAf1() {
            return this.longCorr_dAf1;
        }

        public void setLongCorr_dAf1(double[] longCorr_dAf1) {
            this.longCorr_dAf1 = longCorr_dAf1;
        }
    }

    public static class SBASCovarianceType {
        byte IODP;
        short[] PRN = new short[51];
        byte[] scale = new byte[51];
        short[] E_1_1 = new short[51];
        short[] E_2_2 = new short[51];
        short[] E_3_3 = new short[51];
        short[] E_4_4 = new short[51];
        short[] E_1_2 = new short[51];
        short[] E_1_3 = new short[51];
        short[] E_1_4 = new short[51];
        short[] E_2_3 = new short[51];
        short[] E_2_4 = new short[51];
        short[] E_3_4 = new short[51];
    }

    public static class SBASDegradationsType {
        float Brrc;
        float Cltc_lsb;
        float Cltc_v1;
        short Iltc_v1;
        float Cltc_v0;
        short Iltc_v0;
        float Cgeo_lsb;
        float Cgeo_v;
        short Igeo;
        float Cer;
        float Ciono_step;
        short Iiono;
        float Ciono_ramp;
        byte RSSudre;
        byte RSSiono;
        float Ccovariance;
    }

    public static class SBASEphemerisType {
        short PRN;
        long t0;
        long TOF;
        byte SVaccuracy;
        byte SVhealth;
        double PositionX;
        double PositionY;
        double PositionZ;
        double VelocityX;
        double VelocityY;
        double VelocityZ;
        double AccelerationX;
        double AccelerationY;
        double AccelerationZ;
        double Af0;
        double Af1;
    }

    public static class SBASIonosphericType {
        byte[] IODI = new byte[11];
        short[] numIGP = new short[11];
        long[][] IGP_t0 = new long[11][201];
        short[][] IGP_number = new short[11][201];
        short[][] IGP_latitude = new short[11][201];
        short[][] IGP_longitude = new short[11][201];
        byte[][] IGP_GIVEI = new byte[11][201];
        double[][] IGP_delay = new double[11][201];

        public byte[] getIODI() {
            return this.IODI;
        }

        public void setIODI(byte[] iODI) {
            this.IODI = iODI;
        }

        public short[] getNumIGP() {
            return this.numIGP;
        }

        public void setNumIGP(short[] numIGP) {
            this.numIGP = numIGP;
        }

        public long[][] getIGP_t0() {
            return this.IGP_t0;
        }

        public void setIGP_t0(long[][] iGP_t0) {
            this.IGP_t0 = iGP_t0;
        }

        public short[][] getIGP_number() {
            return this.IGP_number;
        }

        public void setIGP_number(short[][] iGP_number) {
            this.IGP_number = iGP_number;
        }

        public short[][] getIGP_latitude() {
            return this.IGP_latitude;
        }

        public void setIGP_latitude(short[][] iGP_latitude) {
            this.IGP_latitude = iGP_latitude;
        }

        public short[][] getIGP_longitude() {
            return this.IGP_longitude;
        }

        public void setIGP_longitude(short[][] iGP_longitude) {
            this.IGP_longitude = iGP_longitude;
        }

        public byte[][] getIGP_GIVEI() {
            return this.IGP_GIVEI;
        }

        public void setIGP_GIVEI(byte[][] iGP_GIVEI) {
            this.IGP_GIVEI = iGP_GIVEI;
        }

        public double[][] getIGP_delay() {
            return this.IGP_delay;
        }

        public void setIGP_delay(double[][] iGP_delay) {
            this.IGP_delay = iGP_delay;
        }
    }

    public static class SBASMessageType {
        int week;
        int TOW;
        short PRN;
        public byte[] message = new byte[29];
    }

    public static class SBASServiceType {
        byte IODS;
        byte numServiceMsg;
        byte ServiceMsgNumber;
        byte numRegion;
        byte priority;
        byte dUDREinside;
        byte dUDREoutside;
        short[] latitude1 = new short[5];
        short[] longitude1 = new short[5];
        short[] latitude2 = new short[5];
        short[] longitude2 = new short[5];
        byte[] FormRegion = new byte[5];
    }

    public static class SBASTimeType {
        double A0snt;
        double A1snt;
        int t0t;
        short WNt;
        short DTls;
        short WNlsf;
        short DN;
        short DTlsf;
        byte UTC;
        int TOW;
        int WN;
        byte GLO;
        double aiglonass;
    }
}

